/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter_extensions.dialog;

import android.content.Context;
import android.content.DialogInterface;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.StringRes;
import androidx.appcompat.app.AlertDialog;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.mikepenz.fastadapter.FastAdapter;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.adapters.ItemAdapter;
import com.mikepenz.fastadapter.listeners.OnClickListener;
import com.mikepenz.fastadapter.listeners.OnLongClickListener;
import com.mikepenz.fastadapter.listeners.OnTouchListener;
import java.util.List;

public class FastAdapterDialog<Item extends IItem>
extends AlertDialog {
    private RecyclerView mRecyclerView = this.createRecyclerView();
    private FastAdapter<Item> mFastAdapter;
    private ItemAdapter<Item> mItemAdapter;

    public FastAdapterDialog(Context context) {
        super(context);
    }

    public FastAdapterDialog(Context context, int theme) {
        super(context, theme);
    }

    private RecyclerView createRecyclerView() {
        RecyclerView recyclerView = new RecyclerView(this.getContext());
        RecyclerView.LayoutParams params = new RecyclerView.LayoutParams(-1, -1);
        recyclerView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.setView((View)recyclerView);
        return recyclerView;
    }

    public FastAdapterDialog<Item> withTitle(String title) {
        this.setTitle(title);
        return this;
    }

    public FastAdapterDialog<Item> withTitle(@StringRes int titleRes) {
        this.setTitle(titleRes);
        return this;
    }

    public FastAdapterDialog<Item> withFastItemAdapter(@NonNull FastAdapter<Item> fastAdapter, @NonNull ItemAdapter<Item> itemAdapter) {
        this.mFastAdapter = fastAdapter;
        this.mItemAdapter = itemAdapter;
        this.mRecyclerView.setAdapter(this.mFastAdapter);
        return this;
    }

    private void initAdapterIfNeeded() {
        if (this.mFastAdapter == null || this.mRecyclerView.getAdapter() == null) {
            this.mItemAdapter = ItemAdapter.items();
            this.mFastAdapter = FastAdapter.with(this.mItemAdapter);
            this.mRecyclerView.setAdapter(this.mFastAdapter);
        }
    }

    public FastAdapterDialog<Item> withItems(@NonNull List<Item> items) {
        this.initAdapterIfNeeded();
        this.mItemAdapter.set(items);
        return this;
    }

    public FastAdapterDialog<Item> withItems(Item ... items) {
        this.initAdapterIfNeeded();
        this.mItemAdapter.add((Object[])items);
        return this;
    }

    public FastAdapterDialog<Item> withAdapter(FastAdapter<Item> adapter) {
        this.mRecyclerView.setAdapter(adapter);
        return this;
    }

    public FastAdapterDialog<Item> withLayoutManager(RecyclerView.LayoutManager layoutManager) {
        this.mRecyclerView.setLayoutManager(layoutManager);
        return this;
    }

    public FastAdapterDialog<Item> withOnScrollListener(RecyclerView.OnScrollListener listener) {
        this.mRecyclerView.addOnScrollListener(listener);
        return this;
    }

    public FastAdapterDialog<Item> withPositiveButton(String text, DialogInterface.OnClickListener listener) {
        return this.withButton(-1, text, listener);
    }

    public FastAdapterDialog<Item> withPositiveButton(@StringRes int textRes, DialogInterface.OnClickListener listener) {
        return this.withButton(-1, textRes, listener);
    }

    public FastAdapterDialog<Item> withNegativeButton(String text, DialogInterface.OnClickListener listener) {
        return this.withButton(-2, text, listener);
    }

    public FastAdapterDialog<Item> withNegativeButton(@StringRes int textRes, DialogInterface.OnClickListener listener) {
        return this.withButton(-2, textRes, listener);
    }

    public FastAdapterDialog<Item> withNegativeButton(@StringRes int textRes) {
        return this.withButton(-2, textRes, null);
    }

    public FastAdapterDialog<Item> withNegativeButton(String text) {
        return this.withButton(-2, text, null);
    }

    public FastAdapterDialog<Item> withNeutralButton(String text, DialogInterface.OnClickListener listener) {
        return this.withButton(-3, text, listener);
    }

    public FastAdapterDialog<Item> withNeutralButton(@StringRes int textRes, DialogInterface.OnClickListener listener) {
        return this.withButton(-3, textRes, listener);
    }

    public FastAdapterDialog<Item> withButton(int whichButton, String text, DialogInterface.OnClickListener listener) {
        this.setButton(whichButton, text, listener);
        return this;
    }

    public FastAdapterDialog<Item> withButton(int whichButton, @StringRes int textRes, DialogInterface.OnClickListener listener) {
        this.setButton(whichButton, this.getContext().getString(textRes), listener);
        return this;
    }

    public void show() {
        if (this.mRecyclerView.getLayoutManager() == null) {
            this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        }
        this.initAdapterIfNeeded();
        super.show();
    }

    @NonNull
    public RecyclerView getRecyclerView() {
        return this.mRecyclerView;
    }

    public FastAdapterDialog<Item> withOnClickListener(OnClickListener<Item> onClickListener) {
        this.mFastAdapter.withOnClickListener(onClickListener);
        return this;
    }

    public FastAdapterDialog<Item> withOnPreClickListener(OnClickListener<Item> onPreClickListener) {
        this.mFastAdapter.withOnPreClickListener(onPreClickListener);
        return this;
    }

    public FastAdapterDialog<Item> withOnLongClickListener(OnLongClickListener<Item> onLongClickListener) {
        this.mFastAdapter.withOnLongClickListener(onLongClickListener);
        return this;
    }

    public FastAdapterDialog<Item> withOnPreLongClickListener(OnLongClickListener<Item> onPreLongClickListener) {
        this.mFastAdapter.withOnPreLongClickListener(onPreLongClickListener);
        return this;
    }

    public FastAdapterDialog<Item> withOnTouchListener(OnTouchListener<Item> onTouchListener) {
        this.mFastAdapter.withOnTouchListener(onTouchListener);
        return this;
    }

    public FastAdapterDialog<Item> set(List<Item> items) {
        this.mItemAdapter.set(items);
        return this;
    }

    public FastAdapterDialog<Item> setNewList(List<Item> items) {
        this.mItemAdapter.setNewList(items);
        return this;
    }

    @SafeVarargs
    public final FastAdapterDialog<Item> add(Item ... items) {
        this.mItemAdapter.add((Object[])items);
        return this;
    }

    public FastAdapterDialog<Item> add(List<Item> items) {
        this.mItemAdapter.add(items);
        return this;
    }

    @SafeVarargs
    public final FastAdapterDialog<Item> add(int position, Item ... items) {
        this.mItemAdapter.add(position, (Object[])items);
        return this;
    }

    public FastAdapterDialog<Item> add(int position, List<Item> items) {
        this.mItemAdapter.add(position, items);
        return this;
    }

    public FastAdapterDialog<Item> set(int position, Item item) {
        this.mItemAdapter.set(position, item);
        return this;
    }

    public FastAdapterDialog<Item> add(Item item) {
        this.mItemAdapter.add((Object[])new IItem[]{item});
        return this;
    }

    public FastAdapterDialog<Item> add(int position, Item item) {
        this.mItemAdapter.add(position, (Object[])new IItem[]{item});
        return this;
    }

    public FastAdapterDialog<Item> move(int fromPosition, int toPosition) {
        this.mItemAdapter.move(fromPosition, toPosition);
        return this;
    }

    public FastAdapterDialog<Item> remove(int position) {
        this.mItemAdapter.remove(position);
        return this;
    }

    public FastAdapterDialog<Item> removeItemRange(int position, int itemCount) {
        this.mItemAdapter.removeRange(position, itemCount);
        return this;
    }

    public FastAdapterDialog<Item> clear() {
        this.mItemAdapter.clear();
        return this;
    }
}

