/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter_extensions.scroll;

import android.view.View;
import androidx.recyclerview.widget.OrientationHelper;
import androidx.recyclerview.widget.RecyclerView;
import com.mikepenz.fastadapter.adapters.ItemAdapter;

public abstract class EndlessRecyclerOnScrollListener
extends RecyclerView.OnScrollListener {
    private boolean enabled = true;
    private int mPreviousTotal = 0;
    private boolean mLoading = true;
    private int mVisibleThreshold = -1;
    private int mFirstVisibleItem;
    private int mVisibleItemCount;
    private int mTotalItemCount;
    private boolean mIsOrientationHelperVertical;
    private OrientationHelper mOrientationHelper;
    private int mCurrentPage = 0;
    private ItemAdapter mFooterAdapter;
    private RecyclerView.LayoutManager mLayoutManager;

    public EndlessRecyclerOnScrollListener() {
    }

    public EndlessRecyclerOnScrollListener(ItemAdapter adapter) {
        this.mFooterAdapter = adapter;
    }

    public EndlessRecyclerOnScrollListener(RecyclerView.LayoutManager layoutManager) {
        this.mLayoutManager = layoutManager;
    }

    public EndlessRecyclerOnScrollListener(int visibleThreshold) {
        this.mVisibleThreshold = visibleThreshold;
    }

    public EndlessRecyclerOnScrollListener(RecyclerView.LayoutManager layoutManager, int visibleThreshold) {
        this.mLayoutManager = layoutManager;
        this.mVisibleThreshold = visibleThreshold;
    }

    public EndlessRecyclerOnScrollListener(RecyclerView.LayoutManager layoutManager, int visibleThreshold, ItemAdapter footerAdapter) {
        this.mLayoutManager = layoutManager;
        this.mVisibleThreshold = visibleThreshold;
        this.mFooterAdapter = footerAdapter;
    }

    private int findFirstVisibleItemPosition(RecyclerView recyclerView) {
        View child = this.findOneVisibleChild(0, this.mLayoutManager.getChildCount(), false, true);
        return child == null ? -1 : recyclerView.getChildAdapterPosition(child);
    }

    private int findLastVisibleItemPosition(RecyclerView recyclerView) {
        View child = this.findOneVisibleChild(recyclerView.getChildCount() - 1, -1, false, true);
        return child == null ? -1 : recyclerView.getChildAdapterPosition(child);
    }

    private View findOneVisibleChild(int fromIndex, int toIndex, boolean completelyVisible, boolean acceptPartiallyVisible) {
        if (this.mLayoutManager.canScrollVertically() != this.mIsOrientationHelperVertical || this.mOrientationHelper == null) {
            this.mIsOrientationHelperVertical = this.mLayoutManager.canScrollVertically();
            this.mOrientationHelper = this.mIsOrientationHelperVertical ? OrientationHelper.createVerticalHelper((RecyclerView.LayoutManager)this.mLayoutManager) : OrientationHelper.createHorizontalHelper((RecyclerView.LayoutManager)this.mLayoutManager);
        }
        int start = this.mOrientationHelper.getStartAfterPadding();
        int end = this.mOrientationHelper.getEndAfterPadding();
        int next = toIndex > fromIndex ? 1 : -1;
        View partiallyVisible = null;
        for (int i = fromIndex; i != toIndex; i += next) {
            View child = this.mLayoutManager.getChildAt(i);
            if (child == null) continue;
            int childStart = this.mOrientationHelper.getDecoratedStart(child);
            int childEnd = this.mOrientationHelper.getDecoratedEnd(child);
            if (childStart >= end || childEnd <= start) continue;
            if (completelyVisible) {
                if (childStart >= start && childEnd <= end) {
                    return child;
                }
                if (!acceptPartiallyVisible || partiallyVisible != null) continue;
                partiallyVisible = child;
                continue;
            }
            return child;
        }
        return partiallyVisible;
    }

    public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
        super.onScrolled(recyclerView, dx, dy);
        if (this.enabled) {
            int footerItemCount;
            if (this.mLayoutManager == null) {
                this.mLayoutManager = recyclerView.getLayoutManager();
            }
            int n = footerItemCount = this.mFooterAdapter != null ? this.mFooterAdapter.getAdapterItemCount() : 0;
            if (this.mVisibleThreshold == -1) {
                this.mVisibleThreshold = this.findLastVisibleItemPosition(recyclerView) - this.findFirstVisibleItemPosition(recyclerView) - footerItemCount;
            }
            this.mVisibleItemCount = recyclerView.getChildCount() - footerItemCount;
            this.mTotalItemCount = this.mLayoutManager.getItemCount() - footerItemCount;
            this.mFirstVisibleItem = this.findFirstVisibleItemPosition(recyclerView);
            if (this.mLoading && this.mTotalItemCount > this.mPreviousTotal) {
                this.mLoading = false;
                this.mPreviousTotal = this.mTotalItemCount;
            }
            if (!this.mLoading && this.mTotalItemCount - this.mVisibleItemCount <= this.mFirstVisibleItem + this.mVisibleThreshold) {
                ++this.mCurrentPage;
                this.onLoadMore(this.mCurrentPage);
                this.mLoading = true;
            }
        }
    }

    public EndlessRecyclerOnScrollListener enable() {
        this.enabled = true;
        return this;
    }

    public EndlessRecyclerOnScrollListener disable() {
        this.enabled = false;
        return this;
    }

    public void resetPageCount(int page) {
        this.mPreviousTotal = 0;
        this.mLoading = true;
        this.mCurrentPage = page;
        this.onLoadMore(this.mCurrentPage);
    }

    public void resetPageCount() {
        this.resetPageCount(0);
    }

    public RecyclerView.LayoutManager getLayoutManager() {
        return this.mLayoutManager;
    }

    public int getTotalItemCount() {
        return this.mTotalItemCount;
    }

    public int getFirstVisibleItem() {
        return this.mFirstVisibleItem;
    }

    public int getVisibleItemCount() {
        return this.mVisibleItemCount;
    }

    public int getCurrentPage() {
        return this.mCurrentPage;
    }

    public abstract void onLoadMore(int var1);
}

