/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter_extensions.scroll;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.com_mikepenz_fastadapter_extensions_scroll;
import com.mikepenz.fastadapter.IInterceptor;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.IItemAdapter;
import com.mikepenz.fastadapter.adapters.ItemAdapter;
import com.mikepenz.fastadapter.adapters.ModelAdapter;
import com.mikepenz.fastadapter_extensions.scroll.EndlessRecyclerOnScrollListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class EndlessScrollHelper<Model>
extends EndlessRecyclerOnScrollListener {
    private OnLoadMoreHandler<Model> mOnLoadMoreHandler;
    private OnNewItemsListener<Model> mOnNewItemsListener;

    public EndlessScrollHelper() {
    }

    public EndlessScrollHelper(RecyclerView.LayoutManager layoutManager) {
        super(layoutManager);
    }

    public EndlessScrollHelper(RecyclerView.LayoutManager layoutManager, int visibleThreshold) {
        super(layoutManager, visibleThreshold);
    }

    public EndlessScrollHelper(RecyclerView.LayoutManager layoutManager, int visibleThreshold, ItemAdapter footerAdapter) {
        super(layoutManager, visibleThreshold, footerAdapter);
    }

    public EndlessScrollHelper<Model> addTo(RecyclerView recyclerView) {
        recyclerView.addOnScrollListener((RecyclerView.OnScrollListener)this);
        return this;
    }

    public EndlessScrollHelper<Model> withOnLoadMoreHandler(@NonNull OnLoadMoreHandler<Model> onLoadMoreHandler) {
        this.mOnLoadMoreHandler = onLoadMoreHandler;
        return this;
    }

    public EndlessScrollHelper<Model> withOnNewItemsListener(@NonNull OnNewItemsListener<Model> onNewItemsListener) {
        this.mOnNewItemsListener = onNewItemsListener;
        return this;
    }

    public <Item extends IItem> EndlessScrollHelper<Model> withNewItemsDeliveredTo(@NonNull IItemAdapter<?, Item> itemAdapter, @NonNull IInterceptor<Model, Item> itemFactory) {
        this.mOnNewItemsListener = new DeliverToIItemAdapter<Model, Item>(itemAdapter, itemFactory);
        return this;
    }

    public EndlessScrollHelper<Model> withNewItemsDeliveredTo(@NonNull ModelAdapter<Model, ?> modelItemAdapter) {
        this.mOnNewItemsListener = new DeliverToModelAdapter<Model>(modelItemAdapter);
        return this;
    }

    public <Item extends IItem> EndlessScrollHelper<Model> withNewItemsDeliveredTo(@NonNull IItemAdapter<?, Item> itemAdapter, @NonNull IInterceptor<Model, Item> itemFactory, @NonNull OnNewItemsListener<Model> extraOnNewItemsListener) {
        this.mOnNewItemsListener = new DeliverToIItemAdapter2<Model, Item>(itemAdapter, itemFactory, extraOnNewItemsListener);
        return this;
    }

    public EndlessScrollHelper<Model> withNewItemsDeliveredTo(@NonNull ModelAdapter<Model, ?> modelItemAdapter, @NonNull OnNewItemsListener<Model> extraOnNewItemsListener) {
        this.mOnNewItemsListener = new DeliverToModelAdapter2<Model>(modelItemAdapter, extraOnNewItemsListener);
        return this;
    }

    protected void onLoadMore(@NonNull ResultReceiver<Model> out, int currentPage) {
        OnLoadMoreHandler<Model> loadMoreHandler = this.mOnLoadMoreHandler;
        try {
            loadMoreHandler.onLoadMore(out, currentPage);
        }
        catch (NullPointerException npe) {
            throw loadMoreHandler != null ? npe : new NullPointerException("You must provide an `OnLoadMoreHandler`");
        }
    }

    protected void onNewItems(@NonNull List<Model> newItems, int page) {
        OnNewItemsListener<Model> onNewItemsListener = this.mOnNewItemsListener;
        try {
            onNewItemsListener.onNewItems(newItems, page);
        }
        catch (NullPointerException npe) {
            throw onNewItemsListener != null ? npe : new NullPointerException("You must provide an `OnNewItemsListener`");
        }
    }

    @Override
    public void onLoadMore(int currentPage) {
        this.onLoadMore(new ResultReceiverImpl(this, currentPage), currentPage);
    }

    private static class DeliverToModelAdapter2<Model>
    extends DeliverToModelAdapter<Model> {
        @NonNull
        private final OnNewItemsListener<Model> mExtraOnNewItemsListener;

        DeliverToModelAdapter2(@NonNull ModelAdapter<Model, ?> modelItemAdapter, @NonNull OnNewItemsListener<Model> extraOnNewItemsListener) {
            super(modelItemAdapter);
            this.mExtraOnNewItemsListener = extraOnNewItemsListener;
        }

        @Override
        public void onNewItems(@NonNull List<Model> newItems, int page) {
            this.mExtraOnNewItemsListener.onNewItems(newItems, page);
            super.onNewItems(newItems, page);
        }
    }

    private static class DeliverToIItemAdapter2<Model, Item extends IItem>
    extends DeliverToIItemAdapter<Model, Item> {
        @NonNull
        private final OnNewItemsListener<Model> mExtraOnNewItemsListener;

        DeliverToIItemAdapter2(@NonNull IItemAdapter<?, Item> itemAdapter, @NonNull IInterceptor<Model, Item> itemFactory, @NonNull OnNewItemsListener<Model> extraOnNewItemsListener) {
            super(itemAdapter, itemFactory);
            this.mExtraOnNewItemsListener = extraOnNewItemsListener;
        }

        @Override
        public void onNewItems(@NonNull List<Model> newItems, int page) {
            this.mExtraOnNewItemsListener.onNewItems(newItems, page);
            super.onNewItems(newItems, page);
        }
    }

    private static class DeliverToModelAdapter<Model>
    implements OnNewItemsListener<Model> {
        @NonNull
        private final ModelAdapter<Model, ?> mModelAdapter;

        DeliverToModelAdapter(@NonNull ModelAdapter<Model, ?> modelItemAdapter) {
            this.mModelAdapter = modelItemAdapter;
        }

        @Override
        public void onNewItems(@NonNull List<Model> newItems, int page) {
            this.mModelAdapter.add(newItems);
        }
    }

    private static class DeliverToIItemAdapter<Model, Item extends IItem>
    implements OnNewItemsListener<Model> {
        @NonNull
        private final IItemAdapter<?, Item> mItemAdapter;
        @NonNull
        private final IInterceptor<Model, Item> mItemFactory;

        DeliverToIItemAdapter(@NonNull IItemAdapter<?, Item> itemAdapter, @NonNull IInterceptor<Model, Item> itemFactory) {
            this.mItemAdapter = itemAdapter;
            this.mItemFactory = itemFactory;
        }

        @Override
        public void onNewItems(@NonNull List<Model> newItems, int page) {
            int size = newItems.size();
            ArrayList<Object> iitems = new ArrayList<Object>(size);
            for (int i = 0; i < size; ++i) {
                iitems.add(this.mItemFactory.intercept(newItems.get(i)));
            }
            this.mItemAdapter.addInternal(iitems);
        }
    }

    private static final class ResultReceiverImpl<Model>
    extends WeakReference<EndlessScrollHelper<Model>>
    implements ResultReceiver<Model>,
    Runnable {
        private final int mReceiverPage;
        private EndlessScrollHelper<Model> mHelperStrongRef;
        private List<Model> mResult;

        ResultReceiverImpl(EndlessScrollHelper<Model> helper, int receiverPage) {
            super(helper);
            this.mReceiverPage = receiverPage;
        }

        @Override
        public int getReceiverPage() {
            return this.mReceiverPage;
        }

        @Override
        public boolean deliverNewItems(@NonNull List<Model> result) {
            if (this.mResult != null) {
                throw new IllegalStateException("`result` already provided!");
            }
            this.mResult = result;
            this.mHelperStrongRef = (EndlessScrollHelper)((Object)super.get());
            return this.mHelperStrongRef != null && com_mikepenz_fastadapter_extensions_scroll.postOnRecyclerView(this.mHelperStrongRef.getLayoutManager(), this);
        }

        @Override
        public void run() {
            try {
                if (this.mHelperStrongRef.getCurrentPage() != this.mReceiverPage) {
                    return;
                }
            }
            catch (NullPointerException npe) {
                if (this.mHelperStrongRef == null) {
                    throw new AssertionError((Object)npe);
                }
                throw npe;
            }
            this.mHelperStrongRef.onNewItems(this.mResult, this.mReceiverPage);
        }
    }

    public static interface OnNewItemsListener<Model> {
        public void onNewItems(@NonNull List<Model> var1, int var2);
    }

    public static interface OnLoadMoreHandler<Model> {
        public void onLoadMore(@NonNull ResultReceiver<Model> var1, int var2);
    }

    public static interface ResultReceiver<Model> {
        public int getReceiverPage();

        public boolean deliverNewItems(@NonNull List<Model> var1);
    }
}

