/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter_extensions.utilities;

import android.view.MotionEvent;
import android.view.View;
import androidx.core.view.MotionEventCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.mikepenz.fastadapter.adapters.ItemAdapter;
import com.mikepenz.fastadapter_extensions.drag.IExtendedDraggable;

public class DragDropUtil {
    public static void bindDragHandle(final RecyclerView.ViewHolder holder, final IExtendedDraggable item) {
        if (item.getTouchHelper() != null && item.getDragView(holder) != null) {
            item.getDragView(holder).setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    if (MotionEventCompat.getActionMasked((MotionEvent)event) == 0 && item.isDraggable()) {
                        item.getTouchHelper().startDrag(holder);
                    }
                    return false;
                }
            });
        }
    }

    public static void onMove(ItemAdapter itemAdapter, int oldPosition, int newPosition) {
        if (oldPosition < newPosition) {
            for (int i = oldPosition + 1; i <= newPosition; ++i) {
                itemAdapter.move(i, i - 1);
            }
        } else {
            for (int i = oldPosition - 1; i >= newPosition; --i) {
                itemAdapter.move(i, i + 1);
            }
        }
    }
}

