/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter_extensions.utilities;

import androidx.annotation.NonNull;
import com.mikepenz.fastadapter.FastAdapter;
import com.mikepenz.fastadapter.IAdapter;
import com.mikepenz.fastadapter.IExpandable;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.IItemAdapter;
import com.mikepenz.fastadapter.ISubItem;
import com.mikepenz.fastadapter.expandable.ExpandableExtension;
import com.mikepenz.fastadapter.select.SelectExtension;
import com.mikepenz.fastadapter.utils.AdapterPredicate;
import com.mikepenz.fastadapter.utils.Triple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class SubItemUtil {
    @Deprecated
    public static Set<IItem> getSelectedItems(FastAdapter adapter) {
        HashSet<IItem> selections = new HashSet<IItem>();
        int length = adapter.getItemCount();
        ArrayList<IItem> items = new ArrayList<IItem>();
        for (int i = 0; i < length; ++i) {
            items.add(adapter.getItem(i));
        }
        SubItemUtil.updateSelectedItemsWithCollapsed(selections, items);
        return selections;
    }

    private static void updateSelectedItemsWithCollapsed(Set<IItem> selected, List<IItem> items) {
        int length = items.size();
        for (int i = 0; i < length; ++i) {
            if (items.get(i).isSelected()) {
                selected.add(items.get(i));
            }
            if (!(items.get(i) instanceof IExpandable) || ((IExpandable)items.get(i)).getSubItems() == null) continue;
            SubItemUtil.updateSelectedItemsWithCollapsed(selected, ((IExpandable)items.get(i)).getSubItems());
        }
    }

    public static int countItems(IItemAdapter adapter, IPredicate predicate) {
        return SubItemUtil.countItems(adapter.getAdapterItems(), true, false, predicate);
    }

    public static int countItems(IItemAdapter adapter, boolean countHeaders) {
        return SubItemUtil.countItems(adapter.getAdapterItems(), countHeaders, false, null);
    }

    private static int countItems(List<IItem> items, boolean countHeaders, boolean subItemsOnly, IPredicate predicate) {
        return SubItemUtil.getAllItems(items, countHeaders, subItemsOnly, predicate).size();
    }

    public static List<IItem> getAllItems(IItemAdapter adapter, IPredicate predicate) {
        return SubItemUtil.getAllItems(adapter.getAdapterItems(), true, false, predicate);
    }

    public static List<IItem> getAllItems(IItemAdapter adapter, boolean countHeaders) {
        return SubItemUtil.getAllItems(adapter.getAdapterItems(), countHeaders, false, null);
    }

    public static List<IItem> getAllItems(List<IItem> items, boolean countHeaders, IPredicate predicate) {
        return SubItemUtil.getAllItems(items, countHeaders, false, predicate);
    }

    private static List<IItem> getAllItems(List<IItem> items, boolean countHeaders, boolean subItemsOnly, IPredicate predicate) {
        ArrayList<IItem> res = new ArrayList<IItem>();
        if (items == null || items.size() == 0) {
            return res;
        }
        int itemCount = items.size();
        for (int i = 0; i < itemCount; ++i) {
            IItem item = items.get(i);
            if (item instanceof IExpandable && ((IExpandable)item).getSubItems() != null) {
                List subItems = ((IExpandable)item).getSubItems();
                if (predicate == null) {
                    if (countHeaders) {
                        res.add(item);
                    }
                    if (subItems != null && subItems.size() > 0) {
                        res.addAll(subItems);
                    }
                    res.addAll(SubItemUtil.getAllItems(subItems, countHeaders, true, predicate));
                    continue;
                }
                if (countHeaders && predicate.apply(item)) {
                    res.add(item);
                }
                int temp = subItems != null ? subItems.size() : 0;
                for (int j = 0; j < temp; ++j) {
                    if (!predicate.apply(subItems.get(j))) continue;
                    res.add((IItem)subItems.get(j));
                }
                continue;
            }
            if (subItemsOnly || SubItemUtil.getParent(item) != null) continue;
            if (predicate == null) {
                res.add(item);
                continue;
            }
            if (!predicate.apply(item)) continue;
            res.add(item);
        }
        return res;
    }

    public static <T extends IItem & IExpandable> int countSelectedSubItems(FastAdapter adapter, T header) {
        SelectExtension extension = (SelectExtension)adapter.getExtension(SelectExtension.class);
        if (extension != null) {
            Set selections = extension.getSelectedItems();
            return SubItemUtil.countSelectedSubItems(selections, header);
        }
        return 0;
    }

    public static <T extends IItem & IExpandable> int countSelectedSubItems(Set<IItem> selections, T header) {
        int count = 0;
        List subItems = ((IExpandable)header).getSubItems();
        int items = ((IExpandable)header).getSubItems() != null ? ((IExpandable)header).getSubItems().size() : 0;
        for (int i = 0; i < items; ++i) {
            if (selections.contains(subItems.get(i))) {
                ++count;
            }
            if (!(subItems.get(i) instanceof IExpandable) || ((IExpandable)subItems.get(i)).getSubItems() == null) continue;
            count += SubItemUtil.countSelectedSubItems(selections, (IItem)subItems.get(i));
        }
        return count;
    }

    public static <T extends IItem & IExpandable> void selectAllSubItems(FastAdapter adapter, T header, boolean select) {
        SubItemUtil.selectAllSubItems(adapter, header, select, false, null);
    }

    public static <T extends IItem & IExpandable> void selectAllSubItems(FastAdapter adapter, T header, boolean select, boolean notifyParent, Object payload) {
        int subItems = ((IExpandable)header).getSubItems().size();
        int position = adapter.getPosition(header);
        if (((IExpandable)header).isExpanded()) {
            for (int i = 0; i < subItems; ++i) {
                SelectExtension extension;
                if (((IItem)((IExpandable)header).getSubItems().get(i)).isSelectable() && (extension = (SelectExtension)adapter.getExtension(SelectExtension.class)) != null) {
                    if (select) {
                        extension.select(position + i + 1);
                    } else {
                        extension.deselect(position + i + 1);
                    }
                }
                if (!(((IExpandable)header).getSubItems().get(i) instanceof IExpandable)) continue;
                SubItemUtil.selectAllSubItems(adapter, header, select, notifyParent, payload);
            }
        } else {
            for (int i = 0; i < subItems; ++i) {
                if (((IItem)((IExpandable)header).getSubItems().get(i)).isSelectable()) {
                    ((IItem)((IExpandable)header).getSubItems().get(i)).withSetSelected(select);
                }
                if (!(((IExpandable)header).getSubItems().get(i) instanceof IExpandable)) continue;
                SubItemUtil.selectAllSubItems(adapter, header, select, notifyParent, payload);
            }
        }
        if (notifyParent && position >= 0) {
            adapter.notifyItemChanged(position, payload);
        }
    }

    @Deprecated
    public static boolean selectItem(final FastAdapter adapter, final long identifier, final boolean select) {
        Triple res = adapter.recursive(new AdapterPredicate(){

            public boolean apply(@NonNull IAdapter lastParentAdapter, int lastParentPosition, @NonNull IItem item, int position) {
                if (item.getIdentifier() == identifier) {
                    if (position != -1) {
                        SelectExtension extension = (SelectExtension)adapter.getExtension(SelectExtension.class);
                        if (extension != null) {
                            if (select) {
                                extension.select(position);
                            } else {
                                extension.deselect(position);
                            }
                        }
                    } else {
                        item.withSetSelected(select);
                    }
                    return true;
                }
                return false;
            }
        }, true);
        return (Boolean)res.first;
    }

    @Deprecated
    public static void deselect(final FastAdapter adapter) {
        adapter.recursive(new AdapterPredicate(){

            public boolean apply(@NonNull IAdapter lastParentAdapter, int lastParentPosition, @NonNull IItem item, int position) {
                if (position != -1) {
                    SelectExtension extension = (SelectExtension)adapter.getExtension(SelectExtension.class);
                    if (extension != null) {
                        extension.deselect(position);
                    }
                } else {
                    item.withSetSelected(false);
                }
                return true;
            }
        }, false);
    }

    private static <T extends IExpandable & IItem> T getParent(IItem item) {
        if (item instanceof ISubItem) {
            return (T)((IExpandable)((ISubItem)item).getParent());
        }
        return null;
    }

    public static List<IItem> deleteSelected(FastAdapter fastAdapter, ExpandableExtension expandableExtension, boolean notifyParent, boolean deleteEmptyHeaders) {
        ArrayList<IItem> deleted = new ArrayList<IItem>();
        LinkedList<IItem> selectedItems = new LinkedList<IItem>(SubItemUtil.getSelectedItems(fastAdapter));
        ListIterator<IItem> it = selectedItems.listIterator();
        while (it.hasNext()) {
            IItem item = (IItem)it.next();
            int pos = fastAdapter.getPosition(item);
            IItem parent = (IItem)SubItemUtil.getParent(item);
            if (parent != null) {
                int parentPos = fastAdapter.getPosition(parent);
                boolean success = ((IExpandable)parent).getSubItems().remove(item);
                if (parentPos != -1 && ((IExpandable)parent).isExpanded()) {
                    expandableExtension.notifyAdapterSubItemsChanged(parentPos, ((IExpandable)parent).getSubItems().size() + 1);
                }
                if (parentPos != -1 && notifyParent) {
                    boolean expanded = ((IExpandable)parent).isExpanded();
                    fastAdapter.notifyAdapterItemChanged(parentPos);
                    if (expanded) {
                        expandableExtension.expand(parentPos);
                    }
                }
                deleted.add(item);
                if (!deleteEmptyHeaders || ((IExpandable)parent).getSubItems().size() != 0) continue;
                it.add(parent);
                it.previous();
                continue;
            }
            if (pos == -1) continue;
            IAdapter adapter = fastAdapter.getAdapter(pos);
            boolean success = false;
            if (adapter instanceof IItemAdapter) {
                success = ((IItemAdapter)adapter).remove(pos) != null;
            }
            boolean isHeader = item instanceof IExpandable && ((IExpandable)item).getSubItems() != null;
            deleted.add(item);
        }
        return deleted;
    }

    public static List<IItem> delete(FastAdapter fastAdapter, ExpandableExtension expandableExtension, Collection<Long> identifiersToDelete, boolean notifyParent, boolean deleteEmptyHeaders) {
        ArrayList<IItem> deleted = new ArrayList<IItem>();
        if (identifiersToDelete == null || identifiersToDelete.size() == 0) {
            return deleted;
        }
        LinkedList<Long> identifiers = new LinkedList<Long>(identifiersToDelete);
        ListIterator<Long> it = identifiers.listIterator();
        while (it.hasNext()) {
            Long identifier = (Long)it.next();
            int pos = fastAdapter.getPosition(identifier.longValue());
            IItem item = fastAdapter.getItem(pos);
            IItem parent = (IItem)SubItemUtil.getParent(item);
            if (parent != null) {
                int parentPos = fastAdapter.getPosition(parent);
                boolean success = ((IExpandable)parent).getSubItems().remove(item);
                if (parentPos != -1 && ((IExpandable)parent).isExpanded()) {
                    expandableExtension.notifyAdapterSubItemsChanged(parentPos, ((IExpandable)parent).getSubItems().size() + 1);
                }
                if (parentPos != -1 && notifyParent) {
                    boolean expanded = ((IExpandable)parent).isExpanded();
                    fastAdapter.notifyAdapterItemChanged(parentPos);
                    if (expanded) {
                        expandableExtension.expand(parentPos);
                    }
                }
                deleted.add(item);
                if (!deleteEmptyHeaders || ((IExpandable)parent).getSubItems().size() != 0) continue;
                it.add(parent.getIdentifier());
                it.previous();
                continue;
            }
            if (pos == -1) continue;
            IAdapter adapter = fastAdapter.getAdapter(pos);
            boolean success = false;
            if (adapter instanceof IItemAdapter) {
                boolean bl = success = ((IItemAdapter)adapter).remove(pos) != null;
                if (success) {
                    fastAdapter.notifyAdapterItemRemoved(pos);
                }
            }
            boolean isHeader = item instanceof IExpandable && ((IExpandable)item).getSubItems() != null;
            deleted.add(item);
        }
        return deleted;
    }

    public static <Item extends IItem & IExpandable> void notifyItemsChanged(FastAdapter adapter, ExpandableExtension expandableExtension, Set<Long> identifiers) {
        SubItemUtil.notifyItemsChanged(adapter, expandableExtension, identifiers, false);
    }

    public static <Item extends IItem & IExpandable> void notifyItemsChanged(FastAdapter adapter, ExpandableExtension expandableExtension, Set<Long> identifiers, boolean restoreExpandedState) {
        for (int i = 0; i < adapter.getItemCount(); ++i) {
            IItem item = adapter.getItem(i);
            if (item instanceof IExpandable) {
                SubItemUtil.notifyItemsChanged(adapter, expandableExtension, item, identifiers, true, restoreExpandedState);
                continue;
            }
            if (!identifiers.contains(item.getIdentifier())) continue;
            adapter.notifyAdapterItemChanged(i);
        }
    }

    public static <Item extends IItem & IExpandable> void notifyItemsChanged(FastAdapter adapter, ExpandableExtension expandableExtension, Item header, Set<Long> identifiers, boolean checkSubItems, boolean restoreExpandedState) {
        int subItems = ((IExpandable)header).getSubItems().size();
        int position = adapter.getPosition(header);
        boolean expanded = ((IExpandable)header).isExpanded();
        if (identifiers.contains(header.getIdentifier())) {
            adapter.notifyAdapterItemChanged(position);
        }
        if (((IExpandable)header).isExpanded()) {
            for (int i = 0; i < subItems; ++i) {
                IItem item = (IItem)((IExpandable)header).getSubItems().get(i);
                if (identifiers.contains(item.getIdentifier())) {
                    adapter.notifyAdapterItemChanged(position + i + 1);
                }
                if (!checkSubItems || !(item instanceof IExpandable)) continue;
                SubItemUtil.notifyItemsChanged(adapter, expandableExtension, item, identifiers, true, restoreExpandedState);
            }
        }
        if (restoreExpandedState && expanded) {
            expandableExtension.expand(position);
        }
    }

    public static interface IPredicate<T> {
        public boolean apply(T var1);
    }
}

