/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.adapters;

import android.support.annotation.Nullable;
import com.mikepenz.fastadapter.IGenericItem;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.adapters.ItemAdapter;
import com.mikepenz.fastadapter.utils.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class GenericItemAdapter<Model, Item extends IGenericItem<? extends Model, ?, ?>>
extends ItemAdapter<Item> {
    private final Function<Model, Item> mItemFactory;

    public GenericItemAdapter(Function<Model, Item> itemFactory) {
        this.mItemFactory = itemFactory;
    }

    public List<Model> getModels() {
        int size = this.getAdapterItems().size();
        ArrayList models = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            models.add(((IGenericItem)this.getAdapterItems().get(i)).getModel());
        }
        return models;
    }

    public GenericItemAdapter<Model, Item> setModel(List<Model> models) {
        super.set((List)this.toItems(models));
        return this;
    }

    public GenericItemAdapter<Model, Item> setNewModel(List<Model> models) {
        super.setNewList((List)this.toItems(models));
        return this;
    }

    @SafeVarargs
    public final GenericItemAdapter<Model, Item> addModel(Model ... models) {
        this.addModel(Arrays.asList(models));
        return this;
    }

    public GenericItemAdapter<Model, Item> addModel(List<Model> models) {
        super.add((List)this.toItems(models));
        return this;
    }

    @SafeVarargs
    public final GenericItemAdapter<Model, Item> addModel(int position, Model ... models) {
        this.addModel(position, Arrays.asList(models));
        return this;
    }

    public GenericItemAdapter<Model, Item> addModel(int position, List<Model> models) {
        super.add(position, (List)this.toItems(models));
        return this;
    }

    public GenericItemAdapter<Model, Item> setModel(int position, Model model) {
        Item item = this.toItem(model);
        if (item != null) {
            super.set(position, (IItem)item);
        }
        return this;
    }

    public GenericItemAdapter<Model, Item> clearModel() {
        super.clear();
        return this;
    }

    public GenericItemAdapter<Model, Item> moveModel(int fromPosition, int toPosition) {
        super.move(fromPosition, toPosition);
        return this;
    }

    public GenericItemAdapter<Model, Item> removeModelRange(int position, int itemCount) {
        super.removeRange(position, itemCount);
        return this;
    }

    public GenericItemAdapter<Model, Item> removeModel(int position) {
        super.remove(position);
        return this;
    }

    protected List<Item> toItems(List<Model> models) {
        if (models == null) {
            return Collections.emptyList();
        }
        int size = models.size();
        ArrayList<Item> items = new ArrayList<Item>(size);
        for (int i = 0; i < size; ++i) {
            Item item = this.toItem(models.get(i));
            if (item == null) continue;
            items.add(item);
        }
        return items;
    }

    @Nullable
    protected Item toItem(Model model) {
        return (Item)((IGenericItem)this.mItemFactory.apply(model));
    }
}

