/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.iconics.context;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.StyleableRes;
import com.mikepenz.iconics.Iconics;
import com.mikepenz.iconics.IconicsDrawable;
import com.mikepenz.iconics.animation.IconicsAnimationProcessor;
import java.util.ArrayList;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class IconicsAttrsExtractor {
    private static final int DEF_COLOR = Integer.MIN_VALUE;
    private static final int DEF_SIZE = -1;
    @NonNull
    private final Context mContext;
    @NonNull
    private final TypedArray mTypedArray;
    @StyleableRes
    private int mIconId;
    @StyleableRes
    private int mSizeId;
    @StyleableRes
    private int mColorsId;
    @StyleableRes
    private int mPaddingId;
    @StyleableRes
    private int mOffsetXId;
    @StyleableRes
    private int mOffsetYId;
    @StyleableRes
    private int mContourColorId;
    @StyleableRes
    private int mContourWidthId;
    @StyleableRes
    private int mBackgroundColorId;
    @StyleableRes
    private int mCornerRadiusId;
    @StyleableRes
    private int mBackgroundContourColorId;
    @StyleableRes
    private int mBackgroundContourWidthId;
    @StyleableRes
    private int mShadowRadiusId;
    @StyleableRes
    private int mShadowDxId;
    @StyleableRes
    private int mShadowDyId;
    @StyleableRes
    private int mShadowColorId;
    @StyleableRes
    private int mAnimationsId;

    public IconicsAttrsExtractor(@NonNull Context context, @NonNull TypedArray typedArray) {
        this.mContext = context;
        this.mTypedArray = typedArray;
    }

    @NonNull
    public IconicsAttrsExtractor iconId(@StyleableRes int iconId) {
        this.mIconId = iconId;
        return this;
    }

    @NonNull
    public IconicsAttrsExtractor sizeId(@StyleableRes int sizeId) {
        this.mSizeId = sizeId;
        return this;
    }

    @NonNull
    public IconicsAttrsExtractor colorsId(@StyleableRes int colorsId) {
        this.mColorsId = colorsId;
        return this;
    }

    @NonNull
    public IconicsAttrsExtractor paddingId(@StyleableRes int paddingId) {
        this.mPaddingId = paddingId;
        return this;
    }

    @NonNull
    public IconicsAttrsExtractor offsetXId(@StyleableRes int offsetXId) {
        this.mOffsetXId = offsetXId;
        return this;
    }

    @NonNull
    public IconicsAttrsExtractor offsetYId(@StyleableRes int offsetYId) {
        this.mOffsetYId = offsetYId;
        return this;
    }

    @NonNull
    public IconicsAttrsExtractor contourColorId(@StyleableRes int contourColorId) {
        this.mContourColorId = contourColorId;
        return this;
    }

    @NonNull
    public IconicsAttrsExtractor contourWidthId(@StyleableRes int contourWidthId) {
        this.mContourWidthId = contourWidthId;
        return this;
    }

    @NonNull
    public IconicsAttrsExtractor backgroundColorId(@StyleableRes int backgroundColorId) {
        this.mBackgroundColorId = backgroundColorId;
        return this;
    }

    @NonNull
    public IconicsAttrsExtractor cornerRadiusId(@StyleableRes int cornerRadiusId) {
        this.mCornerRadiusId = cornerRadiusId;
        return this;
    }

    @NonNull
    public IconicsAttrsExtractor backgroundContourColorId(@StyleableRes int backgroundContourColorId) {
        this.mBackgroundContourColorId = backgroundContourColorId;
        return this;
    }

    @NonNull
    public IconicsAttrsExtractor backgroundContourWidthId(@StyleableRes int backgroundContourWidthId) {
        this.mBackgroundContourWidthId = backgroundContourWidthId;
        return this;
    }

    @NonNull
    public IconicsAttrsExtractor shadowRadiusId(@StyleableRes int shadowRadiusId) {
        this.mShadowRadiusId = shadowRadiusId;
        return this;
    }

    @NonNull
    public IconicsAttrsExtractor shadowDxId(@StyleableRes int shadowDxId) {
        this.mShadowDxId = shadowDxId;
        return this;
    }

    @NonNull
    public IconicsAttrsExtractor shadowDyId(@StyleableRes int shadowDyId) {
        this.mShadowDyId = shadowDyId;
        return this;
    }

    @NonNull
    public IconicsAttrsExtractor shadowColorId(@StyleableRes int shadowColorId) {
        this.mShadowColorId = shadowColorId;
        return this;
    }

    @NonNull
    public IconicsAttrsExtractor animationsId(@StyleableRes int animationsId) {
        this.mAnimationsId = animationsId;
        return this;
    }

    @NonNull
    public IconicsDrawable extractNonNull() {
        return this.extract(null, false, true);
    }

    @Nullable
    public IconicsDrawable extract(@Nullable IconicsDrawable icon) {
        return this.extract(icon, false, false);
    }

    @Nullable
    public IconicsDrawable extract() {
        return this.extract(null, false, false);
    }

    @Nullable
    public IconicsDrawable extractWithOffsets() {
        return this.extract(null, true, false);
    }

    private IconicsDrawable extract(@Nullable IconicsDrawable icon, boolean extractOffsets, boolean nonNull) {
        String animations;
        int backgroundContourWidth;
        ColorStateList backgroundContourColor;
        int cornerRadius;
        ColorStateList backgroundColor;
        int contourWidth;
        ColorStateList contourColor;
        int padding;
        int size;
        ColorStateList colors;
        icon = IconicsAttrsExtractor.copyIfCan(icon);
        String i = this.mTypedArray.getString(this.mIconId);
        if (!TextUtils.isEmpty((CharSequence)i)) {
            icon = IconicsAttrsExtractor.createIfNeeds(icon, this.mContext).icon(i);
        }
        if ((colors = this.mTypedArray.getColorStateList(this.mColorsId)) != null) {
            icon = IconicsAttrsExtractor.createIfNeeds(icon, this.mContext).color(colors);
        }
        if ((size = this.mTypedArray.getDimensionPixelSize(this.mSizeId, -1)) != -1) {
            icon = IconicsAttrsExtractor.createIfNeeds(icon, this.mContext).sizePx(size);
        }
        if ((padding = this.mTypedArray.getDimensionPixelSize(this.mPaddingId, -1)) != -1) {
            icon = IconicsAttrsExtractor.createIfNeeds(icon, this.mContext).paddingPx(padding);
        }
        if (extractOffsets) {
            int offsetX;
            int offsetY = this.mTypedArray.getDimensionPixelSize(this.mOffsetYId, -1);
            if (offsetY != -1) {
                icon = IconicsAttrsExtractor.createIfNeeds(icon, this.mContext).iconOffsetYPx(offsetY);
            }
            if ((offsetX = this.mTypedArray.getDimensionPixelSize(this.mOffsetXId, -1)) != -1) {
                icon = IconicsAttrsExtractor.createIfNeeds(icon, this.mContext).iconOffsetXPx(offsetX);
            }
        }
        if ((contourColor = this.mTypedArray.getColorStateList(this.mContourColorId)) != null) {
            icon = IconicsAttrsExtractor.createIfNeeds(icon, this.mContext).contourColor(contourColor);
        }
        if ((contourWidth = this.mTypedArray.getDimensionPixelSize(this.mContourWidthId, -1)) != -1) {
            icon = IconicsAttrsExtractor.createIfNeeds(icon, this.mContext).contourWidthPx(contourWidth);
        }
        if ((backgroundColor = this.mTypedArray.getColorStateList(this.mBackgroundColorId)) != null) {
            icon = IconicsAttrsExtractor.createIfNeeds(icon, this.mContext).backgroundColor(backgroundColor);
        }
        if ((cornerRadius = this.mTypedArray.getDimensionPixelSize(this.mCornerRadiusId, -1)) != -1) {
            icon = IconicsAttrsExtractor.createIfNeeds(icon, this.mContext).roundedCornersPx(cornerRadius);
        }
        if ((backgroundContourColor = this.mTypedArray.getColorStateList(this.mBackgroundContourColorId)) != null) {
            icon = IconicsAttrsExtractor.createIfNeeds(icon, this.mContext).backgroundContourColor(backgroundContourColor);
        }
        if ((backgroundContourWidth = this.mTypedArray.getDimensionPixelSize(this.mBackgroundContourWidthId, -1)) != -1) {
            icon = IconicsAttrsExtractor.createIfNeeds(icon, this.mContext).backgroundContourWidthPx(backgroundContourWidth);
        }
        int shadowRadius = this.mTypedArray.getDimensionPixelSize(this.mShadowRadiusId, -1);
        int shadowDx = this.mTypedArray.getDimensionPixelSize(this.mShadowDxId, -1);
        int shadowDy = this.mTypedArray.getDimensionPixelSize(this.mShadowDyId, -1);
        int shadowColor = this.mTypedArray.getColor(this.mShadowColorId, Integer.MIN_VALUE);
        if (shadowRadius != -1 && shadowDx != -1 && shadowDy != -1 && shadowColor != Integer.MIN_VALUE) {
            icon = IconicsAttrsExtractor.createIfNeeds(icon, this.mContext).shadowPx(shadowRadius, shadowDx, shadowDy, shadowColor);
        }
        if (!TextUtils.isEmpty((CharSequence)(animations = this.mTypedArray.getString(this.mAnimationsId)))) {
            String[] animationsList;
            ArrayList<IconicsAnimationProcessor> processors = new ArrayList<IconicsAnimationProcessor>();
            for (String animationTag : animationsList = animations.split("\\|")) {
                IconicsAnimationProcessor processor = Iconics.findProcessor(this.mContext, animationTag);
                if (processor == null) continue;
                processors.add(processor);
            }
            icon = IconicsAttrsExtractor.createIfNeeds(icon, this.mContext).toAnimatedDrawable().processors(processors.toArray(new IconicsAnimationProcessor[0]));
        }
        if (nonNull) {
            icon = IconicsAttrsExtractor.createIfNeeds(icon, this.mContext);
        }
        return icon;
    }

    @Nullable
    private static IconicsDrawable copyIfCan(@Nullable IconicsDrawable drawable) {
        if (drawable != null) {
            return drawable.clone();
        }
        return null;
    }

    @NonNull
    private static IconicsDrawable createIfNeeds(@Nullable IconicsDrawable drawable, @NonNull Context context) {
        if (drawable == null) {
            drawable = new IconicsDrawable(context);
        }
        return drawable;
    }
}

