/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.iconics.context;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.appcompat.view.menu.ActionMenuItemView;
import com.mikepenz.iconics.Iconics;
import com.mikepenz.iconics.IconicsDrawable;
import com.mikepenz.iconics.animation.IconicsAnimatedDrawable;
import com.mikepenz.iconics.context.IconicsAttrsApplier;
import com.mikepenz.iconics.core.R;

class IconicsFactory {
    IconicsFactory() {
    }

    View onViewCreated(View view, Context context, AttributeSet attrs) {
        if (view != null && view.getTag(R.id.iconics_tag_id) != Boolean.TRUE) {
            this.onViewCreatedInternal(view, context, attrs);
            view.setTag(R.id.iconics_tag_id, (Object)Boolean.TRUE);
        }
        return view;
    }

    @SuppressLint(value={"RestrictedApi"})
    private void onViewCreatedInternal(View view, final Context context, AttributeSet attrs) {
        IconicsDrawable drawable;
        if (attrs == null) {
            return;
        }
        if (view instanceof ActionMenuItemView) {
            IconicsDrawable drawable2 = IconicsAttrsApplier.getIconicsDrawable(context, attrs);
            if (drawable2 != null) {
                ((ActionMenuItemView)view).setIcon((Drawable)drawable2);
                if (drawable2 instanceof IconicsAnimatedDrawable) {
                    ((IconicsAnimatedDrawable)drawable2).animateIn(view);
                }
            }
        } else if (view instanceof EditText) {
            new Iconics.IconicsBuilder().ctx(context).on((TextView)view).build();
        } else if (view instanceof TextView) {
            new Iconics.IconicsBuilder().ctx(context).on((TextView)view).build();
            ((TextView)view).addTextChangedListener(new TextWatcher(){

                public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                }

                public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                }

                public void afterTextChanged(Editable editable) {
                    Iconics.styleEditable(context, editable);
                }
            });
        } else if (view instanceof ImageView && (drawable = IconicsAttrsApplier.getIconicsDrawable(context, attrs)) != null) {
            ((ImageView)view).setImageDrawable((Drawable)drawable);
            if (drawable instanceof IconicsAnimatedDrawable) {
                ((IconicsAnimatedDrawable)drawable).animateIn(view);
            }
        }
    }
}

