/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.iconics.utils;

import android.content.Context;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Xml;
import android.view.Menu;
import android.view.MenuInflater;
import androidx.annotation.NonNull;
import com.mikepenz.iconics.IconicsDrawable;
import com.mikepenz.iconics.context.IconicsAttrsApplier;
import java.io.IOException;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class IconicsMenuInflaterUtil {
    private static final String XML_MENU = "menu";
    private static final String XML_ITEM = "item";

    public static void inflate(@NonNull MenuInflater inflater, @NonNull Context context, int menuId, @NonNull Menu menu) {
        IconicsMenuInflaterUtil.inflate(inflater, context, menuId, menu, false);
    }

    public static void inflate(@NonNull MenuInflater inflater, @NonNull Context context, int menuId, @NonNull Menu menu, boolean checkSubMenus) {
        inflater.inflate(menuId, menu);
        IconicsMenuInflaterUtil.parseXmlAndSetIconicsDrawables(context, menuId, menu, checkSubMenus);
    }

    public static void parseXmlAndSetIconicsDrawables(@NonNull Context context, int menuId, @NonNull Menu menu, boolean checkSubMenus) {
        try {
            XmlResourceParser parser = context.getResources().getXml(menuId);
            AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
            IconicsMenuInflaterUtil.parseMenu(context, attrs, (XmlPullParser)parser, menu, checkSubMenus);
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void parseMenu(@NonNull Context context, @NonNull AttributeSet attrs, @NonNull XmlPullParser parser, @NonNull Menu menu, boolean checkSubMenus) throws XmlPullParserException, IOException {
        String tagName;
        int eventType = parser.getEventType();
        boolean lookingForEndOfUnknownTag = false;
        String unknownTagName = null;
        do {
            if (eventType != 2) continue;
            tagName = parser.getName();
            if (XML_MENU.equals(tagName)) {
                eventType = parser.next();
                break;
            }
            throw new RuntimeException("Expecting menu, got " + tagName);
        } while ((eventType = parser.next()) != 1);
        boolean reachedEndOfMenu = false;
        while (!reachedEndOfMenu) {
            block0 : switch (eventType) {
                case 2: {
                    if (lookingForEndOfUnknownTag) break;
                    switch (tagName = parser.getName()) {
                        case "item": {
                            HashMap<String, String> attrsMap = new HashMap<String, String>();
                            for (int i = 0; i < parser.getAttributeCount(); ++i) {
                                attrsMap.put(parser.getAttributeName(i), parser.getAttributeValue(i));
                            }
                            IconicsDrawable icon = IconicsAttrsApplier.getIconicsDrawable(context, attrs);
                            if (icon == null) break block0;
                            String idAsString = ((String)attrsMap.get("id")).replace("@", "");
                            if (idAsString.startsWith("+id/")) {
                                idAsString = idAsString.replace("+id/", "");
                            }
                            int id2 = context.getResources().getIdentifier(idAsString, "id", context.getPackageName());
                            menu.findItem(id2).setIcon((Drawable)icon);
                            break;
                        }
                        case "menu": {
                            if (!checkSubMenus) break block0;
                            IconicsMenuInflaterUtil.parseMenu(context, attrs, parser, menu, true);
                            break;
                        }
                        default: {
                            lookingForEndOfUnknownTag = true;
                            unknownTagName = tagName;
                            break;
                        }
                    }
                    break;
                }
                case 3: {
                    tagName = parser.getName();
                    if (lookingForEndOfUnknownTag && tagName.equals(unknownTagName)) {
                        lookingForEndOfUnknownTag = false;
                        unknownTagName = null;
                        break;
                    }
                    if (!XML_MENU.equals(tagName)) break;
                    reachedEndOfMenu = true;
                    break;
                }
                case 1: {
                    throw new RuntimeException("Unexpected end of document");
                }
            }
            eventType = parser.next();
        }
    }
}

