/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.iconics;

import android.content.res.ColorStateList;
import android.graphics.Paint;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class IconicsBrush<T extends Paint> {
    @Nullable
    private ColorStateList mColors;
    @NonNull
    private final T mPaint;
    @Nullable
    private int[] mState;

    public IconicsBrush(@NonNull T paint) {
        this.mPaint = paint;
    }

    public IconicsBrush<T> setColors(@Nullable ColorStateList colors) {
        this.mColors = colors;
        return this;
    }

    @Nullable
    public ColorStateList getColorsList() {
        return this.mColors;
    }

    @NonNull
    public T getPaint() {
        return this.mPaint;
    }

    public void setAlpha(@IntRange(from=0L, to=255L) int alpha) {
        if (this.mPaint.getAlpha() != alpha) {
            this.mPaint.setAlpha(alpha);
        }
    }

    @IntRange(from=0L, to=255L)
    public int getAlpha() {
        return this.mPaint.getAlpha();
    }

    boolean isStateful() {
        return this.mColors != null && this.mColors.isStateful();
    }

    int getColorForCurrentState(int defaultColor) {
        if (this.mColors != null) {
            return this.mColors.getColorForState(this.mState, defaultColor);
        }
        return defaultColor;
    }

    int getColorForCurrentState() {
        if (this.mColors != null) {
            return this.getColorForCurrentState(this.mColors.getDefaultColor());
        }
        return 0;
    }

    boolean applyState(@NonNull int[] state) {
        this.mState = state;
        int colorForState = this.getColorForCurrentState();
        int oldColor = this.mPaint.getColor();
        this.mPaint.setColor(colorForState);
        return this.mPaint.getColor() != oldColor;
    }
}

