/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.iconics.animation;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import com.mikepenz.iconics.IconicsDrawable;
import com.mikepenz.iconics.animation.IconicsAnimationProcessor;
import com.mikepenz.iconics.typeface.IIcon;
import com.mikepenz.iconics.typeface.ITypeface;
import java.util.ArrayList;
import java.util.List;

public class IconicsAnimatedDrawable
extends IconicsDrawable {
    @NonNull
    private List<IconicsAnimationProcessor> mProcessors = new ArrayList<IconicsAnimationProcessor>();

    public IconicsAnimatedDrawable(Context context) {
        super(context);
    }

    public IconicsAnimatedDrawable(Context context, Character icon) {
        super(context, icon);
    }

    public IconicsAnimatedDrawable(Context context, String icon) {
        super(context, icon);
    }

    public IconicsAnimatedDrawable(Context context, IIcon icon) {
        super(context, icon);
    }

    protected IconicsAnimatedDrawable(Context context, ITypeface typeface, IIcon icon) {
        super(context, typeface, icon);
    }

    @Override
    public int getAlpha() {
        return this.mIconBrush.getAlpha();
    }

    @Override
    public int getCompatAlpha() {
        return this.mIconBrush.getAlpha();
    }

    @Override
    public void draw(@NonNull Canvas canvas) {
        IconicsAnimationProcessor p;
        int i;
        for (i = 0; i < this.mProcessors.size(); ++i) {
            p = this.mProcessors.get(i);
            p.processPreDraw(canvas, this.mIconBrush, this.mContourBrush, this.mBackgroundBrush, this.mBackgroundContourBrush);
        }
        super.draw(canvas);
        for (i = this.mProcessors.size() - 1; i >= 0; --i) {
            p = this.mProcessors.get(i);
            p.processPostDraw(canvas);
        }
    }

    @NonNull
    public IconicsAnimatedDrawable processor(@NonNull IconicsAnimationProcessor processor) {
        if (processor == null) {
            return this;
        }
        processor.setDrawable(this);
        this.mProcessors.add(processor);
        return this;
    }

    @NonNull
    public IconicsAnimatedDrawable processors(IconicsAnimationProcessor ... processors) {
        if (processors == null || processors.length == 0) {
            return this;
        }
        for (IconicsAnimationProcessor processor : processors) {
            this.processor(processor);
        }
        return this;
    }

    @NonNull
    public Runner animateIn(@Nullable View view) {
        Runner runner = new Runner();
        runner.setFor(view, this);
        return runner;
    }

    public static class Runner {
        private boolean mIsAttached = false;
        @Nullable
        private View mView;
        @Nullable
        private IconicsAnimatedDrawable mDrawable;
        private View.OnAttachStateChangeListener mListener = new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(final @NonNull View v) {
                mIsAttached = true;
                ViewCompat.postOnAnimation((View)v, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (mIsAttached && mDrawable != null) {
                            v.invalidateDrawable((Drawable)mDrawable);
                            ViewCompat.postOnAnimation((View)v, (Runnable)this);
                        }
                    }
                });
            }

            public void onViewDetachedFromWindow(@NonNull View v) {
                mIsAttached = false;
            }
        };

        private Runner() {
        }

        public void setFor(@NonNull View view, @NonNull IconicsAnimatedDrawable drawable) {
            this.unset();
            if (view == null || drawable == null) {
                return;
            }
            this.mView = view;
            this.mDrawable = drawable;
            if (ViewCompat.isAttachedToWindow((View)view)) {
                this.mListener.onViewAttachedToWindow(view);
            }
            view.addOnAttachStateChangeListener(this.mListener);
        }

        public void unset() {
            this.mDrawable = null;
            if (this.mView != null) {
                this.mView.removeOnAttachStateChangeListener(this.mListener);
                this.mView = null;
            }
            this.mIsAttached = false;
        }
    }
}

