/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.iconics.animation;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.TextPaint;
import androidx.annotation.NonNull;
import com.mikepenz.iconics.IconicsBrush;
import com.mikepenz.iconics.animation.IconicsAnimationProcessor;

public class SpinProcessor
extends IconicsAnimationProcessor {
    public static int defaultDuration = 2000;
    public static final int DIRECTION_CLOCKWISE = 1;
    public static final int DIRECTION_COUNTER_CLOCKWISE = -1;
    private int mDirection = 1;
    private boolean mIsDrawableShadowCleared = false;

    public SpinProcessor() {
        this.mDuration = defaultDuration;
    }

    @NonNull
    public SpinProcessor direction(int direction) {
        this.mDirection = direction;
        return this;
    }

    public int getDirection() {
        return (int)Math.signum(this.mDirection);
    }

    @Override
    @NonNull
    public String animationTag() {
        return "spin";
    }

    @Override
    protected void processPreDraw(@NonNull Canvas canvas, @NonNull IconicsBrush<TextPaint> iconBrush, @NonNull IconicsBrush<Paint> iconContourBrush, @NonNull IconicsBrush<Paint> backgroundBrush, @NonNull IconicsBrush<Paint> backgroundContourBrush) {
        if (!this.mIsDrawableShadowCleared) {
            iconBrush.getPaint().clearShadowLayer();
            this.mIsDrawableShadowCleared = true;
        }
        canvas.save();
        Rect bounds = this.getDrawableBounds();
        float degrees = this.getAnimatedPercent() * 3.6f * (float)this.getDirection();
        canvas.rotate(degrees, (float)(bounds.width() / 2), (float)(bounds.height() / 2));
    }

    @Override
    protected void processPostDraw(@NonNull Canvas canvas) {
        canvas.restore();
    }

    @Override
    protected void onDrawableDetached() {
        this.mIsDrawableShadowCleared = false;
    }
}

