/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.iconics.typeface;

import android.content.res.AssetManager;
import android.graphics.Typeface;
import androidx.annotation.FontRes;
import androidx.compose.runtime.internal.StabilityInferred;
import com.mikepenz.iconics.Iconics;
import com.mikepenz.iconics.typeface.IIcon;
import com.mikepenz.iconics.typeface.ITypeface;
import com.mikepenz.iconics.typeface.utils.IconicsPreconditions;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001:\u00017B\u0007\b\u0014\u00a2\u0006\u0002\u0010\u0002B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB'\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u0004\u0012\u0006\u0010\u000b\u001a\u00020\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\fB)\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u0004\u0012\u0006\u0010\u000b\u001a\u00020\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\rJ\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0004H\u0016J\u0016\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u00042\u0006\u00106\u001a\u00020\u0012R\u0014\u0010\u000b\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00120\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R*\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00120\u0016j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0012`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000fR\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000fR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001cR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u000fR\u0014\u0010%\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u000fR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u000fR\u0014\u0010(\u001a\u00020)8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0014\u0010,\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u000fR\u0014\u0010.\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u000f\u00a8\u00068"}, d2={"Lcom/mikepenz/iconics/typeface/GenericFont;", "Lcom/mikepenz/iconics/typeface/ITypeface;", "()V", "mappingPrefix", "", "fontFile", "(Ljava/lang/String;Ljava/lang/String;)V", "fontRes", "", "(Ljava/lang/String;I)V", "fontName", "author", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I)V", "getAuthor", "()Ljava/lang/String;", "characters", "", "", "getCharacters", "()Ljava/util/Map;", "chars", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "description", "getDescription", "getFontName", "getFontRes", "()I", "iconCount", "getIconCount", "icons", "", "getIcons", "()Ljava/util/List;", "license", "getLicense", "licenseUrl", "getLicenseUrl", "getMappingPrefix", "rawTypeface", "Landroid/graphics/Typeface;", "getRawTypeface", "()Landroid/graphics/Typeface;", "url", "getUrl", "version", "getVersion", "getIcon", "Lcom/mikepenz/iconics/typeface/IIcon;", "key", "registerIcon", "", "name", "char", "Icon", "iconics-core"})
@StabilityInferred(parameters=0)
public class GenericFont
implements ITypeface {
    @NotNull
    private final String fontName;
    @NotNull
    private final String author;
    @NotNull
    private final String mappingPrefix;
    private final int fontRes;
    @NotNull
    private final String fontFile;
    @NotNull
    private final HashMap<String, Character> chars;
    public static final int $stable = 8;

    @NotNull
    public String getFontName() {
        return this.fontName;
    }

    @NotNull
    public String getAuthor() {
        return this.author;
    }

    @NotNull
    public String getMappingPrefix() {
        return this.mappingPrefix;
    }

    public int getFontRes() {
        return this.fontRes;
    }

    @NotNull
    public Typeface getRawTypeface() {
        Typeface typeface;
        try {
            Typeface typeface2 = Typeface.createFromAsset((AssetManager)Iconics.getApplicationContext().getAssets(), (String)this.fontFile);
            Intrinsics.checkNotNullExpressionValue((Object)typeface2, (String)"{\n            Typeface.c\u2026sets, fontFile)\n        }");
            typeface = typeface2;
        }
        catch (Exception ignored) {
            typeface = ITypeface.DefaultImpls.getRawTypeface((ITypeface)this);
        }
        return typeface;
    }

    @NotNull
    public Map<String, Character> getCharacters() {
        return this.chars;
    }

    @NotNull
    public String getVersion() {
        return "1.0.0";
    }

    public int getIconCount() {
        return this.getCharacters().size();
    }

    @NotNull
    public List<String> getIcons() {
        return (List)CollectionsKt.toCollection((Iterable)this.getCharacters().keySet(), (Collection)new LinkedList());
    }

    @NotNull
    public String getUrl() {
        return "";
    }

    @NotNull
    public String getDescription() {
        return "";
    }

    @NotNull
    public String getLicense() {
        return "";
    }

    @NotNull
    public String getLicenseUrl() {
        return "";
    }

    protected GenericFont() {
        this("GenericFont", "GenericAuthor", "", "");
    }

    public GenericFont(@NotNull String mappingPrefix, @NotNull String fontFile) {
        Intrinsics.checkNotNullParameter((Object)mappingPrefix, (String)"mappingPrefix");
        Intrinsics.checkNotNullParameter((Object)fontFile, (String)"fontFile");
        this("GenericFont", "GenericAuthor", mappingPrefix, fontFile);
    }

    public GenericFont(@NotNull String mappingPrefix, @FontRes int fontRes) {
        Intrinsics.checkNotNullParameter((Object)mappingPrefix, (String)"mappingPrefix");
        this("GenericFont", "GenericAuthor", mappingPrefix, fontRes);
    }

    public GenericFont(@NotNull String fontName, @NotNull String author, @NotNull String mappingPrefix, @NotNull String fontFile) {
        Intrinsics.checkNotNullParameter((Object)fontName, (String)"fontName");
        Intrinsics.checkNotNullParameter((Object)author, (String)"author");
        Intrinsics.checkNotNullParameter((Object)mappingPrefix, (String)"mappingPrefix");
        Intrinsics.checkNotNullParameter((Object)fontFile, (String)"fontFile");
        this.chars = new HashMap();
        IconicsPreconditions.checkMappingPrefix((String)mappingPrefix);
        this.fontName = fontName;
        this.author = author;
        this.mappingPrefix = mappingPrefix;
        this.fontFile = fontFile;
        this.fontRes = -1;
    }

    public GenericFont(@NotNull String fontName, @NotNull String author, @NotNull String mappingPrefix, @FontRes int fontRes) {
        Intrinsics.checkNotNullParameter((Object)fontName, (String)"fontName");
        Intrinsics.checkNotNullParameter((Object)author, (String)"author");
        Intrinsics.checkNotNullParameter((Object)mappingPrefix, (String)"mappingPrefix");
        this.chars = new HashMap();
        IconicsPreconditions.checkMappingPrefix((String)mappingPrefix);
        this.fontName = fontName;
        this.author = author;
        this.mappingPrefix = mappingPrefix;
        this.fontFile = "";
        this.fontRes = fontRes;
    }

    public final void registerIcon(@NotNull String name, char c) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Character c2 = Character.valueOf(c);
        ((Map)this.chars).put(this.getMappingPrefix() + "_" + name, c2);
    }

    @NotNull
    public IIcon getIcon(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return new Icon(key, ((Character)MapsKt.getValue((Map)this.chars, (Object)key)).charValue()).withTypeface(this);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\u0013\u001a\u00060\u0000R\u00020\u00142\b\u0010\u0010\u001a\u0004\u0018\u00010\rR\u0014\u0010\b\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lcom/mikepenz/iconics/typeface/GenericFont$Icon;", "Lcom/mikepenz/iconics/typeface/IIcon;", "c", "", "(Lcom/mikepenz/iconics/typeface/GenericFont;C)V", "name", "", "(Lcom/mikepenz/iconics/typeface/GenericFont;Ljava/lang/String;C)V", "character", "getCharacter", "()C", "customName", "customTypeface", "Lcom/mikepenz/iconics/typeface/ITypeface;", "getName", "()Ljava/lang/String;", "typeface", "getTypeface", "()Lcom/mikepenz/iconics/typeface/ITypeface;", "withTypeface", "Lcom/mikepenz/iconics/typeface/GenericFont;", "iconics-core"})
    public final class Icon
    implements IIcon {
        @Nullable
        private final String customName;
        @Nullable
        private ITypeface customTypeface;
        private final char character;

        public Icon(char c) {
            this.customName = null;
            this.character = c;
        }

        public Icon(String name, char c) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.customName = name;
            this.character = c;
        }

        public char getCharacter() {
            return this.character;
        }

        @NotNull
        public String getName() {
            String string = this.customName;
            if (string == null) {
                string = String.valueOf(this.getCharacter());
            }
            return string;
        }

        @NotNull
        public ITypeface getTypeface() {
            ITypeface iTypeface = this.customTypeface;
            if (iTypeface == null) {
                iTypeface = GenericFont.this;
            }
            return iTypeface;
        }

        @NotNull
        public final Icon withTypeface(@Nullable ITypeface typeface) {
            this.customTypeface = typeface;
            return this;
        }

        @NotNull
        public String getFormattedName() {
            return IIcon.DefaultImpls.getFormattedName((IIcon)this);
        }
    }
}

