/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.iconics.utils;

import android.graphics.Paint;
import android.graphics.Typeface;
import android.text.TextPaint;
import android.text.style.TypefaceSpan;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/mikepenz/iconics/utils/IconicsTypefaceSpan;", "Landroid/text/style/TypefaceSpan;", "family", "", "newType", "Landroid/graphics/Typeface;", "(Ljava/lang/String;Landroid/graphics/Typeface;)V", "applyCustomTypeFace", "", "paint", "Landroid/graphics/Paint;", "tf", "updateDrawState", "ds", "Landroid/text/TextPaint;", "updateMeasureState", "iconics-core"})
@StabilityInferred(parameters=0)
public final class IconicsTypefaceSpan
extends TypefaceSpan {
    @NotNull
    private final Typeface newType;
    public static final int $stable = 8;

    public IconicsTypefaceSpan(@NotNull String family, @NotNull Typeface newType) {
        Intrinsics.checkNotNullParameter((Object)family, (String)"family");
        Intrinsics.checkNotNullParameter((Object)newType, (String)"newType");
        super(family);
        this.newType = newType;
    }

    public void updateDrawState(@NotNull TextPaint ds) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        this.applyCustomTypeFace((Paint)ds, this.newType);
    }

    public void updateMeasureState(@NotNull TextPaint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        this.applyCustomTypeFace((Paint)paint, this.newType);
    }

    private final void applyCustomTypeFace(Paint paint, Typeface tf) {
        Typeface old;
        int oldStyle = 0;
        Typeface typeface = old = paint.getTypeface();
        oldStyle = typeface != null ? typeface.getStyle() : 0;
        int fake = oldStyle & ~tf.getStyle();
        if ((fake & 1) != 0) {
            paint.setFakeBoldText(true);
        }
        if ((fake & 2) != 0) {
            paint.setTextSkewX(-0.25f);
        }
        paint.setTypeface(tf);
    }
}

