/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.iconics.utils;

import android.text.Editable;
import android.text.ParcelableSpan;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.style.CharacterStyle;
import com.mikepenz.iconics.Iconics;
import com.mikepenz.iconics.typeface.IIcon;
import com.mikepenz.iconics.typeface.ITypeface;
import com.mikepenz.iconics.utils.IconicsExtensionsKt;
import com.mikepenz.iconics.utils.IconicsLogger;
import com.mikepenz.iconics.utils.IconicsTypefaceSpan;
import com.mikepenz.iconics.utils.StyleContainer;
import com.mikepenz.iconics.utils.TextStyleContainer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JJ\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u000b2\u001a\u0010\u000f\u001a\u0016\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u0012\u0018\u00010\u0010H\u0007J$\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00180\u0010H\u0007J*\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00180\u0010H\u0007J6\u0010\u001d\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00180\u0010H\u0003J.\u0010\u001d\u001a\u0004\u0018\u00010\f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00180\u0010H\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/mikepenz/iconics/utils/InternalIconicsUtils;", "", "()V", "ICON_END", "", "ICON_START", "applyStyles", "", "text", "Landroid/text/Spannable;", "styleContainers", "", "Lcom/mikepenz/iconics/utils/StyleContainer;", "styles", "Landroid/text/style/CharacterStyle;", "stylesFor", "", "", "", "findIcons", "Lcom/mikepenz/iconics/utils/TextStyleContainer;", "spannable", "Landroid/text/Spanned;", "fonts", "Lcom/mikepenz/iconics/typeface/ITypeface;", "findIconsFromEditable", "Ljava/util/LinkedList;", "editable", "Landroid/text/Editable;", "placeFontIcon", "iconStart", "", "iconEnd", "spannedString", "Landroid/text/SpannableStringBuilder;", "tempIconString", "iconics-core"})
@SourceDebugExtension(value={"SMAP\nInternalIconicsUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InternalIconicsUtils.kt\ncom/mikepenz/iconics/utils/InternalIconicsUtils\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,332:1\n11670#2,3:333\n11670#2,3:336\n11670#2,3:342\n11670#2,3:345\n1#3:339\n1855#4,2:340\n1855#4,2:350\n1855#4:353\n1855#4,2:354\n1855#4,2:356\n1856#4:358\n1183#5,2:348\n1185#5:352\n*S KotlinDebug\n*F\n+ 1 InternalIconicsUtils.kt\ncom/mikepenz/iconics/utils/InternalIconicsUtils\n*L\n54#1:333,3\n64#1:336,3\n169#1:342,3\n179#1:345,3\n90#1:340,2\n208#1:350,2\n294#1:353\n311#1:354,2\n320#1:356,2\n294#1:358\n193#1:348,2\n193#1:352\n*E\n"})
public final class InternalIconicsUtils {
    @NotNull
    public static final InternalIconicsUtils INSTANCE = new InternalIconicsUtils();
    private static char ICON_START = (char)123;
    private static char ICON_END = (char)125;

    private InternalIconicsUtils() {
    }

    @JvmStatic
    @NotNull
    public static final LinkedList<StyleContainer> findIconsFromEditable(@NotNull Editable editable, @NotNull Map<String, ? extends ITypeface> fonts) {
        Object $this$findIconsFromEditable_u24lambda_u242;
        CharacterStyle it;
        boolean bl;
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)editable, (String)"editable");
        Intrinsics.checkNotNullParameter(fonts, (String)"fonts");
        LinkedList<StyleContainer> styleContainers = new LinkedList<StyleContainer>();
        LinkedList existingSpans = new LinkedList();
        Object[] objectArray = editable.getSpans(0, editable.length(), ParcelableSpan.class);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"editable.getSpans(0, edi\u2026rcelableSpan::class.java)");
        Object[] objectArray2 = objectArray;
        boolean $i$f$mapTo = false;
        for (Object item$iv : objectArray2) {
            ParcelableSpan parcelableSpan = (ParcelableSpan)item$iv;
            collection = existingSpans;
            bl = false;
            collection.add(new StyleContainer(editable.getSpanStart((Object)it), editable.getSpanEnd((Object)it), null, null, (ParcelableSpan)it, null, editable.getSpanFlags((Object)it), 44, null));
        }
        Object[] objectArray3 = editable.getSpans(0, editable.length(), CharacterStyle.class);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray3, (String)"editable.getSpans(0, edi\u2026aracterStyle::class.java)");
        Object[] objectArray4 = objectArray3;
        $i$f$mapTo = false;
        for (Object item$iv : objectArray4) {
            it = (CharacterStyle)item$iv;
            collection = existingSpans;
            bl = false;
            collection.add(new StyleContainer(editable.getSpanStart((Object)it), editable.getSpanEnd((Object)it), null, null, null, it, editable.getSpanFlags((Object)it), 28, null));
        }
        InternalIconicsUtils internalIconicsUtils = INSTANCE;
        try {
            $this$findIconsFromEditable_u24lambda_u242 = internalIconicsUtils;
            boolean bl2 = false;
            editable.clearSpans();
            $this$findIconsFromEditable_u24lambda_u242 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable bl2) {
            $this$findIconsFromEditable_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
        }
        boolean bl3 = false;
        int n = -1;
        int i = 0;
        while (i < editable.length()) {
            int n2;
            char c = editable.charAt(i);
            if (c == ICON_START) {
                n2 = i;
            } else if (c == ICON_END) {
                if (n2 > -1) {
                    if (InternalIconicsUtils.placeFontIcon(editable, n2, i, fonts) != null) {
                        StyleContainer styleContainer;
                        bl = false;
                        styleContainers.add(styleContainer);
                        Iterable $this$forEach$iv = existingSpans;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            StyleContainer it2 = (StyleContainer)element$iv;
                            boolean bl2 = false;
                            int newIconStart = i - n2;
                            if (it2.getStartIndex() > i) {
                                it2.setStartIndex(it2.getStartIndex() - newIconStart);
                                it2.setEndIndex(it2.getEndIndex() - newIconStart);
                                continue;
                            }
                            if (it2.getEndIndex() <= i) continue;
                            it2.setEndIndex(it2.getEndIndex() - newIconStart);
                        }
                        i = n2;
                    }
                }
                n2 = -1;
            }
            int n3 = i;
            i = n3 + 1;
        }
        styleContainers.addAll(existingSpans);
        return styleContainers;
    }

    @JvmStatic
    private static final StyleContainer placeFontIcon(Editable editable, int iconStart, int iconEnd, Map<String, ? extends ITypeface> fonts) {
        if (iconEnd - iconStart >= 6) {
            String iconString = IconicsExtensionsKt.getClearedIconName(((Object)((CharSequence)editable).subSequence(iconStart + 1, iconEnd)).toString());
            String fontKey = ((Object)((CharSequence)editable).subSequence(iconStart + 1, iconStart + 4)).toString();
            try {
                ITypeface iTypeface = fonts.get(fontKey);
                if (iTypeface != null) {
                    Object $this$placeFontIcon_u24lambda_u247_u24lambda_u245;
                    ITypeface iTypeface2;
                    ITypeface typeface = iTypeface2 = iTypeface;
                    boolean bl = false;
                    Object object = INSTANCE;
                    try {
                        $this$placeFontIcon_u24lambda_u247_u24lambda_u245 = object;
                        boolean bl2 = false;
                        $this$placeFontIcon_u24lambda_u247_u24lambda_u245 = Result.constructor-impl((Object)typeface.getIcon(iconString));
                    }
                    catch (Throwable bl2) {
                        $this$placeFontIcon_u24lambda_u247_u24lambda_u245 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
                    }
                    object = $this$placeFontIcon_u24lambda_u247_u24lambda_u245;
                    IIcon iIcon = (IIcon)(Result.isFailure-impl((Object)object) ? null : object);
                    if (iIcon != null) {
                        IIcon icon = iIcon;
                        boolean bl3 = false;
                        editable.replace(iconStart, iconEnd + 1, (CharSequence)String.valueOf(icon.getCharacter()));
                        return new StyleContainer(iconStart, iconStart + 1, iconString, typeface, null, null, 0, 112, null);
                    }
                    String string = Iconics.TAG;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                    IconicsLogger.DefaultImpls.log$default(Iconics.logger, 6, string, "Wrong icon name: " + iconString, null, 8, null);
                }
                String string = Iconics.TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                IconicsLogger.DefaultImpls.log$default(Iconics.logger, 6, string, "Wrong fontId: " + iconString, null, 8, null);
            }
            catch (IllegalArgumentException e) {
                String string = Iconics.TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                IconicsLogger.DefaultImpls.log$default(Iconics.logger, 6, string, "Wrong icon name: " + iconString, null, 8, null);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final TextStyleContainer findIcons(@NotNull Spanned spannable, @NotNull Map<String, ? extends ITypeface> fonts) {
        CharacterStyle it;
        Collection collection;
        Object[] $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)spannable, (String)"spannable");
        Intrinsics.checkNotNullParameter(fonts, (String)"fonts");
        LinkedList<StyleContainer> styleContainers = new LinkedList<StyleContainer>();
        LinkedList existingSpans = new LinkedList();
        Object[] objectArray = spannable.getSpans(0, spannable.length(), ParcelableSpan.class);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"spannable.getSpans(0, sp\u2026rcelableSpan::class.java)");
        Object[] objectArray2 = objectArray;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            ParcelableSpan parcelableSpan = (ParcelableSpan)item$iv;
            collection = existingSpans;
            boolean bl = false;
            collection.add(new StyleContainer(spannable.getSpanStart((Object)it), spannable.getSpanEnd((Object)it), null, null, (ParcelableSpan)it, null, spannable.getSpanFlags((Object)it), 44, null));
        }
        Object[] objectArray3 = spannable.getSpans(0, spannable.length(), CharacterStyle.class);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray3, (String)"spannable.getSpans(0, sp\u2026aracterStyle::class.java)");
        $this$mapTo$iv = objectArray3;
        $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            it = (CharacterStyle)item$iv;
            collection = existingSpans;
            boolean bl = false;
            collection.add(new StyleContainer(spannable.getSpanStart((Object)it), spannable.getSpanEnd((Object)it), null, null, null, it, spannable.getSpanFlags((Object)it), 28, null));
        }
        SpannableStringBuilder spannedString = new SpannableStringBuilder();
        SpannableStringBuilder tempIconString = null;
        tempIconString = new SpannableStringBuilder();
        int removedChars = 0;
        CharSequence $this$forEachIndexed$iv = (CharSequence)spannable;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (int i = 0; i < $this$forEachIndexed$iv.length(); ++i) {
            void c;
            char item$iv = $this$forEachIndexed$iv.charAt(i);
            int n = index$iv++;
            char c2 = item$iv;
            int i2 = n;
            boolean bl = false;
            if (c == ICON_START) {
                spannedString.append((CharSequence)tempIconString);
                tempIconString = new SpannableStringBuilder();
                tempIconString.append((char)c);
                continue;
            }
            if (c == ICON_END) {
                tempIconString.append((char)c);
                if (tempIconString.length() > 5) {
                    if (InternalIconicsUtils.placeFontIcon(spannedString, tempIconString, fonts) != null) {
                        StyleContainer styleContainer;
                        boolean bl2 = false;
                        styleContainers.add(styleContainer);
                        Iterable $this$forEach$iv = existingSpans;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            StyleContainer it2 = (StyleContainer)element$iv;
                            boolean bl3 = false;
                            if (it2.getStartIndex() > i2 - removedChars) {
                                it2.setStartIndex(it2.getStartIndex() - tempIconString.length() + 1);
                            }
                            if (it2.getEndIndex() <= i2 - removedChars) continue;
                            it2.setEndIndex(it2.getEndIndex() - tempIconString.length() + 1);
                        }
                        removedChars += tempIconString.length() - 1;
                    }
                } else {
                    spannedString.append((CharSequence)tempIconString);
                }
                tempIconString = new SpannableStringBuilder();
                continue;
            }
            if (((CharSequence)tempIconString).length() == 0) {
                spannedString.append((char)c);
                continue;
            }
            tempIconString.append((char)c);
        }
        spannedString.append((CharSequence)tempIconString);
        styleContainers.addAll(existingSpans);
        return new TextStyleContainer(spannedString, styleContainers);
    }

    @JvmStatic
    private static final StyleContainer placeFontIcon(SpannableStringBuilder spannedString, SpannableStringBuilder tempIconString, Map<String, ? extends ITypeface> fonts) {
        if (tempIconString.length() >= 6) {
            String iconString = IconicsExtensionsKt.getClearedIconName(((Object)((CharSequence)tempIconString).subSequence(1, tempIconString.length() - 1)).toString());
            String fontKey = ((Object)((CharSequence)tempIconString).subSequence(1, 4)).toString();
            ITypeface iTypeface = fonts.get(fontKey);
            if (iTypeface != null) {
                Object $this$placeFontIcon_u24lambda_u2415_u24lambda_u2413;
                ITypeface iTypeface2;
                ITypeface typeface = iTypeface2 = iTypeface;
                boolean bl = false;
                Object object = INSTANCE;
                try {
                    $this$placeFontIcon_u24lambda_u2415_u24lambda_u2413 = object;
                    boolean bl2 = false;
                    $this$placeFontIcon_u24lambda_u2415_u24lambda_u2413 = Result.constructor-impl((Object)typeface.getIcon(iconString));
                }
                catch (Throwable bl2) {
                    $this$placeFontIcon_u24lambda_u2415_u24lambda_u2413 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
                }
                object = $this$placeFontIcon_u24lambda_u2415_u24lambda_u2413;
                IIcon iIcon = (IIcon)(Result.isFailure-impl((Object)object) ? null : object);
                if (iIcon != null) {
                    IIcon icon = iIcon;
                    boolean bl3 = false;
                    spannedString.append(icon.getCharacter());
                    return new StyleContainer(spannedString.length() - 1, spannedString.length(), iconString, typeface, null, null, 0, 112, null);
                }
                String string = Iconics.TAG;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                IconicsLogger.DefaultImpls.log$default(Iconics.logger, 6, string, "Wrong icon name: " + iconString, null, 8, null);
            }
            String string = Iconics.TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            IconicsLogger.DefaultImpls.log$default(Iconics.logger, 6, string, "Wrong fontId: " + iconString, null, 8, null);
        }
        spannedString.append((CharSequence)tempIconString);
        return null;
    }

    @JvmStatic
    public static final void applyStyles(@NotNull Spannable text, @NotNull List<StyleContainer> styleContainers, @Nullable List<? extends CharacterStyle> styles, @Nullable Map<String, ? extends List<CharacterStyle>> stylesFor) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(styleContainers, (String)"styleContainers");
        Iterable $this$forEach$iv = styleContainers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CharacterStyle styleOrSpan;
            StyleContainer it = (StyleContainer)element$iv;
            boolean bl = false;
            CharacterStyle characterStyle = it.getStyle();
            if (characterStyle == null) {
                characterStyle = it.getSpan();
            }
            if ((styleOrSpan = characterStyle) != null) {
                text.setSpan((Object)styleOrSpan, it.getStartIndex(), it.getEndIndex(), it.getFlags());
            } else if (it.getFont() != null) {
                ITypeface font;
                boolean bl2 = false;
                text.setSpan((Object)new IconicsTypefaceSpan("sans-serif", font.getRawTypeface()), it.getStartIndex(), it.getEndIndex(), 33);
            }
            Map<String, ? extends List<CharacterStyle>> map = stylesFor;
            boolean bl3 = map != null ? map.containsKey(it.getIcon()) : false;
            if (bl3) {
                List<CharacterStyle> list = stylesFor.get(it.getIcon());
                if (list != null) {
                    Iterable $this$forEach$iv2 = list;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        CharacterStyle characterStyle2 = (CharacterStyle)element$iv2;
                        boolean bl4 = false;
                        text.setSpan((Object)CharacterStyle.wrap((CharacterStyle)characterStyle2), it.getStartIndex(), it.getEndIndex(), it.getFlags());
                    }
                }
                continue;
            }
            List<? extends CharacterStyle> list = styles;
            if (list == null) continue;
            Iterable $this$forEach$iv3 = list;
            boolean $i$f$forEach3 = false;
            for (Object element$iv3 : $this$forEach$iv3) {
                CharacterStyle characterStyle3 = (CharacterStyle)element$iv3;
                boolean bl5 = false;
                text.setSpan((Object)CharacterStyle.wrap((CharacterStyle)characterStyle3), it.getStartIndex(), it.getEndIndex(), it.getFlags());
            }
        }
    }
}

