/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.iconics.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.appcompat.widget.AppCompatButton;
import com.mikepenz.iconics.Iconics;
import com.mikepenz.iconics.IconicsDrawable;
import com.mikepenz.iconics.internal.CompoundIconicsDrawables;
import com.mikepenz.iconics.internal.CompoundIconsBundle;
import com.mikepenz.iconics.internal.IconicsView;
import com.mikepenz.iconics.internal.IconicsViewsAttrsApplier;
import com.mikepenz.iconics.internal.IconicsViewsUtils;
import com.mikepenz.iconics.view.R;

public class IconicsButton
extends AppCompatButton
implements IconicsView,
CompoundIconicsDrawables {
    private final CompoundIconsBundle mIconsBundle = new CompoundIconsBundle();

    public IconicsButton(Context context) {
        this(context, null);
    }

    public IconicsButton(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.buttonStyle);
    }

    public IconicsButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        if (!this.isInEditMode()) {
            this.initialize(context, attrs, defStyle);
        }
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void initialize(Context context, AttributeSet attrs, int defStyle) {
        this.applyAttr(context, attrs, defStyle);
        IconicsViewsUtils.checkAnimation(this.mIconsBundle.mBottomIcon, (View)this);
        IconicsViewsUtils.checkAnimation(this.mIconsBundle.mTopIcon, (View)this);
        IconicsViewsUtils.checkAnimation(this.mIconsBundle.mEndIcon, (View)this);
        IconicsViewsUtils.checkAnimation(this.mIconsBundle.mStartIcon, (View)this);
        this.setIcons();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void applyAttr(Context context, AttributeSet attrs, int defStyle) {
        IconicsViewsAttrsApplier.readIconicsTextView(context, attrs, this.mIconsBundle);
    }

    private void setIcons() {
        this.mIconsBundle.setIcons((TextView)this);
    }

    @Override
    @Nullable
    public IconicsDrawable getIconicsDrawableStart() {
        return this.mIconsBundle.mStartIcon;
    }

    @Override
    @Nullable
    public IconicsDrawable getIconicsDrawableTop() {
        return this.mIconsBundle.mTopIcon;
    }

    @Override
    @Nullable
    public IconicsDrawable getIconicsDrawableEnd() {
        return this.mIconsBundle.mEndIcon;
    }

    @Override
    @Nullable
    public IconicsDrawable getIconicsDrawableBottom() {
        return this.mIconsBundle.mBottomIcon;
    }

    @Override
    public void setDrawableStart(@Nullable IconicsDrawable drawable) {
        this.mIconsBundle.mStartIcon = IconicsViewsUtils.checkAnimation(drawable, (View)this);
        this.setIcons();
    }

    @Override
    public void setDrawableTop(@Nullable IconicsDrawable drawable) {
        this.mIconsBundle.mTopIcon = IconicsViewsUtils.checkAnimation(drawable, (View)this);
        this.setIcons();
    }

    @Override
    public void setDrawableEnd(@Nullable IconicsDrawable drawable) {
        this.mIconsBundle.mEndIcon = IconicsViewsUtils.checkAnimation(drawable, (View)this);
        this.setIcons();
    }

    @Override
    public void setDrawableBottom(@Nullable IconicsDrawable drawable) {
        this.mIconsBundle.mBottomIcon = IconicsViewsUtils.checkAnimation(drawable, (View)this);
        this.setIcons();
    }

    @Override
    public void setDrawableForAll(@Nullable IconicsDrawable drawable) {
        this.mIconsBundle.mStartIcon = IconicsViewsUtils.checkAnimation(drawable, (View)this);
        this.mIconsBundle.mTopIcon = IconicsViewsUtils.checkAnimation(drawable, (View)this);
        this.mIconsBundle.mEndIcon = IconicsViewsUtils.checkAnimation(drawable, (View)this);
        this.mIconsBundle.mBottomIcon = IconicsViewsUtils.checkAnimation(drawable, (View)this);
        this.setIcons();
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        this.setAllCaps(false);
        if (!this.isInEditMode()) {
            super.setText((CharSequence)new Iconics.IconicsBuilder().ctx(this.getContext()).on(text).build(), type);
        } else {
            super.setText(text, type);
        }
    }
}

