/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.iconics.view;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Checkable;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.widget.TextViewCompat;
import com.mikepenz.iconics.IconicsDrawable;
import com.mikepenz.iconics.internal.CheckedCompoundIconicsDrawables;
import com.mikepenz.iconics.internal.CompoundIconsBundle;
import com.mikepenz.iconics.internal.IconicsViewsAttrsApplier;
import com.mikepenz.iconics.internal.IconicsViewsUtils;
import com.mikepenz.iconics.utils.Utils;
import com.mikepenz.iconics.view.IconicsTextView;

public class IconicsCheckableTextView
extends IconicsTextView
implements Checkable,
CheckedCompoundIconicsDrawables {
    protected CompoundIconsBundle mCheckedIconsBundle;
    private boolean mAnimateChanges;
    private boolean mChecked;
    private boolean mBroadcasting;
    private OnCheckedChangeListener mOnCheckedChangeListener;
    private static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};

    public IconicsCheckableTextView(Context context) {
        this(context, null);
    }

    public IconicsCheckableTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 16842884);
    }

    public IconicsCheckableTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void initialize(Context context, AttributeSet attrs, int defStyle) {
        this.mCheckedIconsBundle = new CompoundIconsBundle();
        this.setFocusable(true);
        this.setClickable(true);
        super.applyAttr(context, attrs, defStyle);
        IconicsViewsUtils.checkAnimation(this.mIconsBundle.mBottomIcon, (View)this);
        IconicsViewsUtils.checkAnimation(this.mIconsBundle.mTopIcon, (View)this);
        IconicsViewsUtils.checkAnimation(this.mIconsBundle.mEndIcon, (View)this);
        IconicsViewsUtils.checkAnimation(this.mIconsBundle.mStartIcon, (View)this);
        this.applyAttr(context, attrs, defStyle);
        IconicsViewsUtils.checkAnimation(this.mCheckedIconsBundle.mBottomIcon, (View)this);
        IconicsViewsUtils.checkAnimation(this.mCheckedIconsBundle.mTopIcon, (View)this);
        IconicsViewsUtils.checkAnimation(this.mCheckedIconsBundle.mEndIcon, (View)this);
        IconicsViewsUtils.checkAnimation(this.mCheckedIconsBundle.mStartIcon, (View)this);
        this.setIcons();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void applyAttr(Context context, AttributeSet attrs, int defStyle) {
        IconicsViewsAttrsApplier.readIconicsCheckableTextView(context, attrs, this.mCheckedIconsBundle);
        this.mAnimateChanges = IconicsViewsAttrsApplier.isIconicsAnimateChanges(context, attrs);
    }

    private void setIcons() {
        TextViewCompat.setCompoundDrawablesRelativeWithIntrinsicBounds((TextView)this, (Drawable)this.createStatesStart(), (Drawable)this.createStatesTop(), (Drawable)this.createStatesEnd(), (Drawable)this.createStatesBottom());
    }

    private StateListDrawable createStatesStart() {
        return Utils.getCheckableIconStateList((Context)this.getContext(), (Drawable)this.mIconsBundle.mStartIcon, (Drawable)this.mCheckedIconsBundle.mStartIcon, (boolean)this.mAnimateChanges);
    }

    private StateListDrawable createStatesTop() {
        return Utils.getCheckableIconStateList((Context)this.getContext(), (Drawable)this.mIconsBundle.mTopIcon, (Drawable)this.mCheckedIconsBundle.mTopIcon, (boolean)this.mAnimateChanges);
    }

    private StateListDrawable createStatesEnd() {
        return Utils.getCheckableIconStateList((Context)this.getContext(), (Drawable)this.mIconsBundle.mEndIcon, (Drawable)this.mCheckedIconsBundle.mEndIcon, (boolean)this.mAnimateChanges);
    }

    private StateListDrawable createStatesBottom() {
        return Utils.getCheckableIconStateList((Context)this.getContext(), (Drawable)this.mIconsBundle.mBottomIcon, (Drawable)this.mCheckedIconsBundle.mBottomIcon, (boolean)this.mAnimateChanges);
    }

    public CharSequence getAccessibilityClassName() {
        return IconicsCheckableTextView.class.getName();
    }

    public void setChecked(boolean checked) {
        if (this.mChecked != checked) {
            this.mChecked = checked;
            this.refreshDrawableState();
            if (this.mBroadcasting) {
                return;
            }
            this.mBroadcasting = true;
            if (this.mOnCheckedChangeListener != null) {
                this.mOnCheckedChangeListener.onCheckedChanged(this, this.mChecked);
            }
            this.mBroadcasting = false;
        }
    }

    public void setOnCheckedChangeListener(OnCheckedChangeListener listener) {
        this.mOnCheckedChangeListener = listener;
    }

    protected int[] onCreateDrawableState(int extraSpace) {
        int[] drawableState = super.onCreateDrawableState(extraSpace + 1);
        if (this.isChecked()) {
            IconicsCheckableTextView.mergeDrawableStates((int[])drawableState, (int[])CHECKED_STATE_SET);
        }
        return drawableState;
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    public void toggle() {
        this.setChecked(!this.mChecked);
    }

    public boolean performClick() {
        this.toggle();
        boolean handled = super.performClick();
        if (!handled) {
            this.playSoundEffect(0);
        }
        return handled;
    }

    @Override
    @Nullable
    public IconicsDrawable getCheckedIconicsDrawableStart() {
        return this.mCheckedIconsBundle.mStartIcon;
    }

    @Override
    @Nullable
    public IconicsDrawable getCheckedIconicsDrawableTop() {
        return this.mCheckedIconsBundle.mTopIcon;
    }

    @Override
    @Nullable
    public IconicsDrawable getCheckedIconicsDrawableEnd() {
        return this.mCheckedIconsBundle.mEndIcon;
    }

    @Override
    @Nullable
    public IconicsDrawable getCheckedIconicsDrawableBottom() {
        return this.mCheckedIconsBundle.mBottomIcon;
    }

    @Override
    public void setCheckedDrawableStart(@Nullable IconicsDrawable drawable) {
        this.mCheckedIconsBundle.mStartIcon = IconicsViewsUtils.checkAnimation(drawable, (View)this);
        this.setIcons();
    }

    @Override
    public void setCheckedDrawableTop(@Nullable IconicsDrawable drawable) {
        this.mCheckedIconsBundle.mTopIcon = IconicsViewsUtils.checkAnimation(drawable, (View)this);
        this.setIcons();
    }

    @Override
    public void setCheckedDrawableEnd(@Nullable IconicsDrawable drawable) {
        this.mCheckedIconsBundle.mEndIcon = IconicsViewsUtils.checkAnimation(drawable, (View)this);
        this.setIcons();
    }

    @Override
    public void setCheckedDrawableBottom(@Nullable IconicsDrawable drawable) {
        this.mCheckedIconsBundle.mBottomIcon = IconicsViewsUtils.checkAnimation(drawable, (View)this);
        this.setIcons();
    }

    @Override
    public void setCheckedDrawableForAll(@Nullable IconicsDrawable drawable) {
        this.mCheckedIconsBundle.mStartIcon = IconicsViewsUtils.checkAnimation(drawable, (View)this);
        this.mCheckedIconsBundle.mTopIcon = IconicsViewsUtils.checkAnimation(drawable, (View)this);
        this.mCheckedIconsBundle.mEndIcon = IconicsViewsUtils.checkAnimation(drawable, (View)this);
        this.mCheckedIconsBundle.mBottomIcon = IconicsViewsUtils.checkAnimation(drawable, (View)this);
        this.setIcons();
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(IconicsCheckableTextView var1, boolean var2);
    }
}

