/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.iconics.view;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.CompoundButton;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.mikepenz.iconics.Iconics;
import com.mikepenz.iconics.IconicsDrawable;
import com.mikepenz.iconics.internal.CheckableIconBundle;
import com.mikepenz.iconics.internal.IconicsView;
import com.mikepenz.iconics.internal.IconicsViewsAttrsApplier;
import com.mikepenz.iconics.internal.IconicsViewsUtils;

public class IconicsCompoundButton
extends CompoundButton
implements IconicsView {
    private final CheckableIconBundle mIconsBundle = new CheckableIconBundle();

    public IconicsCompoundButton(Context context) {
        super(context);
    }

    public IconicsCompoundButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public IconicsCompoundButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        if (!this.isInEditMode()) {
            this.initialize(context, attrs, defStyle);
        }
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void initialize(Context context, AttributeSet attrs, int defStyle) {
        this.mIconsBundle.createIcons(context);
        this.applyAttr(context, attrs, defStyle);
        IconicsViewsUtils.checkAnimation(this.mIconsBundle.mCheckedIcon, (View)this);
        IconicsViewsUtils.checkAnimation(this.mIconsBundle.mUncheckedIcon, (View)this);
        this.setButtonDrawable((Drawable)this.mIconsBundle.createStates(context));
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void applyAttr(Context context, AttributeSet attrs, int defStyle) {
        IconicsViewsAttrsApplier.readIconicsCompoundButton(context, attrs, this.mIconsBundle);
        this.mIconsBundle.mAnimateChanges = IconicsViewsAttrsApplier.isIconicsAnimateChanges(context, attrs);
    }

    public void setCheckedIcon(@Nullable IconicsDrawable icon) {
        this.mIconsBundle.mCheckedIcon = IconicsViewsUtils.checkAnimation(icon, (View)this);
        this.setButtonDrawable((Drawable)this.mIconsBundle.createStates(this.getContext()));
    }

    public void setUncheckedIcon(@Nullable IconicsDrawable icon) {
        this.mIconsBundle.mUncheckedIcon = IconicsViewsUtils.checkAnimation(icon, (View)this);
        this.setButtonDrawable((Drawable)this.mIconsBundle.createStates(this.getContext()));
    }

    @Nullable
    public IconicsDrawable getCheckedIcon() {
        return this.mIconsBundle.mCheckedIcon;
    }

    @Nullable
    public IconicsDrawable getUncheckedIcon() {
        return this.mIconsBundle.mUncheckedIcon;
    }

    public void setText(@Nullable CharSequence text, @NonNull TextView.BufferType type) {
        if (!this.isInEditMode()) {
            super.setText((CharSequence)new Iconics.IconicsBuilder().ctx(this.getContext()).on(text == null ? "" : text).build(), type);
        } else {
            super.setText(text, type);
        }
    }

    public CharSequence getAccessibilityClassName() {
        return IconicsCompoundButton.class.getName();
    }
}

