/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer;

import android.app.Activity;
import android.content.Context;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.constraintlayout.widget.Guideline;
import androidx.core.view.ViewCompat;
import com.mikepenz.fastadapter.IIdentifyable;
import com.mikepenz.iconics.IconicsDrawable;
import com.mikepenz.iconics.typeface.IIcon;
import com.mikepenz.materialdrawer.AccountHeader;
import com.mikepenz.materialdrawer.Drawer;
import com.mikepenz.materialdrawer.R;
import com.mikepenz.materialdrawer.holder.ColorHolder;
import com.mikepenz.materialdrawer.holder.DimenHolder;
import com.mikepenz.materialdrawer.holder.ImageHolder;
import com.mikepenz.materialdrawer.holder.StringHolder;
import com.mikepenz.materialdrawer.icons.MaterialDrawerFont;
import com.mikepenz.materialdrawer.model.interfaces.IDrawerItem;
import com.mikepenz.materialdrawer.model.interfaces.IProfile;
import com.mikepenz.materialdrawer.util.DrawerImageLoader;
import com.mikepenz.materialdrawer.util.DrawerUIUtils;
import com.mikepenz.materialdrawer.view.BezelImageView;
import com.mikepenz.materialize.util.UIUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Stack;

public class AccountHeaderBuilder {
    protected Guideline mStatusBarGuideline;
    protected View mAccountHeader;
    protected ImageView mAccountHeaderBackground;
    protected BezelImageView mCurrentProfileView;
    protected ImageView mAccountSwitcherArrow;
    protected TextView mCurrentProfileName;
    protected TextView mCurrentProfileEmail;
    protected BezelImageView mProfileFirstView;
    protected BezelImageView mProfileSecondView;
    protected BezelImageView mProfileThirdView;
    protected IProfile mCurrentProfile;
    protected IProfile mProfileFirst;
    protected IProfile mProfileSecond;
    protected IProfile mProfileThird;
    protected boolean mSelectionListShown = false;
    protected int mAccountHeaderTextSectionBackgroundResource = -1;
    protected Activity mActivity;
    protected boolean mCompactStyle = false;
    protected Typeface mTypeface;
    protected Typeface mNameTypeface;
    protected Typeface mEmailTypeface;
    protected DimenHolder mHeight;
    protected ColorHolder mTextColor;
    protected boolean mCurrentHiddenInList = false;
    protected boolean mSelectionFirstLineShown = true;
    protected boolean mSelectionSecondLineShown = true;
    protected String mSelectionFirstLine;
    protected String mSelectionSecondLine;
    protected boolean mPaddingBelowHeader = true;
    protected boolean mDividerBelowHeader = true;
    protected boolean mTranslucentStatusBar = true;
    protected ImageHolder mHeaderBackground;
    protected ImageView.ScaleType mHeaderBackgroundScaleType = null;
    protected boolean mProfileImagesVisible = true;
    protected boolean mOnlyMainProfileImageVisible = false;
    protected boolean mOnlySmallProfileImagesVisible = false;
    protected Boolean mCloseDrawerOnProfileListClick = null;
    protected boolean mResetDrawerOnProfileListClick = true;
    protected boolean mProfileImagesClickable = true;
    protected boolean mAlternativeProfileHeaderSwitching = false;
    protected boolean mThreeSmallProfileImages = false;
    protected int mOnProfileClickDrawerCloseDelay = 100;
    protected AccountHeader.OnAccountHeaderProfileImageListener mOnAccountHeaderProfileImageListener;
    protected AccountHeader.OnAccountHeaderSelectionViewClickListener mOnAccountHeaderSelectionViewClickListener;
    protected boolean mSelectionListEnabledForSingleProfile = true;
    protected boolean mSelectionListEnabled = true;
    protected View mAccountHeaderContainer;
    protected List<IProfile> mProfiles;
    protected AccountHeader.OnAccountHeaderListener mOnAccountHeaderListener;
    protected AccountHeader.OnAccountHeaderItemLongClickListener mOnAccountHeaderItemLongClickListener;
    protected Drawer mDrawer;
    protected Bundle mSavedInstance;
    private View.OnClickListener onCurrentProfileClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            AccountHeaderBuilder.this.onProfileImageClick(v, true);
        }
    };
    private View.OnClickListener onProfileClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            AccountHeaderBuilder.this.onProfileImageClick(v, false);
        }
    };
    private View.OnLongClickListener onCurrentProfileLongClickListener = new View.OnLongClickListener(){

        public boolean onLongClick(View v) {
            if (AccountHeaderBuilder.this.mOnAccountHeaderProfileImageListener != null) {
                IProfile profile = (IProfile)v.getTag(R.id.material_drawer_profile_header);
                return AccountHeaderBuilder.this.mOnAccountHeaderProfileImageListener.onProfileImageLongClick(v, profile, true);
            }
            return false;
        }
    };
    private View.OnLongClickListener onProfileLongClickListener = new View.OnLongClickListener(){

        public boolean onLongClick(View v) {
            if (AccountHeaderBuilder.this.mOnAccountHeaderProfileImageListener != null) {
                IProfile profile = (IProfile)v.getTag(R.id.material_drawer_profile_header);
                return AccountHeaderBuilder.this.mOnAccountHeaderProfileImageListener.onProfileImageLongClick(v, profile, false);
            }
            return false;
        }
    };
    private View.OnClickListener onSelectionClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            boolean consumed = false;
            if (AccountHeaderBuilder.this.mOnAccountHeaderSelectionViewClickListener != null) {
                consumed = AccountHeaderBuilder.this.mOnAccountHeaderSelectionViewClickListener.onClick(v, (IProfile)v.getTag(R.id.material_drawer_profile_header));
            }
            if (AccountHeaderBuilder.this.mAccountSwitcherArrow.getVisibility() == 0 && !consumed) {
                AccountHeaderBuilder.this.toggleSelectionList(v.getContext());
            }
        }
    };
    private Drawer.OnDrawerItemClickListener onDrawerItemClickListener = new Drawer.OnDrawerItemClickListener(){

        @Override
        public boolean onItemClick(View view, int position, IDrawerItem drawerItem) {
            boolean isCurrentSelectedProfile = drawerItem != null && drawerItem instanceof IProfile && drawerItem.isSelectable() ? AccountHeaderBuilder.this.switchProfiles((IProfile)((Object)drawerItem)) : false;
            if (AccountHeaderBuilder.this.mResetDrawerOnProfileListClick) {
                AccountHeaderBuilder.this.mDrawer.setOnDrawerItemClickListener(null);
            }
            if (AccountHeaderBuilder.this.mResetDrawerOnProfileListClick && AccountHeaderBuilder.this.mDrawer != null && view != null && view.getContext() != null) {
                AccountHeaderBuilder.this.resetDrawerContent(view.getContext());
            }
            if (AccountHeaderBuilder.this.mDrawer != null && AccountHeaderBuilder.this.mDrawer.getDrawerBuilder() != null && AccountHeaderBuilder.this.mDrawer.getDrawerBuilder().mMiniDrawer != null) {
                AccountHeaderBuilder.this.mDrawer.getDrawerBuilder().mMiniDrawer.onProfileClick();
            }
            boolean consumed = false;
            if (drawerItem != null && drawerItem instanceof IProfile && AccountHeaderBuilder.this.mOnAccountHeaderListener != null) {
                consumed = AccountHeaderBuilder.this.mOnAccountHeaderListener.onProfileChanged(view, (IProfile)((Object)drawerItem), isCurrentSelectedProfile);
            }
            if (AccountHeaderBuilder.this.mCloseDrawerOnProfileListClick != null) {
                boolean bl = consumed = consumed && AccountHeaderBuilder.this.mCloseDrawerOnProfileListClick == false;
            }
            if (AccountHeaderBuilder.this.mDrawer != null && !consumed) {
                AccountHeaderBuilder.this.mDrawer.mDrawerBuilder.closeDrawerDelayed();
            }
            return true;
        }
    };
    private Drawer.OnDrawerItemLongClickListener onDrawerItemLongClickListener = new Drawer.OnDrawerItemLongClickListener(){

        @Override
        public boolean onItemLongClick(View view, int position, IDrawerItem drawerItem) {
            if (AccountHeaderBuilder.this.mOnAccountHeaderItemLongClickListener != null) {
                boolean isCurrentSelectedProfile;
                boolean bl = isCurrentSelectedProfile = drawerItem != null && drawerItem.isSelected();
                if (drawerItem != null && drawerItem instanceof IProfile) {
                    return AccountHeaderBuilder.this.mOnAccountHeaderItemLongClickListener.onProfileLongClick(view, (IProfile)((Object)drawerItem), isCurrentSelectedProfile);
                }
            }
            return false;
        }
    };

    public AccountHeaderBuilder withActivity(@NonNull Activity activity) {
        this.mActivity = activity;
        return this;
    }

    public AccountHeaderBuilder withCompactStyle(boolean compactStyle) {
        this.mCompactStyle = compactStyle;
        return this;
    }

    public AccountHeaderBuilder withTypeface(@NonNull Typeface typeface) {
        this.mTypeface = typeface;
        return this;
    }

    public AccountHeaderBuilder withNameTypeface(@NonNull Typeface typeface) {
        this.mNameTypeface = typeface;
        return this;
    }

    public AccountHeaderBuilder withEmailTypeface(@NonNull Typeface typeface) {
        this.mEmailTypeface = typeface;
        return this;
    }

    public AccountHeaderBuilder withHeightPx(int heightPx) {
        this.mHeight = DimenHolder.fromPixel(heightPx);
        return this;
    }

    public AccountHeaderBuilder withHeightDp(int heightDp) {
        this.mHeight = DimenHolder.fromDp(heightDp);
        return this;
    }

    public AccountHeaderBuilder withHeightRes(@DimenRes int heightRes) {
        this.mHeight = DimenHolder.fromResource(heightRes);
        return this;
    }

    public AccountHeaderBuilder withTextColor(@ColorInt int textColor) {
        this.mTextColor = ColorHolder.fromColor(textColor);
        return this;
    }

    public AccountHeaderBuilder withTextColorRes(@ColorRes int textColorRes) {
        this.mTextColor = ColorHolder.fromColorRes(textColorRes);
        return this;
    }

    public AccountHeaderBuilder withCurrentProfileHiddenInList(boolean currentProfileHiddenInList) {
        this.mCurrentHiddenInList = currentProfileHiddenInList;
        return this;
    }

    @Deprecated
    public AccountHeaderBuilder withSelectionFistLineShown(boolean selectionFirstLineShown) {
        this.mSelectionFirstLineShown = selectionFirstLineShown;
        return this;
    }

    public AccountHeaderBuilder withSelectionFirstLineShown(boolean selectionFirstLineShown) {
        this.mSelectionFirstLineShown = selectionFirstLineShown;
        return this;
    }

    public AccountHeaderBuilder withSelectionSecondLineShown(boolean selectionSecondLineShown) {
        this.mSelectionSecondLineShown = selectionSecondLineShown;
        return this;
    }

    public AccountHeaderBuilder withSelectionFirstLine(String selectionFirstLine) {
        this.mSelectionFirstLine = selectionFirstLine;
        return this;
    }

    public AccountHeaderBuilder withSelectionSecondLine(String selectionSecondLine) {
        this.mSelectionSecondLine = selectionSecondLine;
        return this;
    }

    public AccountHeaderBuilder withPaddingBelowHeader(boolean paddingBelowHeader) {
        this.mPaddingBelowHeader = paddingBelowHeader;
        return this;
    }

    public AccountHeaderBuilder withDividerBelowHeader(boolean dividerBelowHeader) {
        this.mDividerBelowHeader = dividerBelowHeader;
        return this;
    }

    public AccountHeaderBuilder withTranslucentStatusBar(boolean translucentStatusBar) {
        this.mTranslucentStatusBar = translucentStatusBar;
        return this;
    }

    public AccountHeaderBuilder withHeaderBackground(Drawable headerBackground) {
        this.mHeaderBackground = new ImageHolder(headerBackground);
        return this;
    }

    public AccountHeaderBuilder withHeaderBackground(@DrawableRes int headerBackgroundRes) {
        this.mHeaderBackground = new ImageHolder(headerBackgroundRes);
        return this;
    }

    public AccountHeaderBuilder withHeaderBackground(ImageHolder headerBackground) {
        this.mHeaderBackground = headerBackground;
        return this;
    }

    public AccountHeaderBuilder withHeaderBackgroundScaleType(ImageView.ScaleType headerBackgroundScaleType) {
        this.mHeaderBackgroundScaleType = headerBackgroundScaleType;
        return this;
    }

    public AccountHeaderBuilder withProfileImagesVisible(boolean profileImagesVisible) {
        this.mProfileImagesVisible = profileImagesVisible;
        return this;
    }

    public AccountHeaderBuilder withOnlyMainProfileImageVisible(boolean onlyMainProfileImageVisible) {
        this.mOnlyMainProfileImageVisible = onlyMainProfileImageVisible;
        return this;
    }

    public AccountHeaderBuilder withOnlySmallProfileImagesVisible(boolean onlySmallProfileImagesVisible) {
        this.mOnlySmallProfileImagesVisible = onlySmallProfileImagesVisible;
        return this;
    }

    public AccountHeaderBuilder withCloseDrawerOnProfileListClick(boolean closeDrawerOnProfileListClick) {
        this.mCloseDrawerOnProfileListClick = closeDrawerOnProfileListClick;
        return this;
    }

    public AccountHeaderBuilder withResetDrawerOnProfileListClick(boolean resetDrawerOnProfileListClick) {
        this.mResetDrawerOnProfileListClick = resetDrawerOnProfileListClick;
        return this;
    }

    public AccountHeaderBuilder withProfileImagesClickable(boolean profileImagesClickable) {
        this.mProfileImagesClickable = profileImagesClickable;
        return this;
    }

    public AccountHeaderBuilder withAlternativeProfileHeaderSwitching(boolean alternativeProfileHeaderSwitching) {
        this.mAlternativeProfileHeaderSwitching = alternativeProfileHeaderSwitching;
        return this;
    }

    public AccountHeaderBuilder withThreeSmallProfileImages(boolean threeSmallProfileImages) {
        this.mThreeSmallProfileImages = threeSmallProfileImages;
        return this;
    }

    public AccountHeaderBuilder withOnProfileClickDrawerCloseDelay(int onProfileClickDrawerCloseDelay) {
        this.mOnProfileClickDrawerCloseDelay = onProfileClickDrawerCloseDelay;
        return this;
    }

    public AccountHeaderBuilder withOnAccountHeaderProfileImageListener(AccountHeader.OnAccountHeaderProfileImageListener onAccountHeaderProfileImageListener) {
        this.mOnAccountHeaderProfileImageListener = onAccountHeaderProfileImageListener;
        return this;
    }

    public AccountHeaderBuilder withOnAccountHeaderSelectionViewClickListener(AccountHeader.OnAccountHeaderSelectionViewClickListener onAccountHeaderSelectionViewClickListener) {
        this.mOnAccountHeaderSelectionViewClickListener = onAccountHeaderSelectionViewClickListener;
        return this;
    }

    public AccountHeaderBuilder withSelectionListEnabledForSingleProfile(boolean selectionListEnabledForSingleProfile) {
        this.mSelectionListEnabledForSingleProfile = selectionListEnabledForSingleProfile;
        return this;
    }

    public AccountHeaderBuilder withSelectionListEnabled(boolean selectionListEnabled) {
        this.mSelectionListEnabled = selectionListEnabled;
        return this;
    }

    public AccountHeaderBuilder withAccountHeader(@NonNull View accountHeader) {
        this.mAccountHeaderContainer = accountHeader;
        return this;
    }

    public AccountHeaderBuilder withAccountHeader(@LayoutRes int resLayout) {
        if (this.mActivity == null) {
            throw new RuntimeException("please pass an activity first to use this call");
        }
        this.mAccountHeaderContainer = resLayout != -1 ? this.mActivity.getLayoutInflater().inflate(resLayout, null, false) : (this.mCompactStyle ? this.mActivity.getLayoutInflater().inflate(R.layout.material_drawer_compact_header, null, false) : this.mActivity.getLayoutInflater().inflate(R.layout.material_drawer_header, null, false));
        return this;
    }

    public AccountHeaderBuilder withProfiles(@NonNull List<IProfile> profiles) {
        if (this.mDrawer != null) {
            this.mDrawer.mDrawerBuilder.idDistributor.checkIds(profiles);
        }
        this.mProfiles = profiles;
        return this;
    }

    public AccountHeaderBuilder addProfiles(IProfile ... profiles) {
        if (this.mProfiles == null) {
            this.mProfiles = new ArrayList<IProfile>();
        }
        if (this.mDrawer != null) {
            this.mDrawer.mDrawerBuilder.idDistributor.checkIds((IIdentifyable[])profiles);
        }
        Collections.addAll(this.mProfiles, profiles);
        return this;
    }

    public AccountHeaderBuilder withOnAccountHeaderListener(AccountHeader.OnAccountHeaderListener onAccountHeaderListener) {
        this.mOnAccountHeaderListener = onAccountHeaderListener;
        return this;
    }

    public AccountHeaderBuilder withOnAccountHeaderItemLongClickListener(AccountHeader.OnAccountHeaderItemLongClickListener onAccountHeaderItemLongClickListener) {
        this.mOnAccountHeaderItemLongClickListener = onAccountHeaderItemLongClickListener;
        return this;
    }

    public AccountHeaderBuilder withDrawer(@NonNull Drawer drawer) {
        this.mDrawer = drawer;
        drawer.getRecyclerView().setPadding(drawer.getRecyclerView().getPaddingLeft(), 0, drawer.getRecyclerView().getPaddingRight(), drawer.getRecyclerView().getPaddingBottom());
        return this;
    }

    public AccountHeaderBuilder withSavedInstance(Bundle savedInstance) {
        this.mSavedInstance = savedInstance;
        return this;
    }

    private void setHeaderHeight(int height) {
        if (this.mAccountHeaderContainer != null) {
            View accountHeaderBackground;
            View accountHeader;
            ViewGroup.LayoutParams params = this.mAccountHeaderContainer.getLayoutParams();
            if (params != null) {
                params.height = height;
                this.mAccountHeaderContainer.setLayoutParams(params);
            }
            if ((accountHeader = this.mAccountHeaderContainer.findViewById(R.id.material_drawer_account_header)) != null && (params = accountHeader.getLayoutParams()) != null) {
                params.height = height;
                accountHeader.setLayoutParams(params);
            }
            if ((accountHeaderBackground = this.mAccountHeaderContainer.findViewById(R.id.material_drawer_account_header_background)) != null) {
                params = accountHeaderBackground.getLayoutParams();
                params.height = height;
                accountHeaderBackground.setLayoutParams(params);
            }
        }
    }

    private void handleSelectionView(IProfile profile, boolean on) {
        if (on) {
            if (Build.VERSION.SDK_INT >= 23) {
                this.mAccountHeaderContainer.setForeground(AppCompatResources.getDrawable((Context)this.mAccountHeaderContainer.getContext(), (int)this.mAccountHeaderTextSectionBackgroundResource));
            }
            this.mAccountHeaderContainer.setOnClickListener(this.onSelectionClickListener);
            this.mAccountHeaderContainer.setTag(R.id.material_drawer_profile_header, (Object)profile);
        } else {
            if (Build.VERSION.SDK_INT >= 23) {
                this.mAccountHeaderContainer.setForeground(null);
            }
            this.mAccountHeaderContainer.setOnClickListener(null);
        }
    }

    public AccountHeader build() {
        int selection;
        int height;
        if (this.mAccountHeaderContainer == null) {
            this.withAccountHeader(-1);
        }
        this.mAccountHeader = this.mAccountHeaderContainer.findViewById(R.id.material_drawer_account_header);
        this.mStatusBarGuideline = (Guideline)this.mAccountHeaderContainer.findViewById(R.id.material_drawer_statusbar_guideline);
        int defaultHeaderMinHeight = this.mActivity.getResources().getDimensionPixelSize(R.dimen.material_drawer_account_header_height);
        int statusBarHeight = UIUtils.getStatusBarHeight((Context)this.mActivity, (boolean)true);
        if (this.mHeight != null) {
            height = this.mHeight.asPixel((Context)this.mActivity);
        } else if (this.mCompactStyle) {
            height = this.mActivity.getResources().getDimensionPixelSize(R.dimen.material_drawer_account_header_height_compact);
        } else {
            int tempHeight;
            height = (int)((double)DrawerUIUtils.getOptimalDrawerWidth((Context)this.mActivity) * 0.5625);
            if (Build.VERSION.SDK_INT < 19 && (float)(tempHeight = height - statusBarHeight) > (float)defaultHeaderMinHeight - UIUtils.convertDpToPixel((float)8.0f, (Context)this.mActivity)) {
                height = tempHeight;
            }
        }
        if (this.mTranslucentStatusBar && Build.VERSION.SDK_INT >= 21) {
            this.mStatusBarGuideline.setGuidelineBegin(statusBarHeight);
            if (this.mCompactStyle) {
                height += statusBarHeight;
            } else if (height - statusBarHeight <= defaultHeaderMinHeight) {
                height = defaultHeaderMinHeight + statusBarHeight;
            }
        }
        this.setHeaderHeight(height);
        this.mAccountHeaderBackground = (ImageView)this.mAccountHeaderContainer.findViewById(R.id.material_drawer_account_header_background);
        ImageHolder.applyTo((com.mikepenz.materialize.holder.ImageHolder)this.mHeaderBackground, (ImageView)this.mAccountHeaderBackground, (String)DrawerImageLoader.Tags.ACCOUNT_HEADER.name());
        if (this.mHeaderBackgroundScaleType != null) {
            this.mAccountHeaderBackground.setScaleType(this.mHeaderBackgroundScaleType);
        }
        int textColor = ColorHolder.color((com.mikepenz.materialize.holder.ColorHolder)this.mTextColor, (Context)this.mActivity, (int)R.attr.material_drawer_header_selection_text, (int)R.color.material_drawer_header_selection_text);
        int subTextColor = ColorHolder.color((com.mikepenz.materialize.holder.ColorHolder)this.mTextColor, (Context)this.mActivity, (int)R.attr.material_drawer_header_selection_subtext, (int)R.color.material_drawer_header_selection_subtext);
        this.mAccountHeaderTextSectionBackgroundResource = UIUtils.getSelectableBackgroundRes((Context)this.mActivity);
        this.handleSelectionView(this.mCurrentProfile, true);
        this.mAccountSwitcherArrow = (ImageView)this.mAccountHeaderContainer.findViewById(R.id.material_drawer_account_header_text_switcher);
        this.mAccountSwitcherArrow.setImageDrawable((Drawable)new IconicsDrawable((Context)this.mActivity, (IIcon)MaterialDrawerFont.Icon.mdf_arrow_drop_down).sizeRes(R.dimen.material_drawer_account_header_dropdown).paddingRes(R.dimen.material_drawer_account_header_dropdown_padding).color(subTextColor));
        this.mCurrentProfileView = (BezelImageView)this.mAccountHeader.findViewById(R.id.material_drawer_account_header_current);
        this.mCurrentProfileName = (TextView)this.mAccountHeader.findViewById(R.id.material_drawer_account_header_name);
        this.mCurrentProfileEmail = (TextView)this.mAccountHeader.findViewById(R.id.material_drawer_account_header_email);
        if (this.mNameTypeface != null) {
            this.mCurrentProfileName.setTypeface(this.mNameTypeface);
        } else if (this.mTypeface != null) {
            this.mCurrentProfileName.setTypeface(this.mTypeface);
        }
        if (this.mEmailTypeface != null) {
            this.mCurrentProfileEmail.setTypeface(this.mEmailTypeface);
        } else if (this.mTypeface != null) {
            this.mCurrentProfileEmail.setTypeface(this.mTypeface);
        }
        this.mCurrentProfileName.setTextColor(textColor);
        this.mCurrentProfileEmail.setTextColor(subTextColor);
        this.mProfileFirstView = (BezelImageView)this.mAccountHeader.findViewById(R.id.material_drawer_account_header_small_first);
        this.mProfileSecondView = (BezelImageView)this.mAccountHeader.findViewById(R.id.material_drawer_account_header_small_second);
        this.mProfileThirdView = (BezelImageView)this.mAccountHeader.findViewById(R.id.material_drawer_account_header_small_third);
        this.calculateProfiles();
        this.buildProfiles();
        if (this.mSavedInstance != null && (selection = this.mSavedInstance.getInt("bundle_selection_header", -1)) != -1 && this.mProfiles != null && selection > -1 && selection < this.mProfiles.size()) {
            this.switchProfiles(this.mProfiles.get(selection));
        }
        if (this.mDrawer != null) {
            this.mDrawer.setHeader(this.mAccountHeaderContainer, this.mPaddingBelowHeader, this.mDividerBelowHeader);
        }
        this.mActivity = null;
        return new AccountHeader(this);
    }

    protected void calculateProfiles() {
        if (this.mProfiles == null) {
            this.mProfiles = new ArrayList<IProfile>();
        }
        if (this.mCurrentProfile == null) {
            int setCount = 0;
            int size = this.mProfiles.size();
            for (int i = 0; i < size; ++i) {
                if (this.mProfiles.size() <= i || !this.mProfiles.get(i).isSelectable()) continue;
                if (setCount == 0 && this.mCurrentProfile == null) {
                    this.mCurrentProfile = this.mProfiles.get(i);
                } else if (setCount == 1 && this.mProfileFirst == null) {
                    this.mProfileFirst = this.mProfiles.get(i);
                } else if (setCount == 2 && this.mProfileSecond == null) {
                    this.mProfileSecond = this.mProfiles.get(i);
                } else if (setCount == 3 && this.mProfileThird == null) {
                    this.mProfileThird = this.mProfiles.get(i);
                }
                ++setCount;
            }
            return;
        }
        IProfile[] previousActiveProfiles = new IProfile[]{this.mCurrentProfile, this.mProfileFirst, this.mProfileSecond, this.mProfileThird};
        IProfile[] newActiveProfiles = new IProfile[4];
        Stack<IProfile> unusedProfiles = new Stack<IProfile>();
        for (int i = 0; i < this.mProfiles.size(); ++i) {
            IProfile p = this.mProfiles.get(i);
            if (!p.isSelectable()) continue;
            boolean used = false;
            for (int j = 0; j < 4; ++j) {
                if (previousActiveProfiles[j] != p) continue;
                newActiveProfiles[j] = p;
                used = true;
                break;
            }
            if (used) continue;
            unusedProfiles.push(p);
        }
        Stack<IProfile<Object>> activeProfiles = new Stack<IProfile<Object>>();
        for (int i = 0; i < 4; ++i) {
            if (newActiveProfiles[i] != null) {
                activeProfiles.push(newActiveProfiles[i]);
                continue;
            }
            if (unusedProfiles.isEmpty()) continue;
            activeProfiles.push((IProfile<Object>)unusedProfiles.pop());
        }
        Stack reversedActiveProfiles = new Stack();
        while (!activeProfiles.empty()) {
            reversedActiveProfiles.push(activeProfiles.pop());
        }
        this.mCurrentProfile = reversedActiveProfiles.isEmpty() ? null : (IProfile)reversedActiveProfiles.pop();
        this.mProfileFirst = reversedActiveProfiles.isEmpty() ? null : (IProfile)reversedActiveProfiles.pop();
        this.mProfileSecond = reversedActiveProfiles.isEmpty() ? null : (IProfile)reversedActiveProfiles.pop();
        this.mProfileThird = reversedActiveProfiles.isEmpty() ? null : (IProfile)reversedActiveProfiles.pop();
    }

    protected boolean switchProfiles(IProfile newSelection) {
        if (newSelection == null) {
            return false;
        }
        if (this.mCurrentProfile == newSelection) {
            return true;
        }
        if (this.mAlternativeProfileHeaderSwitching) {
            int prevSelection = -1;
            if (this.mProfileFirst == newSelection) {
                prevSelection = 1;
            } else if (this.mProfileSecond == newSelection) {
                prevSelection = 2;
            } else if (this.mProfileThird == newSelection) {
                prevSelection = 3;
            }
            IProfile tmp = this.mCurrentProfile;
            this.mCurrentProfile = newSelection;
            if (prevSelection == 1) {
                this.mProfileFirst = tmp;
            } else if (prevSelection == 2) {
                this.mProfileSecond = tmp;
            } else if (prevSelection == 3) {
                this.mProfileThird = tmp;
            }
        } else if (this.mProfiles != null) {
            ArrayList<IProfile> previousActiveProfiles = new ArrayList<IProfile>(Arrays.asList(this.mCurrentProfile, this.mProfileFirst, this.mProfileSecond, this.mProfileThird));
            if (previousActiveProfiles.contains(newSelection)) {
                int position = -1;
                for (int i = 0; i < 4; ++i) {
                    if (previousActiveProfiles.get(i) != newSelection) continue;
                    position = i;
                    break;
                }
                if (position != -1) {
                    previousActiveProfiles.remove(position);
                    previousActiveProfiles.add(0, newSelection);
                    this.mCurrentProfile = previousActiveProfiles.get(0);
                    this.mProfileFirst = previousActiveProfiles.get(1);
                    this.mProfileSecond = previousActiveProfiles.get(2);
                    this.mProfileThird = previousActiveProfiles.get(3);
                }
            } else {
                this.mProfileThird = this.mProfileSecond;
                this.mProfileSecond = this.mProfileFirst;
                this.mProfileFirst = this.mCurrentProfile;
                this.mCurrentProfile = newSelection;
            }
        }
        if (this.mOnlySmallProfileImagesVisible) {
            this.mProfileThird = this.mProfileSecond;
            this.mProfileSecond = this.mProfileFirst;
            this.mProfileFirst = this.mCurrentProfile;
        }
        this.buildProfiles();
        return false;
    }

    protected void buildProfiles() {
        this.mCurrentProfileView.setVisibility(8);
        this.mAccountSwitcherArrow.setVisibility(8);
        this.mProfileFirstView.setVisibility(8);
        this.mProfileFirstView.setOnClickListener(null);
        this.mProfileSecondView.setVisibility(8);
        this.mProfileSecondView.setOnClickListener(null);
        this.mProfileThirdView.setVisibility(8);
        this.mProfileThirdView.setOnClickListener(null);
        this.mCurrentProfileName.setText((CharSequence)"");
        this.mCurrentProfileEmail.setText((CharSequence)"");
        this.handleSelectionView(this.mCurrentProfile, true);
        if (this.mCurrentProfile != null) {
            if ((this.mProfileImagesVisible || this.mOnlyMainProfileImageVisible) && !this.mOnlySmallProfileImagesVisible) {
                this.setImageOrPlaceholder((ImageView)this.mCurrentProfileView, this.mCurrentProfile.getIcon());
                if (this.mProfileImagesClickable) {
                    this.mCurrentProfileView.setOnClickListener(this.onCurrentProfileClickListener);
                    this.mCurrentProfileView.setOnLongClickListener(this.onCurrentProfileLongClickListener);
                    this.mCurrentProfileView.disableTouchFeedback(false);
                } else {
                    this.mCurrentProfileView.disableTouchFeedback(true);
                }
                this.mCurrentProfileView.setVisibility(0);
                this.mCurrentProfileView.invalidate();
            } else if (this.mCompactStyle) {
                this.mCurrentProfileView.setVisibility(8);
            }
            this.handleSelectionView(this.mCurrentProfile, true);
            this.mAccountSwitcherArrow.setVisibility(0);
            this.mCurrentProfileView.setTag(R.id.material_drawer_profile_header, this.mCurrentProfile);
            StringHolder.applyTo((com.mikepenz.materialize.holder.StringHolder)this.mCurrentProfile.getName(), (TextView)this.mCurrentProfileName);
            StringHolder.applyTo((com.mikepenz.materialize.holder.StringHolder)this.mCurrentProfile.getEmail(), (TextView)this.mCurrentProfileEmail);
            if (this.mProfileFirst != null && this.mProfileImagesVisible && !this.mOnlyMainProfileImageVisible) {
                this.setImageOrPlaceholder((ImageView)this.mProfileFirstView, this.mProfileFirst.getIcon());
                this.mProfileFirstView.setTag(R.id.material_drawer_profile_header, this.mProfileFirst);
                if (this.mProfileImagesClickable) {
                    this.mProfileFirstView.setOnClickListener(this.onProfileClickListener);
                    this.mProfileFirstView.setOnLongClickListener(this.onProfileLongClickListener);
                    this.mProfileFirstView.disableTouchFeedback(false);
                } else {
                    this.mProfileFirstView.disableTouchFeedback(true);
                }
                this.mProfileFirstView.setVisibility(0);
                this.mProfileFirstView.invalidate();
            }
            if (this.mProfileSecond != null && this.mProfileImagesVisible && !this.mOnlyMainProfileImageVisible) {
                this.setImageOrPlaceholder((ImageView)this.mProfileSecondView, this.mProfileSecond.getIcon());
                this.mProfileSecondView.setTag(R.id.material_drawer_profile_header, this.mProfileSecond);
                if (this.mProfileImagesClickable) {
                    this.mProfileSecondView.setOnClickListener(this.onProfileClickListener);
                    this.mProfileSecondView.setOnLongClickListener(this.onProfileLongClickListener);
                    this.mProfileSecondView.disableTouchFeedback(false);
                } else {
                    this.mProfileSecondView.disableTouchFeedback(true);
                }
                this.mProfileSecondView.setVisibility(0);
                this.mProfileSecondView.invalidate();
            }
            if (this.mProfileThird != null && this.mThreeSmallProfileImages && this.mProfileImagesVisible && !this.mOnlyMainProfileImageVisible) {
                this.setImageOrPlaceholder((ImageView)this.mProfileThirdView, this.mProfileThird.getIcon());
                this.mProfileThirdView.setTag(R.id.material_drawer_profile_header, this.mProfileThird);
                if (this.mProfileImagesClickable) {
                    this.mProfileThirdView.setOnClickListener(this.onProfileClickListener);
                    this.mProfileThirdView.setOnLongClickListener(this.onProfileLongClickListener);
                    this.mProfileThirdView.disableTouchFeedback(false);
                } else {
                    this.mProfileThirdView.disableTouchFeedback(true);
                }
                this.mProfileThirdView.setVisibility(0);
                this.mProfileThirdView.invalidate();
            }
        } else if (this.mProfiles != null && this.mProfiles.size() > 0) {
            IProfile profile = this.mProfiles.get(0);
            this.mAccountHeader.setTag(R.id.material_drawer_profile_header, (Object)profile);
            this.handleSelectionView(this.mCurrentProfile, true);
            this.mAccountSwitcherArrow.setVisibility(0);
            if (this.mCurrentProfile != null) {
                StringHolder.applyTo((com.mikepenz.materialize.holder.StringHolder)this.mCurrentProfile.getName(), (TextView)this.mCurrentProfileName);
                StringHolder.applyTo((com.mikepenz.materialize.holder.StringHolder)this.mCurrentProfile.getEmail(), (TextView)this.mCurrentProfileEmail);
            }
        }
        if (!this.mSelectionFirstLineShown) {
            this.mCurrentProfileName.setVisibility(8);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mSelectionFirstLine)) {
            this.mCurrentProfileName.setText((CharSequence)this.mSelectionFirstLine);
        }
        if (!this.mSelectionSecondLineShown) {
            this.mCurrentProfileEmail.setVisibility(8);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mSelectionSecondLine)) {
            this.mCurrentProfileEmail.setText((CharSequence)this.mSelectionSecondLine);
        }
        if (!this.mSelectionListEnabled || !this.mSelectionListEnabledForSingleProfile && this.mProfileFirst == null && (this.mProfiles == null || this.mProfiles.size() == 1)) {
            this.mAccountSwitcherArrow.setVisibility(8);
            this.handleSelectionView(null, false);
        }
        if (this.mOnAccountHeaderSelectionViewClickListener != null) {
            this.handleSelectionView(this.mCurrentProfile, true);
        }
    }

    private void setImageOrPlaceholder(ImageView iv, ImageHolder imageHolder) {
        DrawerImageLoader.getInstance().cancelImage(iv);
        iv.setImageDrawable(DrawerImageLoader.getInstance().getImageLoader().placeholder(iv.getContext(), DrawerImageLoader.Tags.PROFILE.name()));
        ImageHolder.applyTo((com.mikepenz.materialize.holder.ImageHolder)imageHolder, (ImageView)iv, (String)DrawerImageLoader.Tags.PROFILE.name());
    }

    private void onProfileImageClick(View v, boolean current) {
        IProfile profile = (IProfile)v.getTag(R.id.material_drawer_profile_header);
        boolean consumed = false;
        if (this.mOnAccountHeaderProfileImageListener != null) {
            consumed = this.mOnAccountHeaderProfileImageListener.onProfileImageClick(v, profile, current);
        }
        if (!consumed) {
            this.onProfileClick(v, current);
        }
    }

    protected void onProfileClick(View v, boolean current) {
        IProfile profile = (IProfile)v.getTag(R.id.material_drawer_profile_header);
        this.switchProfiles(profile);
        this.resetDrawerContent(v.getContext());
        if (this.mDrawer != null && this.mDrawer.getDrawerBuilder() != null && this.mDrawer.getDrawerBuilder().mMiniDrawer != null) {
            this.mDrawer.getDrawerBuilder().mMiniDrawer.onProfileClick();
        }
        boolean consumed = false;
        if (this.mOnAccountHeaderListener != null) {
            consumed = this.mOnAccountHeaderListener.onProfileChanged(v, profile, current);
        }
        if (!consumed) {
            if (this.mOnProfileClickDrawerCloseDelay > 0) {
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (AccountHeaderBuilder.this.mDrawer != null) {
                            AccountHeaderBuilder.this.mDrawer.closeDrawer();
                        }
                    }
                }, (long)this.mOnProfileClickDrawerCloseDelay);
            } else if (this.mDrawer != null) {
                this.mDrawer.closeDrawer();
            }
        }
    }

    protected int getCurrentSelection() {
        if (this.mCurrentProfile != null && this.mProfiles != null) {
            int i = 0;
            for (IProfile profile : this.mProfiles) {
                if (profile == this.mCurrentProfile) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    protected void toggleSelectionList(Context ctx) {
        if (this.mDrawer != null) {
            if (this.mDrawer.switchedDrawerContent()) {
                this.resetDrawerContent(ctx);
                this.mSelectionListShown = false;
            } else {
                this.buildDrawerSelectionList();
                this.mAccountSwitcherArrow.clearAnimation();
                ViewCompat.animate((View)this.mAccountSwitcherArrow).rotation(180.0f).start();
                this.mSelectionListShown = true;
            }
        }
    }

    protected void buildDrawerSelectionList() {
        int selectedPosition = -1;
        int position = 0;
        ArrayList<IDrawerItem> profileDrawerItems = new ArrayList<IDrawerItem>();
        if (this.mProfiles != null) {
            for (IProfile profile : this.mProfiles) {
                if (profile == this.mCurrentProfile) {
                    if (this.mCurrentHiddenInList) continue;
                    selectedPosition = this.mDrawer.mDrawerBuilder.getItemAdapter().getGlobalPosition(position);
                }
                if (profile instanceof IDrawerItem) {
                    ((IDrawerItem)((Object)profile)).withSetSelected(false);
                    profileDrawerItems.add((IDrawerItem)((Object)profile));
                }
                ++position;
            }
        }
        this.mDrawer.switchDrawerContent(this.onDrawerItemClickListener, this.onDrawerItemLongClickListener, profileDrawerItems, selectedPosition);
    }

    private void resetDrawerContent(Context ctx) {
        if (this.mDrawer != null) {
            this.mDrawer.resetDrawerContent();
        }
        this.mAccountSwitcherArrow.clearAnimation();
        ViewCompat.animate((View)this.mAccountSwitcherArrow).rotation(0.0f).start();
    }

    protected void updateHeaderAndList() {
        this.calculateProfiles();
        this.buildProfiles();
        if (this.mSelectionListShown) {
            this.buildDrawerSelectionList();
        }
    }
}

