/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.appcompat.app.ActionBarDrawerToggle;
import androidx.appcompat.widget.Toolbar;
import androidx.core.util.Pair;
import androidx.drawerlayout.widget.DrawerLayout;
import androidx.recyclerview.widget.RecyclerView;
import com.mikepenz.fastadapter.FastAdapter;
import com.mikepenz.fastadapter.adapters.ModelAdapter;
import com.mikepenz.fastadapter.expandable.ExpandableExtension;
import com.mikepenz.fastadapter.select.SelectExtension;
import com.mikepenz.materialdrawer.DrawerBuilder;
import com.mikepenz.materialdrawer.DrawerUtils;
import com.mikepenz.materialdrawer.MiniDrawer;
import com.mikepenz.materialdrawer.R;
import com.mikepenz.materialdrawer.holder.DimenHolder;
import com.mikepenz.materialdrawer.holder.ImageHolder;
import com.mikepenz.materialdrawer.holder.StringHolder;
import com.mikepenz.materialdrawer.model.AbstractDrawerItem;
import com.mikepenz.materialdrawer.model.ContainerDrawerItem;
import com.mikepenz.materialdrawer.model.interfaces.Badgeable;
import com.mikepenz.materialdrawer.model.interfaces.IDrawerItem;
import com.mikepenz.materialdrawer.model.interfaces.Iconable;
import com.mikepenz.materialdrawer.model.interfaces.Nameable;
import com.mikepenz.materialize.Materialize;
import com.mikepenz.materialize.view.ScrimInsetsRelativeLayout;
import java.util.ArrayList;
import java.util.List;

public class Drawer {
    protected static final String BUNDLE_SELECTION = "_selection";
    protected static final String BUNDLE_SELECTION_APPENDED = "_selection_appended";
    protected static final String BUNDLE_STICKY_FOOTER_SELECTION = "bundle_sticky_footer_selection";
    protected static final String BUNDLE_STICKY_FOOTER_SELECTION_APPENDED = "bundle_sticky_footer_selection_appended";
    protected static final String BUNDLE_DRAWER_CONTENT_SWITCHED = "bundle_drawer_content_switched";
    protected static final String BUNDLE_DRAWER_CONTENT_SWITCHED_APPENDED = "bundle_drawer_content_switched_appended";
    protected static final String PREF_USER_LEARNED_DRAWER = "navigation_drawer_learned";
    protected static final String PREF_USER_OPENED_DRAWER_BY_DRAGGING = "navigation_drawer_dragged_open";
    protected final DrawerBuilder mDrawerBuilder;
    private FrameLayout mContentView;
    private OnDrawerItemClickListener originalOnDrawerItemClickListener;
    private OnDrawerItemLongClickListener originalOnDrawerItemLongClickListener;
    private List<IDrawerItem> originalDrawerItems;
    private Bundle originalDrawerState;

    protected Drawer(DrawerBuilder drawerBuilder) {
        this.mDrawerBuilder = drawerBuilder;
    }

    protected DrawerBuilder getDrawerBuilder() {
        return this.mDrawerBuilder;
    }

    public DrawerLayout getDrawerLayout() {
        return this.mDrawerBuilder.mDrawerLayout;
    }

    public void setToolbar(@NonNull Activity activity, @NonNull Toolbar toolbar) {
        this.setToolbar(activity, toolbar, false);
    }

    public void setToolbar(@NonNull Activity activity, @NonNull Toolbar toolbar, boolean recreateActionBarDrawerToggle) {
        this.mDrawerBuilder.mToolbar = toolbar;
        this.mDrawerBuilder.handleDrawerNavigation(activity, recreateActionBarDrawerToggle);
    }

    public void setActionBarDrawerToggle(@NonNull ActionBarDrawerToggle actionBarDrawerToggle) {
        this.mDrawerBuilder.mActionBarDrawerToggleEnabled = true;
        this.mDrawerBuilder.mActionBarDrawerToggle = actionBarDrawerToggle;
        this.mDrawerBuilder.handleDrawerNavigation(null, false);
    }

    public void openDrawer() {
        if (this.mDrawerBuilder.mDrawerLayout != null && this.mDrawerBuilder.mSliderLayout != null) {
            this.mDrawerBuilder.mDrawerLayout.openDrawer(this.mDrawerBuilder.mDrawerGravity.intValue());
        }
    }

    public void closeDrawer() {
        if (this.mDrawerBuilder.mDrawerLayout != null) {
            this.mDrawerBuilder.mDrawerLayout.closeDrawer(this.mDrawerBuilder.mDrawerGravity.intValue());
        }
    }

    public boolean isDrawerOpen() {
        if (this.mDrawerBuilder.mDrawerLayout != null && this.mDrawerBuilder.mSliderLayout != null) {
            return this.mDrawerBuilder.mDrawerLayout.isDrawerOpen(this.mDrawerBuilder.mDrawerGravity.intValue());
        }
        return false;
    }

    public void setFullscreen(boolean fullscreen) {
        if (this.mDrawerBuilder.mMaterialize != null) {
            this.mDrawerBuilder.mMaterialize.setFullscreen(fullscreen);
        }
    }

    public Materialize getMaterialize() {
        return this.mDrawerBuilder.mMaterialize;
    }

    public MiniDrawer getMiniDrawer() {
        if (this.mDrawerBuilder.mMiniDrawer == null) {
            this.mDrawerBuilder.mMiniDrawer = new MiniDrawer().withDrawer(this).withAccountHeader(this.mDrawerBuilder.mAccountHeader);
        }
        return this.mDrawerBuilder.mMiniDrawer;
    }

    public ScrimInsetsRelativeLayout getSlider() {
        return this.mDrawerBuilder.mSliderLayout;
    }

    public FrameLayout getContent() {
        if (this.mContentView == null && this.mDrawerBuilder.mDrawerLayout != null) {
            this.mContentView = (FrameLayout)this.mDrawerBuilder.mDrawerLayout.findViewById(R.id.content_layout);
        }
        return this.mContentView;
    }

    public RecyclerView getRecyclerView() {
        return this.mDrawerBuilder.mRecyclerView;
    }

    public FastAdapter<IDrawerItem> getAdapter() {
        return this.mDrawerBuilder.mAdapter;
    }

    public ModelAdapter<IDrawerItem, IDrawerItem> getHeaderAdapter() {
        return this.mDrawerBuilder.mHeaderAdapter;
    }

    public ModelAdapter<IDrawerItem, IDrawerItem> getItemAdapter() {
        return this.mDrawerBuilder.mItemAdapter;
    }

    public ModelAdapter<IDrawerItem, IDrawerItem> getFooterAdapter() {
        return this.mDrawerBuilder.mFooterAdapter;
    }

    public ExpandableExtension<IDrawerItem> getExpandableExtension() {
        return this.mDrawerBuilder.mExpandableExtension;
    }

    public List<IDrawerItem> getDrawerItems() {
        return this.mDrawerBuilder.getItemAdapter().getAdapterItems();
    }

    public View getHeader() {
        return this.mDrawerBuilder.mHeaderView;
    }

    public View getStickyHeader() {
        return this.mDrawerBuilder.mStickyHeaderView;
    }

    public void setHeader(@NonNull View view) {
        this.setHeader(view, true, true);
    }

    public void setHeader(@NonNull View view, boolean divider) {
        this.setHeader(view, true, divider);
    }

    public void setHeader(@NonNull View view, boolean padding, boolean divider) {
        this.setHeader(view, padding, divider, null);
    }

    public void setHeader(@NonNull View view, boolean padding, boolean divider, DimenHolder height) {
        this.mDrawerBuilder.getHeaderAdapter().clear();
        if (padding) {
            this.mDrawerBuilder.getHeaderAdapter().add((Object[])new IDrawerItem[]{new ContainerDrawerItem().withView(view).withDivider(divider).withHeight(height).withViewPosition(ContainerDrawerItem.Position.TOP)});
        } else {
            this.mDrawerBuilder.getHeaderAdapter().add((Object[])new IDrawerItem[]{new ContainerDrawerItem().withView(view).withDivider(divider).withHeight(height).withViewPosition(ContainerDrawerItem.Position.NONE)});
        }
        this.mDrawerBuilder.mRecyclerView.setPadding(this.mDrawerBuilder.mRecyclerView.getPaddingLeft(), 0, this.mDrawerBuilder.mRecyclerView.getPaddingRight(), this.mDrawerBuilder.mRecyclerView.getPaddingBottom());
    }

    public void removeHeader() {
        this.mDrawerBuilder.getHeaderAdapter().clear();
    }

    public View getFooter() {
        return this.mDrawerBuilder.mFooterView;
    }

    public View getStickyFooter() {
        return this.mDrawerBuilder.mStickyFooterView;
    }

    private View getStickyFooterShadow() {
        return this.mDrawerBuilder.mStickyFooterShadowView;
    }

    public ActionBarDrawerToggle getActionBarDrawerToggle() {
        return this.mDrawerBuilder.mActionBarDrawerToggle;
    }

    public void setGravity(int gravity) {
        DrawerLayout.LayoutParams params = (DrawerLayout.LayoutParams)this.getSlider().getLayoutParams();
        params.gravity = gravity;
        this.getSlider().setLayoutParams((ViewGroup.LayoutParams)params);
        this.mDrawerBuilder.mDrawerGravity = gravity;
    }

    public int getPosition(@NonNull IDrawerItem drawerItem) {
        return this.getPosition(drawerItem.getIdentifier());
    }

    public int getPosition(long identifier) {
        return DrawerUtils.getPositionByIdentifier(this.mDrawerBuilder, identifier);
    }

    public IDrawerItem getDrawerItem(long identifier) {
        Pair res = this.getAdapter().getItemById(identifier);
        if (res != null) {
            return (IDrawerItem)res.first;
        }
        return null;
    }

    public IDrawerItem getDrawerItem(Object tag) {
        return DrawerUtils.getDrawerItem(this.getDrawerItems(), tag);
    }

    public int getStickyFooterPosition(@NonNull IDrawerItem drawerItem) {
        return this.getStickyFooterPosition(drawerItem.getIdentifier());
    }

    public int getStickyFooterPosition(long identifier) {
        return DrawerUtils.getStickyFooterPositionByIdentifier(this.mDrawerBuilder, identifier);
    }

    public int getCurrentSelectedPosition() {
        return this.mDrawerBuilder.mAdapter.getSelections().size() == 0 ? -1 : (Integer)this.mDrawerBuilder.mAdapter.getSelections().iterator().next();
    }

    public long getCurrentSelection() {
        IDrawerItem drawerItem = this.mDrawerBuilder.getDrawerItem(this.getCurrentSelectedPosition());
        if (drawerItem != null) {
            return drawerItem.getIdentifier();
        }
        return -1L;
    }

    public int getCurrentStickyFooterSelectedPosition() {
        return this.mDrawerBuilder.mCurrentStickyFooterSelection;
    }

    public void deselect() {
        this.getAdapter().deselect();
    }

    public void deselect(long identifier) {
        this.getAdapter().deselect(this.getPosition(identifier));
    }

    public void setSelection(long identifier) {
        this.setSelection(identifier, true);
    }

    public void setSelection(long identifier, boolean fireOnClick) {
        SelectExtension select = (SelectExtension)this.getAdapter().getExtension(SelectExtension.class);
        if (select != null) {
            select.deselect();
            select.selectByIdentifier(identifier, false, true);
            Pair res = this.getAdapter().getItemById(identifier);
            if (res != null) {
                Integer position = (Integer)res.second;
                this.notifySelect(position != null ? position : -1, fireOnClick);
            }
        }
    }

    public void setStickyFooterSelection(long identifier, boolean fireOnClick) {
        this.setStickyFooterSelectionAtPosition(this.getStickyFooterPosition(identifier), fireOnClick);
    }

    public void setSelection(@NonNull IDrawerItem drawerItem) {
        this.setSelection(drawerItem.getIdentifier(), true);
    }

    public void setSelection(@NonNull IDrawerItem drawerItem, boolean fireOnClick) {
        this.setSelection(drawerItem.getIdentifier(), fireOnClick);
    }

    public boolean setSelectionAtPosition(int position) {
        return this.setSelectionAtPosition(position, true);
    }

    public boolean setSelectionAtPosition(int position, boolean fireOnClick) {
        SelectExtension select;
        if (this.mDrawerBuilder.mRecyclerView != null && (select = (SelectExtension)this.getAdapter().getExtension(SelectExtension.class)) != null) {
            select.deselect();
            select.select(position, false);
            this.notifySelect(position, fireOnClick);
        }
        return false;
    }

    private void notifySelect(int position, boolean fireOnClick) {
        if (fireOnClick && position >= 0) {
            IDrawerItem item = (IDrawerItem)this.mDrawerBuilder.mAdapter.getItem(position);
            if (item instanceof AbstractDrawerItem && ((AbstractDrawerItem)item).getOnDrawerItemClickListener() != null) {
                ((AbstractDrawerItem)item).getOnDrawerItemClickListener().onItemClick(null, position, item);
            }
            if (this.mDrawerBuilder.mOnDrawerItemClickListener != null) {
                this.mDrawerBuilder.mOnDrawerItemClickListener.onItemClick(null, position, item);
            }
        }
        this.mDrawerBuilder.resetStickyFooterSelection();
    }

    public void setStickyFooterSelectionAtPosition(int position) {
        this.setStickyFooterSelectionAtPosition(position, true);
    }

    public void setStickyFooterSelectionAtPosition(int position, boolean fireOnClick) {
        DrawerUtils.setStickyFooterSelection(this.mDrawerBuilder, position, fireOnClick);
    }

    public void updateItem(@NonNull IDrawerItem drawerItem) {
        this.updateItemAtPosition(drawerItem, this.getPosition(drawerItem));
    }

    public void updateBadge(long identifier, StringHolder badge) {
        IDrawerItem drawerItem = this.getDrawerItem(identifier);
        if (drawerItem instanceof Badgeable) {
            Badgeable badgeable = (Badgeable)((Object)drawerItem);
            badgeable.withBadge(badge);
            this.updateItem((IDrawerItem)((Object)badgeable));
        }
    }

    public void updateName(long identifier, StringHolder name) {
        IDrawerItem drawerItem = this.getDrawerItem(identifier);
        if (drawerItem instanceof Nameable) {
            Nameable pdi = (Nameable)((Object)drawerItem);
            pdi.withName(name);
            this.updateItem((IDrawerItem)((Object)pdi));
        }
    }

    public void updateIcon(long identifier, ImageHolder image) {
        IDrawerItem drawerItem = this.getDrawerItem(identifier);
        if (drawerItem instanceof Iconable) {
            Iconable pdi = (Iconable)((Object)drawerItem);
            pdi.withIcon(image);
            this.updateItem((IDrawerItem)((Object)pdi));
        }
    }

    public void updateItemAtPosition(@NonNull IDrawerItem drawerItem, int position) {
        if (this.mDrawerBuilder.checkDrawerItem(position, false)) {
            this.mDrawerBuilder.getItemAdapter().set(position, (Object)drawerItem);
        }
    }

    public void addItem(@NonNull IDrawerItem drawerItem) {
        this.mDrawerBuilder.getItemAdapter().add((Object[])new IDrawerItem[]{drawerItem});
    }

    public void addItemAtPosition(@NonNull IDrawerItem drawerItem, int position) {
        this.mDrawerBuilder.getItemAdapter().add(position, (Object[])new IDrawerItem[]{drawerItem});
    }

    public void setItemAtPosition(@NonNull IDrawerItem drawerItem, int position) {
        this.mDrawerBuilder.getItemAdapter().add(position, (Object[])new IDrawerItem[]{drawerItem});
    }

    public void removeItemByPosition(int position) {
        if (this.mDrawerBuilder.checkDrawerItem(position, false)) {
            this.mDrawerBuilder.getItemAdapter().remove(position);
        }
    }

    public void removeItem(long identifier) {
        this.getItemAdapter().removeByIdentifier(identifier);
    }

    public void removeItems(long ... identifiers) {
        if (identifiers != null) {
            for (long identifier : identifiers) {
                this.removeItem(identifier);
            }
        }
    }

    public void removeAllItems() {
        this.mDrawerBuilder.getItemAdapter().clear();
    }

    public void addItems(IDrawerItem ... drawerItems) {
        this.mDrawerBuilder.getItemAdapter().add((Object[])drawerItems);
    }

    public void addItemsAtPosition(int position, IDrawerItem ... drawerItems) {
        this.mDrawerBuilder.getItemAdapter().add(position, (Object[])drawerItems);
    }

    public void setItems(@NonNull List<IDrawerItem> drawerItems) {
        this.setItems(drawerItems, false);
    }

    private void setItems(@NonNull List<IDrawerItem> drawerItems, boolean switchedItems) {
        if (this.originalDrawerItems != null && !switchedItems) {
            this.originalDrawerItems = drawerItems;
        }
        this.mDrawerBuilder.getItemAdapter().setNewList(drawerItems);
    }

    public void updateStickyFooterItem(@NonNull IDrawerItem drawerItem) {
        this.updateStickyFooterItemAtPosition(drawerItem, this.getStickyFooterPosition(drawerItem));
    }

    public void updateStickyFooterItemAtPosition(@NonNull IDrawerItem drawerItem, int position) {
        if (this.mDrawerBuilder.mStickyDrawerItems != null && this.mDrawerBuilder.mStickyDrawerItems.size() > position) {
            this.mDrawerBuilder.mStickyDrawerItems.set(position, drawerItem);
        }
        DrawerUtils.rebuildStickyFooterView(this.mDrawerBuilder);
    }

    public void addStickyFooterItem(@NonNull IDrawerItem drawerItem) {
        if (this.mDrawerBuilder.mStickyDrawerItems == null) {
            this.mDrawerBuilder.mStickyDrawerItems = new ArrayList<IDrawerItem>();
        }
        this.mDrawerBuilder.mStickyDrawerItems.add(drawerItem);
        DrawerUtils.rebuildStickyFooterView(this.mDrawerBuilder);
    }

    public void addStickyFooterItemAtPosition(@NonNull IDrawerItem drawerItem, int position) {
        if (this.mDrawerBuilder.mStickyDrawerItems == null) {
            this.mDrawerBuilder.mStickyDrawerItems = new ArrayList<IDrawerItem>();
        }
        this.mDrawerBuilder.mStickyDrawerItems.add(position, drawerItem);
        DrawerUtils.rebuildStickyFooterView(this.mDrawerBuilder);
    }

    public void setStickyFooterItemAtPosition(@NonNull IDrawerItem drawerItem, int position) {
        if (this.mDrawerBuilder.mStickyDrawerItems != null && this.mDrawerBuilder.mStickyDrawerItems.size() > position) {
            this.mDrawerBuilder.mStickyDrawerItems.set(position, drawerItem);
        }
        DrawerUtils.rebuildStickyFooterView(this.mDrawerBuilder);
    }

    public void removeStickyFooterItemAtPosition(int position) {
        if (this.mDrawerBuilder.mStickyDrawerItems != null && this.mDrawerBuilder.mStickyDrawerItems.size() > position) {
            this.mDrawerBuilder.mStickyDrawerItems.remove(position);
        }
        DrawerUtils.rebuildStickyFooterView(this.mDrawerBuilder);
    }

    public void removeAllStickyFooterItems() {
        if (this.mDrawerBuilder.mStickyDrawerItems != null) {
            this.mDrawerBuilder.mStickyDrawerItems.clear();
        }
        if (this.mDrawerBuilder.mStickyFooterView != null) {
            this.mDrawerBuilder.mStickyFooterView.setVisibility(8);
        }
    }

    public void setOnDrawerItemClickListener(OnDrawerItemClickListener onDrawerItemClickListener) {
        this.mDrawerBuilder.mOnDrawerItemClickListener = onDrawerItemClickListener;
    }

    public void setOnDrawerNavigationListener(OnDrawerNavigationListener onDrawerNavigationListener) {
        this.mDrawerBuilder.mOnDrawerNavigationListener = onDrawerNavigationListener;
    }

    public OnDrawerItemClickListener getOnDrawerItemClickListener() {
        return this.mDrawerBuilder.mOnDrawerItemClickListener;
    }

    public OnDrawerNavigationListener getOnDrawerNavigationListener() {
        return this.mDrawerBuilder.mOnDrawerNavigationListener;
    }

    public void setOnDrawerItemLongClickListener(OnDrawerItemLongClickListener onDrawerItemLongClickListener) {
        this.mDrawerBuilder.mOnDrawerItemLongClickListener = onDrawerItemLongClickListener;
    }

    public OnDrawerItemLongClickListener getOnDrawerItemLongClickListener() {
        return this.mDrawerBuilder.mOnDrawerItemLongClickListener;
    }

    public boolean switchedDrawerContent() {
        return this.originalOnDrawerItemClickListener != null || this.originalDrawerItems != null || this.originalDrawerState != null;
    }

    public List<IDrawerItem> getOriginalDrawerItems() {
        return this.originalDrawerItems;
    }

    public void switchDrawerContent(@NonNull OnDrawerItemClickListener onDrawerItemClickListener, OnDrawerItemLongClickListener onDrawerItemLongClickListener, @NonNull List<IDrawerItem> drawerItems, int drawerSelection) {
        if (!this.switchedDrawerContent()) {
            this.originalOnDrawerItemClickListener = this.getOnDrawerItemClickListener();
            this.originalOnDrawerItemLongClickListener = this.getOnDrawerItemLongClickListener();
            this.originalDrawerState = this.getAdapter().saveInstanceState(new Bundle());
            this.mDrawerBuilder.mExpandableExtension.collapse(false);
            this.originalDrawerItems = this.getDrawerItems();
        }
        this.setOnDrawerItemClickListener(onDrawerItemClickListener);
        this.setOnDrawerItemLongClickListener(onDrawerItemLongClickListener);
        this.setItems(drawerItems, true);
        this.setSelectionAtPosition(drawerSelection, false);
        if (!this.mDrawerBuilder.mKeepStickyItemsVisible) {
            if (this.getStickyFooter() != null) {
                this.getStickyFooter().setVisibility(8);
            }
            if (this.getStickyFooterShadow() != null) {
                this.getStickyFooterShadow().setVisibility(8);
            }
        }
    }

    public void resetDrawerContent() {
        if (this.switchedDrawerContent()) {
            this.setOnDrawerItemClickListener(this.originalOnDrawerItemClickListener);
            this.setOnDrawerItemLongClickListener(this.originalOnDrawerItemLongClickListener);
            this.setItems(this.originalDrawerItems, true);
            this.getAdapter().withSavedInstanceState(this.originalDrawerState);
            this.originalOnDrawerItemClickListener = null;
            this.originalOnDrawerItemLongClickListener = null;
            this.originalDrawerItems = null;
            this.originalDrawerState = null;
            this.mDrawerBuilder.mRecyclerView.smoothScrollToPosition(0);
            if (this.getStickyFooter() != null) {
                this.getStickyFooter().setVisibility(0);
            }
            if (this.getStickyFooterShadow() != null) {
                this.getStickyFooterShadow().setVisibility(0);
            }
            if (this.mDrawerBuilder.mAccountHeader != null && this.mDrawerBuilder.mAccountHeader.mAccountHeaderBuilder != null) {
                this.mDrawerBuilder.mAccountHeader.mAccountHeaderBuilder.mSelectionListShown = false;
            }
        }
    }

    public Bundle saveInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            if (!this.mDrawerBuilder.mAppended) {
                savedInstanceState = this.mDrawerBuilder.mAdapter.saveInstanceState(savedInstanceState, BUNDLE_SELECTION);
                savedInstanceState.putInt(BUNDLE_STICKY_FOOTER_SELECTION, this.mDrawerBuilder.mCurrentStickyFooterSelection);
                savedInstanceState.putBoolean(BUNDLE_DRAWER_CONTENT_SWITCHED, this.switchedDrawerContent());
            } else {
                savedInstanceState = this.mDrawerBuilder.mAdapter.saveInstanceState(savedInstanceState, BUNDLE_SELECTION_APPENDED);
                savedInstanceState.putInt(BUNDLE_STICKY_FOOTER_SELECTION_APPENDED, this.mDrawerBuilder.mCurrentStickyFooterSelection);
                savedInstanceState.putBoolean(BUNDLE_DRAWER_CONTENT_SWITCHED_APPENDED, this.switchedDrawerContent());
            }
        }
        return savedInstanceState;
    }

    public static interface OnDrawerItemSelectedListener {
        public void onItemSelected(AdapterView<?> var1, View var2, int var3, long var4, IDrawerItem var6);

        public void onNothingSelected(AdapterView<?> var1);
    }

    public static interface OnDrawerListener {
        public void onDrawerOpened(View var1);

        public void onDrawerClosed(View var1);

        public void onDrawerSlide(View var1, float var2);
    }

    public static interface OnDrawerItemLongClickListener {
        public boolean onItemLongClick(View var1, int var2, IDrawerItem var3);
    }

    public static interface OnDrawerItemClickListener {
        public boolean onItemClick(View var1, int var2, IDrawerItem var3);
    }

    public static interface OnDrawerNavigationListener {
        public boolean onNavigationClickListener(View var1);
    }
}

