/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer;

import android.content.Context;
import android.view.View;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.mikepenz.fastadapter.FastAdapter;
import com.mikepenz.fastadapter.IAdapter;
import com.mikepenz.fastadapter.adapters.ItemAdapter;
import com.mikepenz.fastadapter.listeners.OnClickListener;
import com.mikepenz.fastadapter.listeners.OnLongClickListener;
import com.mikepenz.materialdrawer.AccountHeader;
import com.mikepenz.materialdrawer.Drawer;
import com.mikepenz.materialdrawer.DrawerUtils;
import com.mikepenz.materialdrawer.R;
import com.mikepenz.materialdrawer.interfaces.ICrossfader;
import com.mikepenz.materialdrawer.model.MiniDrawerItem;
import com.mikepenz.materialdrawer.model.MiniProfileDrawerItem;
import com.mikepenz.materialdrawer.model.PrimaryDrawerItem;
import com.mikepenz.materialdrawer.model.ProfileDrawerItem;
import com.mikepenz.materialdrawer.model.SecondaryDrawerItem;
import com.mikepenz.materialdrawer.model.interfaces.IDrawerItem;
import com.mikepenz.materialdrawer.model.interfaces.IProfile;
import com.mikepenz.materialize.util.UIUtils;
import java.util.List;

public class MiniDrawer {
    public static final int PROFILE = 1;
    public static final int ITEM = 2;
    private LinearLayout mContainer;
    private RecyclerView mRecyclerView;
    protected FastAdapter<IDrawerItem> mAdapter;
    protected ItemAdapter<IDrawerItem> mItemAdapter;
    private Drawer mDrawer;
    private AccountHeader mAccountHeader;
    private ICrossfader mCrossFader;
    private boolean mInnerShadow = false;
    private boolean mInRTL = false;
    private boolean mIncludeSecondaryDrawerItems = false;
    private boolean mEnableSelectedMiniDrawerItemBackground = false;
    private boolean mEnableProfileClick = true;
    private OnMiniDrawerItemClickListener mOnMiniDrawerItemClickListener;
    private OnClickListener<IDrawerItem> mOnMiniDrawerItemOnClickListener;
    private OnLongClickListener<IDrawerItem> mOnMiniDrawerItemLongClickListener;

    public MiniDrawer withDrawer(@NonNull Drawer drawer) {
        this.mDrawer = drawer;
        return this;
    }

    public MiniDrawer withAccountHeader(@NonNull AccountHeader accountHeader) {
        this.mAccountHeader = accountHeader;
        return this;
    }

    public MiniDrawer withCrossFader(@NonNull ICrossfader crossFader) {
        this.mCrossFader = crossFader;
        return this;
    }

    public MiniDrawer withInnerShadow(boolean innerShadow) {
        this.mInnerShadow = innerShadow;
        return this;
    }

    public MiniDrawer withInRTL(boolean inRTL) {
        this.mInRTL = inRTL;
        return this;
    }

    public MiniDrawer withIncludeSecondaryDrawerItems(boolean includeSecondaryDrawerItems) {
        this.mIncludeSecondaryDrawerItems = includeSecondaryDrawerItems;
        return this;
    }

    public MiniDrawer withEnableSelectedMiniDrawerItemBackground(boolean enableSelectedMiniDrawerItemBackground) {
        this.mEnableSelectedMiniDrawerItemBackground = enableSelectedMiniDrawerItemBackground;
        return this;
    }

    public MiniDrawer withEnableProfileClick(boolean enableProfileClick) {
        this.mEnableProfileClick = enableProfileClick;
        return this;
    }

    public MiniDrawer withOnMiniDrawerItemClickListener(OnMiniDrawerItemClickListener onMiniDrawerItemClickListener) {
        this.mOnMiniDrawerItemClickListener = onMiniDrawerItemClickListener;
        return this;
    }

    public MiniDrawer withOnMiniDrawerItemOnClickListener(OnClickListener<IDrawerItem> onMiniDrawerItemOnClickListener) {
        this.mOnMiniDrawerItemOnClickListener = onMiniDrawerItemOnClickListener;
        return this;
    }

    public MiniDrawer withOnMiniDrawerItemLongClickListener(OnLongClickListener<IDrawerItem> onMiniDrawerItemLongClickListener) {
        this.mOnMiniDrawerItemLongClickListener = onMiniDrawerItemLongClickListener;
        return this;
    }

    public RecyclerView getRecyclerView() {
        return this.mRecyclerView;
    }

    public FastAdapter<IDrawerItem> getAdapter() {
        return this.mAdapter;
    }

    public ItemAdapter<IDrawerItem> getItemAdapter() {
        return this.mItemAdapter;
    }

    public Drawer getDrawer() {
        return this.mDrawer;
    }

    public AccountHeader getAccountHeader() {
        return this.mAccountHeader;
    }

    public ICrossfader getCrossFader() {
        return this.mCrossFader;
    }

    public OnClickListener getOnMiniDrawerItemOnClickListener() {
        return this.mOnMiniDrawerItemOnClickListener;
    }

    public OnLongClickListener getOnMiniDrawerItemLongClickListener() {
        return this.mOnMiniDrawerItemLongClickListener;
    }

    public IDrawerItem generateMiniDrawerItem(IDrawerItem drawerItem) {
        if (drawerItem instanceof SecondaryDrawerItem) {
            return this.mIncludeSecondaryDrawerItems ? (MiniDrawerItem)new MiniDrawerItem((SecondaryDrawerItem)drawerItem).withEnableSelectedBackground(this.mEnableSelectedMiniDrawerItemBackground).withSelectedBackgroundAnimated(false) : null;
        }
        if (drawerItem instanceof PrimaryDrawerItem) {
            return (IDrawerItem)new MiniDrawerItem((PrimaryDrawerItem)drawerItem).withEnableSelectedBackground(this.mEnableSelectedMiniDrawerItemBackground).withSelectedBackgroundAnimated(false);
        }
        if (drawerItem instanceof ProfileDrawerItem) {
            MiniProfileDrawerItem mpdi = new MiniProfileDrawerItem((ProfileDrawerItem)drawerItem);
            mpdi.withEnabled(this.mEnableProfileClick);
            return mpdi;
        }
        return null;
    }

    public int getMiniDrawerType(IDrawerItem drawerItem) {
        if (drawerItem instanceof MiniProfileDrawerItem) {
            return 1;
        }
        if (drawerItem instanceof MiniDrawerItem) {
            return 2;
        }
        return -1;
    }

    public View build(Context ctx) {
        this.mContainer = new LinearLayout(ctx);
        if (this.mInnerShadow) {
            if (!this.mInRTL) {
                this.mContainer.setBackgroundResource(R.drawable.material_drawer_shadow_left);
            } else {
                this.mContainer.setBackgroundResource(R.drawable.material_drawer_shadow_right);
            }
        }
        this.mRecyclerView = new RecyclerView(ctx);
        this.mContainer.addView((View)this.mRecyclerView, -1, -1);
        this.mRecyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
        this.mRecyclerView.setFadingEdgeLength(0);
        this.mRecyclerView.setClipToPadding(false);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(ctx));
        this.mItemAdapter = new ItemAdapter();
        this.mAdapter = FastAdapter.with(this.mItemAdapter);
        this.mAdapter.withSelectable(true);
        this.mAdapter.withAllowDeselection(false);
        this.mRecyclerView.setAdapter(this.mAdapter);
        if (this.mDrawer != null && this.mDrawer.mDrawerBuilder != null && (this.mDrawer.mDrawerBuilder.mFullscreen || this.mDrawer.mDrawerBuilder.mTranslucentStatusBar)) {
            this.mRecyclerView.setPadding(this.mRecyclerView.getPaddingLeft(), UIUtils.getStatusBarHeight((Context)ctx), this.mRecyclerView.getPaddingRight(), this.mRecyclerView.getPaddingBottom());
        }
        if (this.mDrawer != null && this.mDrawer.mDrawerBuilder != null && (this.mDrawer.mDrawerBuilder.mFullscreen || this.mDrawer.mDrawerBuilder.mTranslucentNavigationBar) && ctx.getResources().getConfiguration().orientation == 1) {
            this.mRecyclerView.setPadding(this.mRecyclerView.getPaddingLeft(), this.mRecyclerView.getPaddingTop(), this.mRecyclerView.getPaddingRight(), UIUtils.getNavigationBarHeight((Context)ctx));
        }
        this.createItems();
        return this.mContainer;
    }

    public void onProfileClick() {
        IProfile profile;
        if (this.mCrossFader != null && this.mCrossFader.isCrossfaded()) {
            this.mCrossFader.crossfade();
        }
        if (this.mAccountHeader != null && (profile = this.mAccountHeader.getActiveProfile()) instanceof IDrawerItem) {
            this.mItemAdapter.set(0, (Object)this.generateMiniDrawerItem((IDrawerItem)((Object)profile)));
        }
    }

    public boolean onItemClick(IDrawerItem selectedDrawerItem) {
        if (selectedDrawerItem.isSelectable()) {
            if (this.mCrossFader != null && this.mCrossFader.isCrossfaded()) {
                this.mCrossFader.crossfade();
            }
            this.setSelection(selectedDrawerItem.getIdentifier());
            return false;
        }
        return true;
    }

    public void setSelection(long identifier) {
        if (identifier == -1L) {
            this.mAdapter.deselect();
        }
        int count = this.mAdapter.getItemCount();
        for (int i = 0; i < count; ++i) {
            IDrawerItem item = (IDrawerItem)this.mAdapter.getItem(i);
            if (item.getIdentifier() != identifier || item.isSelected()) continue;
            this.mAdapter.deselect();
            this.mAdapter.select(i);
        }
    }

    public void updateItem(long identifier) {
        if (this.mDrawer != null && this.mAdapter != null && this.mItemAdapter.getAdapterItems() != null && identifier != -1L) {
            IDrawerItem drawerItem = DrawerUtils.getDrawerItem(this.getDrawerItems(), identifier);
            for (int i = 0; i < this.mItemAdapter.getAdapterItems().size(); ++i) {
                IDrawerItem miniDrawerItem;
                if (((IDrawerItem)this.mItemAdapter.getAdapterItems().get(i)).getIdentifier() != drawerItem.getIdentifier() || (miniDrawerItem = this.generateMiniDrawerItem(drawerItem)) == null) continue;
                this.mItemAdapter.set(i, (Object)miniDrawerItem);
            }
        }
    }

    public void createItems() {
        IProfile profile;
        this.mItemAdapter.clear();
        int profileOffset = 0;
        if (this.mAccountHeader != null && this.mAccountHeader.getAccountHeaderBuilder().mProfileImagesVisible && (profile = this.mAccountHeader.getActiveProfile()) instanceof IDrawerItem) {
            this.mItemAdapter.add((Object[])new IDrawerItem[]{this.generateMiniDrawerItem((IDrawerItem)((Object)profile))});
            profileOffset = 1;
        }
        int select = -1;
        if (this.mDrawer != null && this.getDrawerItems() != null) {
            int length = this.getDrawerItems().size();
            int position = 0;
            for (int i = 0; i < length; ++i) {
                IDrawerItem miniDrawerItem = this.generateMiniDrawerItem(this.getDrawerItems().get(i));
                if (miniDrawerItem == null) continue;
                if (miniDrawerItem.isSelected()) {
                    select = position;
                }
                this.mItemAdapter.add((Object[])new IDrawerItem[]{miniDrawerItem});
                ++position;
            }
            if (select >= 0) {
                this.mAdapter.select(select + profileOffset);
            }
        }
        if (this.mOnMiniDrawerItemOnClickListener != null) {
            this.mAdapter.withOnClickListener(this.mOnMiniDrawerItemOnClickListener);
        } else {
            this.mAdapter.withOnClickListener((OnClickListener)new OnClickListener<IDrawerItem>(){

                public boolean onClick(View v, IAdapter<IDrawerItem> adapter, IDrawerItem item, int position) {
                    int type = MiniDrawer.this.getMiniDrawerType(item);
                    if (MiniDrawer.this.mOnMiniDrawerItemClickListener != null && MiniDrawer.this.mOnMiniDrawerItemClickListener.onItemClick(v, position, item, type)) {
                        return false;
                    }
                    if (type == 2) {
                        if (item.isSelectable()) {
                            IDrawerItem drawerItem;
                            if (MiniDrawer.this.mAccountHeader != null && MiniDrawer.this.mAccountHeader.isSelectionListShown()) {
                                MiniDrawer.this.mAccountHeader.toggleSelectionList(v.getContext());
                            }
                            if ((drawerItem = MiniDrawer.this.mDrawer.getDrawerItem(item.getIdentifier())) != null && !drawerItem.isSelected()) {
                                MiniDrawer.this.mDrawer.setSelection(item, true);
                            }
                        } else if (MiniDrawer.this.mDrawer.getOnDrawerItemClickListener() != null) {
                            MiniDrawer.this.mDrawer.getOnDrawerItemClickListener().onItemClick(v, position, DrawerUtils.getDrawerItem((List<IDrawerItem>)MiniDrawer.this.getDrawerItems(), item.getIdentifier()));
                        }
                    } else if (type == 1) {
                        if (MiniDrawer.this.mAccountHeader != null && !MiniDrawer.this.mAccountHeader.isSelectionListShown()) {
                            MiniDrawer.this.mAccountHeader.toggleSelectionList(v.getContext());
                        }
                        if (MiniDrawer.this.mCrossFader != null) {
                            MiniDrawer.this.mCrossFader.crossfade();
                        }
                    }
                    return false;
                }
            });
        }
        this.mAdapter.withOnLongClickListener(this.mOnMiniDrawerItemLongClickListener);
        this.mRecyclerView.scrollToPosition(0);
    }

    private List<IDrawerItem> getDrawerItems() {
        return this.mDrawer.getOriginalDrawerItems() != null ? this.mDrawer.getOriginalDrawerItems() : this.mDrawer.getDrawerItems();
    }

    public static interface OnMiniDrawerItemClickListener {
        public boolean onItemClick(View var1, int var2, IDrawerItem var3, int var4);
    }
}

