/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.holder;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.Dimension;
import androidx.annotation.DrawableRes;
import androidx.core.view.ViewCompat;
import com.mikepenz.materialdrawer.R;
import com.mikepenz.materialdrawer.holder.ColorHolder;
import com.mikepenz.materialdrawer.holder.DimenHolder;
import com.mikepenz.materialdrawer.model.utils.BadgeDrawableBuilder;

public class BadgeStyle {
    private int mGradientDrawable = R.drawable.material_drawer_badge;
    private Drawable mBadgeBackground;
    private ColorHolder mColor;
    private ColorHolder mColorPressed;
    private ColorHolder mTextColor;
    private ColorStateList mTextColorStateList;
    private DimenHolder mCorners;
    private DimenHolder mPaddingTopBottom = DimenHolder.fromDp(2);
    private DimenHolder mPaddingLeftRight = DimenHolder.fromDp(3);
    private DimenHolder mMinWidth = DimenHolder.fromDp(20);

    public int getGradientDrawable() {
        return this.mGradientDrawable;
    }

    public BadgeStyle withGradientDrawable(@DrawableRes int gradientDrawable) {
        this.mGradientDrawable = gradientDrawable;
        this.mBadgeBackground = null;
        return this;
    }

    public Drawable getBadgeBackground() {
        return this.mBadgeBackground;
    }

    public BadgeStyle withBadgeBackground(Drawable badgeBackground) {
        this.mBadgeBackground = badgeBackground;
        this.mGradientDrawable = -1;
        return this;
    }

    public ColorHolder getColor() {
        return this.mColor;
    }

    public BadgeStyle withColor(@ColorInt int color2) {
        this.mColor = ColorHolder.fromColor(color2);
        return this;
    }

    public BadgeStyle withColorRes(@ColorRes int color2) {
        this.mColor = ColorHolder.fromColorRes(color2);
        return this;
    }

    public ColorHolder getColorPressed() {
        return this.mColorPressed;
    }

    public BadgeStyle withColorPressed(@ColorInt int colorPressed) {
        this.mColorPressed = ColorHolder.fromColor(colorPressed);
        return this;
    }

    public BadgeStyle withColorPressedRes(@ColorRes int colorPressed) {
        this.mColorPressed = ColorHolder.fromColorRes(colorPressed);
        return this;
    }

    public ColorHolder getTextColor() {
        return this.mTextColor;
    }

    public BadgeStyle withTextColor(@ColorInt int textColor) {
        this.mTextColor = ColorHolder.fromColor(textColor);
        return this;
    }

    public BadgeStyle withTextColorRes(@ColorRes int textColor) {
        this.mTextColor = ColorHolder.fromColorRes(textColor);
        return this;
    }

    public BadgeStyle withTextColorStateList(ColorStateList textColorStateList) {
        this.mTextColor = null;
        this.mTextColorStateList = textColorStateList;
        return this;
    }

    public DimenHolder getCorners() {
        return this.mCorners;
    }

    public BadgeStyle withCorners(@Dimension(unit=1) int cornersPx) {
        this.mCorners = DimenHolder.fromPixel(cornersPx);
        return this;
    }

    public BadgeStyle withCornersDp(@Dimension(unit=0) int corners) {
        this.mCorners = DimenHolder.fromDp(corners);
        return this;
    }

    public BadgeStyle withCorners(DimenHolder corners) {
        this.mCorners = corners;
        return this;
    }

    public DimenHolder getPaddingLeftRight() {
        return this.mPaddingLeftRight;
    }

    public BadgeStyle withPaddingLeftRightPx(@Dimension(unit=1) int paddingLeftRight) {
        this.mPaddingLeftRight = DimenHolder.fromPixel(paddingLeftRight);
        return this;
    }

    public BadgeStyle withPaddingLeftRightDp(@Dimension(unit=0) int paddingLeftRight) {
        this.mPaddingLeftRight = DimenHolder.fromDp(paddingLeftRight);
        return this;
    }

    public BadgeStyle withPaddingLeftRightRes(@DimenRes int paddingLeftRight) {
        this.mPaddingLeftRight = DimenHolder.fromResource(paddingLeftRight);
        return this;
    }

    public DimenHolder getPaddingTopBottom() {
        return this.mPaddingTopBottom;
    }

    public BadgeStyle withPaddingTopBottomPx(@Dimension(unit=1) int paddingTopBottom) {
        this.mPaddingTopBottom = DimenHolder.fromPixel(paddingTopBottom);
        return this;
    }

    public BadgeStyle withPaddingTopBottomDp(@Dimension(unit=0) int paddingTopBottom) {
        this.mPaddingTopBottom = DimenHolder.fromDp(paddingTopBottom);
        return this;
    }

    public BadgeStyle withPaddingTopBottomRes(@DimenRes int paddingTopBottom) {
        this.mPaddingTopBottom = DimenHolder.fromResource(paddingTopBottom);
        return this;
    }

    public BadgeStyle withPadding(@Dimension(unit=1) int padding) {
        this.mPaddingLeftRight = DimenHolder.fromPixel(padding);
        this.mPaddingTopBottom = DimenHolder.fromPixel(padding);
        return this;
    }

    public BadgeStyle withPadding(DimenHolder padding) {
        this.mPaddingLeftRight = padding;
        this.mPaddingTopBottom = padding;
        return this;
    }

    public DimenHolder getMinWidth() {
        return this.mMinWidth;
    }

    public BadgeStyle withMinWidth(@Dimension(unit=1) int minWidth) {
        this.mMinWidth = DimenHolder.fromPixel(minWidth);
        return this;
    }

    public BadgeStyle withMinWidth(DimenHolder minWidth) {
        this.mMinWidth = minWidth;
        return this;
    }

    public BadgeStyle() {
    }

    public BadgeStyle(@ColorInt int color2, @ColorInt int colorPressed) {
        this.mColor = ColorHolder.fromColor(color2);
        this.mColorPressed = ColorHolder.fromColor(colorPressed);
    }

    public BadgeStyle(@DrawableRes int gradientDrawable, @ColorInt int color2, @ColorInt int colorPressed, @ColorInt int textColor) {
        this.mGradientDrawable = gradientDrawable;
        this.mColor = ColorHolder.fromColor(color2);
        this.mColorPressed = ColorHolder.fromColor(colorPressed);
        this.mTextColor = ColorHolder.fromColor(textColor);
    }

    public void style(TextView badgeTextView) {
        this.style(badgeTextView, null);
    }

    public void style(TextView badgeTextView, ColorStateList colorStateList) {
        Context ctx = badgeTextView.getContext();
        if (this.mBadgeBackground == null) {
            ViewCompat.setBackground((View)badgeTextView, (Drawable)new BadgeDrawableBuilder(this).build(ctx));
        } else {
            ViewCompat.setBackground((View)badgeTextView, (Drawable)this.mBadgeBackground);
        }
        if (this.mTextColor != null) {
            ColorHolder.applyToOr((com.mikepenz.materialize.holder.ColorHolder)this.mTextColor, (TextView)badgeTextView, null);
        } else if (this.mTextColorStateList != null) {
            badgeTextView.setTextColor(this.mTextColorStateList);
        } else if (colorStateList != null) {
            badgeTextView.setTextColor(colorStateList);
        }
        int paddingLeftRight = this.mPaddingLeftRight.asPixel(ctx);
        int paddingTopBottom = this.mPaddingTopBottom.asPixel(ctx);
        badgeTextView.setPadding(paddingLeftRight, paddingTopBottom, paddingLeftRight, paddingTopBottom);
        badgeTextView.setMinWidth(this.mMinWidth.asPixel(ctx));
    }
}

