/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.holder;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.widget.ImageView;
import androidx.annotation.DrawableRes;
import androidx.appcompat.content.res.AppCompatResources;
import com.mikepenz.iconics.IconicsDrawable;
import com.mikepenz.iconics.typeface.IIcon;
import com.mikepenz.materialdrawer.util.DrawerImageLoader;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class ImageHolder
extends com.mikepenz.materialize.holder.ImageHolder {
    private IIcon mIIcon;

    public ImageHolder(String url) {
        super(url);
    }

    public ImageHolder(Uri uri) {
        super(uri);
    }

    public ImageHolder(Drawable icon) {
        super(icon);
    }

    public ImageHolder(Bitmap bitmap) {
        super(bitmap);
    }

    public ImageHolder(@DrawableRes int iconRes) {
        super(iconRes);
    }

    public ImageHolder(IIcon iicon) {
        super((Bitmap)null);
        this.mIIcon = iicon;
    }

    public IIcon getIIcon() {
        return this.mIIcon;
    }

    public void setIIcon(IIcon mIIcon) {
        this.mIIcon = mIIcon;
    }

    public boolean applyTo(ImageView imageView, String tag) {
        if (this.getUri() != null) {
            boolean consumed = DrawerImageLoader.getInstance().setImage(imageView, this.getUri(), tag);
            if (!consumed) {
                imageView.setImageURI(this.getUri());
            }
        } else if (this.getIcon() != null) {
            imageView.setImageDrawable(this.getIcon());
        } else if (this.getBitmap() != null) {
            imageView.setImageBitmap(this.getBitmap());
        } else if (this.getIconRes() != -1) {
            imageView.setImageResource(this.getIconRes());
        } else if (this.mIIcon != null) {
            imageView.setImageDrawable((Drawable)new IconicsDrawable(imageView.getContext(), this.mIIcon).actionBar());
        } else {
            imageView.setImageBitmap(null);
            return false;
        }
        return true;
    }

    public Drawable decideIcon(Context ctx, int iconColor, boolean tint, int paddingDp) {
        Drawable icon = this.getIcon();
        if (this.mIIcon != null) {
            icon = new IconicsDrawable(ctx, this.mIIcon).color(iconColor).sizeDp(24).paddingDp(paddingDp);
        } else if (this.getIconRes() != -1) {
            icon = AppCompatResources.getDrawable((Context)ctx, (int)this.getIconRes());
        } else if (this.getUri() != null) {
            try {
                InputStream inputStream = ctx.getContentResolver().openInputStream(this.getUri());
                icon = Drawable.createFromStream((InputStream)inputStream, (String)this.getUri().toString());
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if (icon != null && tint && this.mIIcon == null) {
            icon = icon.mutate();
            icon.setColorFilter(iconColor, PorterDuff.Mode.SRC_IN);
        }
        return icon;
    }

    public static Drawable decideIcon(ImageHolder imageHolder, Context ctx, int iconColor, boolean tint, int paddingDp) {
        if (imageHolder == null) {
            return null;
        }
        return imageHolder.decideIcon(ctx, iconColor, tint, paddingDp);
    }

    public static void applyDecidedIconOrSetGone(ImageHolder imageHolder, ImageView imageView, int iconColor, boolean tint, int paddingDp) {
        if (imageHolder != null && imageView != null) {
            Drawable drawable2 = ImageHolder.decideIcon(imageHolder, imageView.getContext(), iconColor, tint, paddingDp);
            if (drawable2 != null) {
                imageView.setImageDrawable(drawable2);
                imageView.setVisibility(0);
            } else if (imageHolder.getBitmap() != null) {
                imageView.setImageBitmap(imageHolder.getBitmap());
                imageView.setVisibility(0);
            } else {
                imageView.setVisibility(8);
            }
        } else if (imageView != null) {
            imageView.setVisibility(8);
        }
    }
}

