/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.model;

import android.content.Context;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.LayoutRes;
import androidx.annotation.StringRes;
import com.mikepenz.materialdrawer.R;
import com.mikepenz.materialdrawer.holder.BadgeStyle;
import com.mikepenz.materialdrawer.holder.StringHolder;
import com.mikepenz.materialdrawer.model.BaseDescribeableDrawerItem;
import com.mikepenz.materialdrawer.model.BaseViewHolder;
import com.mikepenz.materialdrawer.model.interfaces.ColorfulBadgeable;
import java.util.List;

public abstract class AbstractBadgeableDrawerItem<Item extends AbstractBadgeableDrawerItem>
extends BaseDescribeableDrawerItem<Item, ViewHolder>
implements ColorfulBadgeable<Item> {
    protected StringHolder mBadge;
    protected BadgeStyle mBadgeStyle = new BadgeStyle();

    @Override
    public Item withBadge(StringHolder badge) {
        this.mBadge = badge;
        return (Item)this;
    }

    @Override
    public Item withBadge(String badge) {
        this.mBadge = new StringHolder(badge);
        return (Item)this;
    }

    @Override
    public Item withBadge(@StringRes int badgeRes) {
        this.mBadge = new StringHolder(badgeRes);
        return (Item)this;
    }

    @Override
    public Item withBadgeStyle(BadgeStyle badgeStyle) {
        this.mBadgeStyle = badgeStyle;
        return (Item)this;
    }

    @Override
    public StringHolder getBadge() {
        return this.mBadge;
    }

    @Override
    public BadgeStyle getBadgeStyle() {
        return this.mBadgeStyle;
    }

    @Override
    public int getType() {
        return R.id.material_drawer_item_primary;
    }

    @Override
    @LayoutRes
    public int getLayoutRes() {
        return R.layout.material_drawer_item_primary;
    }

    @Override
    public void bindView(ViewHolder viewHolder, List payloads) {
        super.bindView(viewHolder, payloads);
        Context ctx = viewHolder.itemView.getContext();
        this.bindViewHelper(viewHolder);
        boolean badgeVisible = StringHolder.applyToOrHide((com.mikepenz.materialize.holder.StringHolder)this.mBadge, (TextView)viewHolder.badge);
        if (badgeVisible) {
            this.mBadgeStyle.style(viewHolder.badge, this.getTextColorStateList(this.getColor(ctx), this.getSelectedTextColor(ctx)));
            viewHolder.badgeContainer.setVisibility(0);
        } else {
            viewHolder.badgeContainer.setVisibility(8);
        }
        if (this.getTypeface() != null) {
            viewHolder.badge.setTypeface(this.getTypeface());
        }
        this.onPostBindView(this, viewHolder.itemView);
    }

    @Override
    public ViewHolder getViewHolder(View v) {
        return new ViewHolder(v);
    }

    public static class ViewHolder
    extends BaseViewHolder {
        private View badgeContainer;
        private TextView badge;

        public ViewHolder(View view) {
            super(view);
            this.badgeContainer = view.findViewById(R.id.material_drawer_badge_container);
            this.badge = (TextView)view.findViewById(R.id.material_drawer_badge);
        }
    }
}

