/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.model;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.CallSuper;
import androidx.recyclerview.widget.RecyclerView;
import com.mikepenz.materialdrawer.Drawer;
import com.mikepenz.materialdrawer.R;
import com.mikepenz.materialdrawer.model.interfaces.IDrawerItem;
import com.mikepenz.materialdrawer.model.interfaces.OnPostBindViewListener;
import com.mikepenz.materialdrawer.model.interfaces.Selectable;
import com.mikepenz.materialdrawer.model.interfaces.Tagable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractDrawerItem<T, VH extends RecyclerView.ViewHolder>
implements IDrawerItem<T, VH>,
Selectable<T>,
Tagable<T> {
    protected long mIdentifier = -1L;
    protected Object mTag;
    protected boolean mEnabled = true;
    protected boolean mSelected = false;
    protected boolean mSelectable = true;
    protected boolean mSelectedBackgroundAnimated = true;
    public Drawer.OnDrawerItemClickListener mOnDrawerItemClickListener = null;
    protected OnPostBindViewListener mOnPostBindViewListener = null;
    private IDrawerItem mParent;
    protected List<IDrawerItem> mSubItems;
    private boolean mExpanded = false;

    public T withIdentifier(long identifier) {
        this.mIdentifier = identifier;
        return (T)this;
    }

    public long getIdentifier() {
        return this.mIdentifier;
    }

    @Override
    public T withTag(Object object) {
        this.mTag = object;
        return (T)this;
    }

    @Override
    public Object getTag() {
        return this.mTag;
    }

    public T withEnabled(boolean enabled) {
        this.mEnabled = enabled;
        return (T)this;
    }

    @Override
    public boolean isEnabled() {
        return this.mEnabled;
    }

    @Override
    public T withSetSelected(boolean selected) {
        this.mSelected = selected;
        return (T)this;
    }

    @Override
    public boolean isSelected() {
        return this.mSelected;
    }

    @Override
    public T withSelectable(boolean selectable) {
        this.mSelectable = selectable;
        return (T)this;
    }

    @Override
    public boolean isSelectable() {
        return this.mSelectable;
    }

    public T withSelectedBackgroundAnimated(boolean selectedBackgroundAnimated) {
        this.mSelectedBackgroundAnimated = selectedBackgroundAnimated;
        return (T)this;
    }

    public boolean isSelectedBackgroundAnimated() {
        return this.mSelectedBackgroundAnimated;
    }

    public Drawer.OnDrawerItemClickListener getOnDrawerItemClickListener() {
        return this.mOnDrawerItemClickListener;
    }

    public T withOnDrawerItemClickListener(Drawer.OnDrawerItemClickListener onDrawerItemClickListener) {
        this.mOnDrawerItemClickListener = onDrawerItemClickListener;
        return (T)this;
    }

    public OnPostBindViewListener getOnPostBindViewListener() {
        return this.mOnPostBindViewListener;
    }

    public T withPostOnBindViewListener(OnPostBindViewListener onPostBindViewListener) {
        this.mOnPostBindViewListener = onPostBindViewListener;
        return (T)this;
    }

    public void onPostBindView(IDrawerItem drawerItem, View view) {
        if (this.mOnPostBindViewListener != null) {
            this.mOnPostBindViewListener.onBindView(drawerItem, view);
        }
    }

    public IDrawerItem getParent() {
        return this.mParent;
    }

    public IDrawerItem withParent(IDrawerItem parent) {
        this.mParent = parent;
        return this;
    }

    public T withSubItems(List<IDrawerItem> subItems) {
        this.mSubItems = subItems;
        for (IDrawerItem subItem : subItems) {
            subItem.withParent(this);
        }
        return (T)this;
    }

    public T withSubItems(IDrawerItem ... subItems) {
        if (this.mSubItems == null) {
            this.mSubItems = new ArrayList<IDrawerItem>();
        }
        for (IDrawerItem subItem : subItems) {
            subItem.withParent(this);
        }
        Collections.addAll(this.mSubItems, subItems);
        return (T)this;
    }

    public List<IDrawerItem> getSubItems() {
        return this.mSubItems;
    }

    public T withIsExpanded(boolean expanded) {
        this.mExpanded = expanded;
        return (T)this;
    }

    public boolean isExpanded() {
        return this.mExpanded;
    }

    public boolean isAutoExpanding() {
        return true;
    }

    @Override
    public View generateView(Context ctx) {
        VH viewHolder = this.getViewHolder(LayoutInflater.from((Context)ctx).inflate(this.getLayoutRes(), null, false));
        this.bindView(viewHolder, Collections.emptyList());
        return ((RecyclerView.ViewHolder)viewHolder).itemView;
    }

    @Override
    public View generateView(Context ctx, ViewGroup parent) {
        VH viewHolder = this.getViewHolder(LayoutInflater.from((Context)ctx).inflate(this.getLayoutRes(), parent, false));
        this.bindView(viewHolder, Collections.emptyList());
        return ((RecyclerView.ViewHolder)viewHolder).itemView;
    }

    @Override
    @CallSuper
    public void bindView(VH holder, List<Object> payloads) {
        ((RecyclerView.ViewHolder)holder).itemView.setTag(R.id.material_drawer_item, (Object)this);
    }

    @Override
    public void unbindView(VH holder) {
        ((RecyclerView.ViewHolder)holder).itemView.clearAnimation();
    }

    public void attachToWindow(VH holder) {
    }

    public void detachFromWindow(VH holder) {
    }

    public boolean failedToRecycle(VH holder) {
        return false;
    }

    @Override
    public VH getViewHolder(ViewGroup parent) {
        return this.getViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(this.getLayoutRes(), parent, false));
    }

    public abstract VH getViewHolder(View var1);

    @Override
    public boolean equals(long id2) {
        return id2 == this.mIdentifier;
    }

    public boolean equals(int id2) {
        return (long)id2 == this.mIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractDrawerItem that = (AbstractDrawerItem)o;
        return this.mIdentifier == that.mIdentifier;
    }

    public int hashCode() {
        return Long.valueOf(this.mIdentifier).hashCode();
    }
}

