/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.model;

import android.view.View;
import android.widget.CompoundButton;
import androidx.annotation.LayoutRes;
import androidx.appcompat.widget.SwitchCompat;
import com.mikepenz.materialdrawer.Drawer;
import com.mikepenz.materialdrawer.R;
import com.mikepenz.materialdrawer.interfaces.OnCheckedChangeListener;
import com.mikepenz.materialdrawer.model.BaseDescribeableDrawerItem;
import com.mikepenz.materialdrawer.model.BaseViewHolder;
import com.mikepenz.materialdrawer.model.interfaces.IDrawerItem;
import java.util.List;

public abstract class AbstractSwitchableDrawerItem<Item extends AbstractSwitchableDrawerItem>
extends BaseDescribeableDrawerItem<Item, ViewHolder> {
    private boolean switchEnabled = true;
    private boolean checked = false;
    private OnCheckedChangeListener onCheckedChangeListener = null;
    private CompoundButton.OnCheckedChangeListener checkedChangeListener = new CompoundButton.OnCheckedChangeListener(){

        public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
            if (AbstractSwitchableDrawerItem.this.isEnabled()) {
                AbstractSwitchableDrawerItem.this.checked = isChecked;
                if (AbstractSwitchableDrawerItem.this.getOnCheckedChangeListener() != null) {
                    AbstractSwitchableDrawerItem.this.getOnCheckedChangeListener().onCheckedChanged(AbstractSwitchableDrawerItem.this, buttonView, isChecked);
                }
            } else {
                buttonView.setOnCheckedChangeListener(null);
                buttonView.setChecked(!isChecked);
                buttonView.setOnCheckedChangeListener(AbstractSwitchableDrawerItem.this.checkedChangeListener);
            }
        }
    };

    public Item withChecked(boolean checked) {
        this.checked = checked;
        return (Item)this;
    }

    public Item withSwitchEnabled(boolean switchEnabled) {
        this.switchEnabled = switchEnabled;
        return (Item)this;
    }

    public Item withOnCheckedChangeListener(OnCheckedChangeListener onCheckedChangeListener) {
        this.onCheckedChangeListener = onCheckedChangeListener;
        return (Item)this;
    }

    public Item withCheckable(boolean checkable) {
        return (Item)((AbstractSwitchableDrawerItem)this.withSelectable(checkable));
    }

    public boolean isChecked() {
        return this.checked;
    }

    public boolean isSwitchEnabled() {
        return this.switchEnabled;
    }

    public OnCheckedChangeListener getOnCheckedChangeListener() {
        return this.onCheckedChangeListener;
    }

    @Override
    public int getType() {
        return R.id.material_drawer_item_primary_switch;
    }

    @Override
    @LayoutRes
    public int getLayoutRes() {
        return R.layout.material_drawer_item_switch;
    }

    @Override
    public void bindView(final ViewHolder viewHolder, List payloads) {
        super.bindView(viewHolder, payloads);
        this.bindViewHelper(viewHolder);
        viewHolder.switchView.setOnCheckedChangeListener(null);
        viewHolder.switchView.setChecked(this.checked);
        viewHolder.switchView.setOnCheckedChangeListener(this.checkedChangeListener);
        viewHolder.switchView.setEnabled(this.switchEnabled);
        this.withOnDrawerItemClickListener(new Drawer.OnDrawerItemClickListener(){

            @Override
            public boolean onItemClick(View view, int position, IDrawerItem drawerItem) {
                if (!AbstractSwitchableDrawerItem.this.isSelectable()) {
                    AbstractSwitchableDrawerItem.this.checked = !AbstractSwitchableDrawerItem.this.checked;
                    viewHolder.switchView.setChecked(AbstractSwitchableDrawerItem.this.checked);
                }
                return false;
            }
        });
        this.onPostBindView(this, viewHolder.itemView);
    }

    @Override
    public ViewHolder getViewHolder(View v) {
        return new ViewHolder(v);
    }

    public static class ViewHolder
    extends BaseViewHolder {
        private SwitchCompat switchView;

        private ViewHolder(View view) {
            super(view);
            this.switchView = (SwitchCompat)view.findViewById(R.id.material_drawer_switch);
        }
    }
}

