/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.model;

import android.view.View;
import android.widget.CompoundButton;
import android.widget.ToggleButton;
import androidx.annotation.LayoutRes;
import com.mikepenz.materialdrawer.Drawer;
import com.mikepenz.materialdrawer.R;
import com.mikepenz.materialdrawer.interfaces.OnCheckedChangeListener;
import com.mikepenz.materialdrawer.model.BaseDescribeableDrawerItem;
import com.mikepenz.materialdrawer.model.BaseViewHolder;
import com.mikepenz.materialdrawer.model.interfaces.IDrawerItem;
import java.util.List;

public class AbstractToggleableDrawerItem<Item extends AbstractToggleableDrawerItem>
extends BaseDescribeableDrawerItem<Item, ViewHolder> {
    private boolean toggleEnabled = true;
    private boolean checked = false;
    private OnCheckedChangeListener onCheckedChangeListener = null;
    private CompoundButton.OnCheckedChangeListener checkedChangeListener = new CompoundButton.OnCheckedChangeListener(){

        public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
            if (AbstractToggleableDrawerItem.this.isEnabled()) {
                AbstractToggleableDrawerItem.this.checked = isChecked;
                if (AbstractToggleableDrawerItem.this.getOnCheckedChangeListener() != null) {
                    AbstractToggleableDrawerItem.this.getOnCheckedChangeListener().onCheckedChanged(AbstractToggleableDrawerItem.this, buttonView, isChecked);
                }
            } else {
                buttonView.setOnCheckedChangeListener(null);
                buttonView.setChecked(!isChecked);
                buttonView.setOnCheckedChangeListener(AbstractToggleableDrawerItem.this.checkedChangeListener);
            }
        }
    };

    public Item withChecked(boolean checked) {
        this.checked = checked;
        return (Item)this;
    }

    public Item withToggleEnabled(boolean toggleEnabled) {
        this.toggleEnabled = toggleEnabled;
        return (Item)this;
    }

    public Item withOnCheckedChangeListener(OnCheckedChangeListener onCheckedChangeListener) {
        this.onCheckedChangeListener = onCheckedChangeListener;
        return (Item)this;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public boolean isToggleEnabled() {
        return this.toggleEnabled;
    }

    public void setToggleEnabled(boolean toggleEnabled) {
        this.toggleEnabled = toggleEnabled;
    }

    public OnCheckedChangeListener getOnCheckedChangeListener() {
        return this.onCheckedChangeListener;
    }

    public void setOnCheckedChangeListener(OnCheckedChangeListener onCheckedChangeListener) {
        this.onCheckedChangeListener = onCheckedChangeListener;
    }

    @Override
    public int getType() {
        return R.id.material_drawer_item_primary_toggle;
    }

    @Override
    @LayoutRes
    public int getLayoutRes() {
        return R.layout.material_drawer_item_toggle;
    }

    @Override
    public void bindView(final ViewHolder viewHolder, List payloads) {
        super.bindView(viewHolder, payloads);
        this.bindViewHelper(viewHolder);
        viewHolder.toggle.setOnCheckedChangeListener(null);
        viewHolder.toggle.setChecked(this.checked);
        viewHolder.toggle.setOnCheckedChangeListener(this.checkedChangeListener);
        viewHolder.toggle.setEnabled(this.toggleEnabled);
        this.withOnDrawerItemClickListener(new Drawer.OnDrawerItemClickListener(){

            @Override
            public boolean onItemClick(View view, int position, IDrawerItem drawerItem) {
                if (!AbstractToggleableDrawerItem.this.isSelectable()) {
                    AbstractToggleableDrawerItem.this.checked = !AbstractToggleableDrawerItem.this.checked;
                    viewHolder.toggle.setChecked(AbstractToggleableDrawerItem.this.checked);
                }
                return false;
            }
        });
        this.onPostBindView(this, viewHolder.itemView);
    }

    @Override
    public ViewHolder getViewHolder(View v) {
        return new ViewHolder(v);
    }

    public static class ViewHolder
    extends BaseViewHolder {
        private ToggleButton toggle;

        private ViewHolder(View view) {
            super(view);
            this.toggle = (ToggleButton)view.findViewById(R.id.material_drawer_toggle);
        }
    }
}

