/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.model;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.StringRes;
import com.mikepenz.materialdrawer.holder.ColorHolder;
import com.mikepenz.materialdrawer.holder.ImageHolder;
import com.mikepenz.materialdrawer.holder.StringHolder;
import com.mikepenz.materialdrawer.model.BaseDrawerItem;
import com.mikepenz.materialdrawer.model.BaseViewHolder;
import com.mikepenz.materialdrawer.util.DrawerUIUtils;

public abstract class BaseDescribeableDrawerItem<T, VH extends BaseViewHolder>
extends BaseDrawerItem<T, VH> {
    private StringHolder description;
    private ColorHolder descriptionTextColor;

    public T withDescription(String description) {
        this.description = new StringHolder(description);
        return (T)this;
    }

    public T withDescription(@StringRes int descriptionRes) {
        this.description = new StringHolder(descriptionRes);
        return (T)this;
    }

    public T withDescriptionTextColor(@ColorInt int color2) {
        this.descriptionTextColor = ColorHolder.fromColor(color2);
        return (T)this;
    }

    public T withDescriptionTextColorRes(@ColorRes int colorRes) {
        this.descriptionTextColor = ColorHolder.fromColorRes(colorRes);
        return (T)this;
    }

    public StringHolder getDescription() {
        return this.description;
    }

    public ColorHolder getDescriptionTextColor() {
        return this.descriptionTextColor;
    }

    protected void bindViewHelper(BaseViewHolder viewHolder) {
        Drawable icon;
        Context ctx = viewHolder.itemView.getContext();
        viewHolder.itemView.setId(this.hashCode());
        viewHolder.itemView.setSelected(this.isSelected());
        viewHolder.itemView.setEnabled(this.isEnabled());
        int selectedColor = this.getSelectedColor(ctx);
        int color2 = this.getColor(ctx);
        ColorStateList selectedTextColor = this.getTextColorStateList(color2, this.getSelectedTextColor(ctx));
        int iconColor = this.getIconColor(ctx);
        int selectedIconColor = this.getSelectedIconColor(ctx);
        DrawerUIUtils.themeDrawerItem(ctx, viewHolder.view, selectedColor, this.isSelectedBackgroundAnimated());
        StringHolder.applyTo((com.mikepenz.materialize.holder.StringHolder)this.getName(), (TextView)viewHolder.name);
        StringHolder.applyToOrHide((com.mikepenz.materialize.holder.StringHolder)this.getDescription(), (TextView)viewHolder.description);
        viewHolder.name.setTextColor(selectedTextColor);
        ColorHolder.applyToOr((com.mikepenz.materialize.holder.ColorHolder)this.getDescriptionTextColor(), (TextView)viewHolder.description, (ColorStateList)selectedTextColor);
        if (this.getTypeface() != null) {
            viewHolder.name.setTypeface(this.getTypeface());
            viewHolder.description.setTypeface(this.getTypeface());
        }
        if ((icon = ImageHolder.decideIcon(this.getIcon(), ctx, iconColor, this.isIconTinted(), 1)) != null) {
            Drawable selectedIcon = ImageHolder.decideIcon(this.getSelectedIcon(), ctx, selectedIconColor, this.isIconTinted(), 1);
            ImageHolder.applyMultiIconTo((Drawable)icon, (int)iconColor, (Drawable)selectedIcon, (int)selectedIconColor, (boolean)this.isIconTinted(), (ImageView)viewHolder.icon);
        } else {
            ImageHolder.applyDecidedIconOrSetGone(this.getIcon(), viewHolder.icon, iconColor, this.isIconTinted(), 1);
        }
        DrawerUIUtils.setDrawerVerticalPadding(viewHolder.view, this.level);
    }
}

