/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.model;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.LayoutRes;
import androidx.recyclerview.widget.RecyclerView;
import com.mikepenz.materialdrawer.R;
import com.mikepenz.materialdrawer.holder.DimenHolder;
import com.mikepenz.materialdrawer.model.AbstractDrawerItem;
import com.mikepenz.materialize.util.UIUtils;
import java.util.List;

public class ContainerDrawerItem
extends AbstractDrawerItem<ContainerDrawerItem, ViewHolder> {
    private DimenHolder mHeight;
    private View mView;
    private Position mViewPosition = Position.TOP;
    private boolean mDivider = true;

    public ContainerDrawerItem withHeight(DimenHolder height) {
        this.mHeight = height;
        return this;
    }

    public DimenHolder getHeight() {
        return this.mHeight;
    }

    public ContainerDrawerItem withView(View view) {
        this.mView = view;
        return this;
    }

    public View getView() {
        return this.mView;
    }

    public ContainerDrawerItem withViewPosition(Position position) {
        this.mViewPosition = position;
        return this;
    }

    public ContainerDrawerItem withDivider(boolean divider) {
        this.mDivider = divider;
        return this;
    }

    public Position getViewPosition() {
        return this.mViewPosition;
    }

    @Override
    public int getType() {
        return R.id.material_drawer_item_container;
    }

    @Override
    @LayoutRes
    public int getLayoutRes() {
        return R.layout.material_drawer_item_container;
    }

    @Override
    public void bindView(ViewHolder viewHolder, List payloads) {
        super.bindView(viewHolder, payloads);
        Context ctx = viewHolder.itemView.getContext();
        viewHolder.itemView.setId(this.hashCode());
        viewHolder.view.setEnabled(false);
        if (this.mView.getParent() != null) {
            ((ViewGroup)this.mView.getParent()).removeView(this.mView);
        }
        int height = -2;
        if (this.mHeight != null) {
            RecyclerView.LayoutParams lp = (RecyclerView.LayoutParams)viewHolder.view.getLayoutParams();
            lp.height = height = this.mHeight.asPixel(ctx);
            viewHolder.view.setLayoutParams((ViewGroup.LayoutParams)lp);
        }
        ((ViewGroup)viewHolder.view).removeAllViews();
        int dividerHeight = 0;
        if (this.mDivider) {
            dividerHeight = 1;
        }
        View divider = new View(ctx);
        divider.setMinimumHeight(dividerHeight);
        divider.setBackgroundColor(UIUtils.getThemeColorFromAttrOrRes((Context)ctx, (int)R.attr.material_drawer_divider, (int)R.color.material_drawer_divider));
        LinearLayout.LayoutParams dividerParams = new LinearLayout.LayoutParams(-1, (int)UIUtils.convertDpToPixel((float)dividerHeight, (Context)ctx));
        LinearLayout.LayoutParams viewParams = new LinearLayout.LayoutParams(-1, this.mHeight != null ? height - (int)UIUtils.convertDpToPixel((float)dividerHeight, (Context)ctx) : height);
        if (this.mViewPosition == Position.TOP) {
            ((ViewGroup)viewHolder.view).addView(this.mView, (ViewGroup.LayoutParams)viewParams);
            dividerParams.bottomMargin = ctx.getResources().getDimensionPixelSize(R.dimen.material_drawer_padding);
            ((ViewGroup)viewHolder.view).addView(divider, (ViewGroup.LayoutParams)dividerParams);
        } else if (this.mViewPosition == Position.BOTTOM) {
            dividerParams.topMargin = ctx.getResources().getDimensionPixelSize(R.dimen.material_drawer_padding);
            ((ViewGroup)viewHolder.view).addView(divider, (ViewGroup.LayoutParams)dividerParams);
            ((ViewGroup)viewHolder.view).addView(this.mView, (ViewGroup.LayoutParams)viewParams);
        } else {
            ((ViewGroup)viewHolder.view).addView(this.mView, (ViewGroup.LayoutParams)viewParams);
        }
        this.onPostBindView(this, viewHolder.itemView);
    }

    @Override
    public ViewHolder getViewHolder(View v) {
        return new ViewHolder(v);
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        private View view;

        private ViewHolder(View view) {
            super(view);
            this.view = view;
        }
    }

    public static enum Position {
        TOP,
        BOTTOM,
        NONE;

    }
}

