/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.model;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.LayoutRes;
import androidx.annotation.StringRes;
import androidx.core.view.ViewCompat;
import com.mikepenz.iconics.IconicsDrawable;
import com.mikepenz.iconics.typeface.IIcon;
import com.mikepenz.materialdrawer.Drawer;
import com.mikepenz.materialdrawer.R;
import com.mikepenz.materialdrawer.holder.BadgeStyle;
import com.mikepenz.materialdrawer.holder.ColorHolder;
import com.mikepenz.materialdrawer.holder.StringHolder;
import com.mikepenz.materialdrawer.icons.MaterialDrawerFont;
import com.mikepenz.materialdrawer.model.AbstractDrawerItem;
import com.mikepenz.materialdrawer.model.BaseDescribeableDrawerItem;
import com.mikepenz.materialdrawer.model.BaseViewHolder;
import com.mikepenz.materialdrawer.model.interfaces.ColorfulBadgeable;
import com.mikepenz.materialdrawer.model.interfaces.IDrawerItem;
import java.util.List;

public class ExpandableBadgeDrawerItem
extends BaseDescribeableDrawerItem<ExpandableBadgeDrawerItem, ViewHolder>
implements ColorfulBadgeable<ExpandableBadgeDrawerItem> {
    private Drawer.OnDrawerItemClickListener mOnDrawerItemClickListener;
    protected ColorHolder arrowColor;
    protected int arrowRotationAngleStart = 0;
    protected int arrowRotationAngleEnd = 180;
    protected StringHolder mBadge;
    protected BadgeStyle mBadgeStyle = new BadgeStyle();
    private Drawer.OnDrawerItemClickListener mOnArrowDrawerItemClickListener = new Drawer.OnDrawerItemClickListener(){

        @Override
        public boolean onItemClick(View view, int position, IDrawerItem drawerItem) {
            if (drawerItem instanceof AbstractDrawerItem && drawerItem.isEnabled() && ((AbstractDrawerItem)drawerItem).getSubItems() != null) {
                if (((AbstractDrawerItem)drawerItem).isExpanded()) {
                    ViewCompat.animate((View)view.findViewById(R.id.material_drawer_arrow)).rotation((float)ExpandableBadgeDrawerItem.this.arrowRotationAngleEnd).start();
                } else {
                    ViewCompat.animate((View)view.findViewById(R.id.material_drawer_arrow)).rotation((float)ExpandableBadgeDrawerItem.this.arrowRotationAngleStart).start();
                }
            }
            return ExpandableBadgeDrawerItem.this.mOnDrawerItemClickListener != null && ExpandableBadgeDrawerItem.this.mOnDrawerItemClickListener.onItemClick(view, position, drawerItem);
        }
    };

    @Override
    public int getType() {
        return R.id.material_drawer_item_expandable_badge;
    }

    @Override
    @LayoutRes
    public int getLayoutRes() {
        return R.layout.material_drawer_item_expandable_badge;
    }

    @Override
    public void bindView(ViewHolder viewHolder, List payloads) {
        super.bindView(viewHolder, payloads);
        Context ctx = viewHolder.itemView.getContext();
        this.bindViewHelper(viewHolder);
        boolean badgeVisible = StringHolder.applyToOrHide((com.mikepenz.materialize.holder.StringHolder)this.mBadge, (TextView)viewHolder.badge);
        this.mBadgeStyle.style(viewHolder.badge, this.getTextColorStateList(this.getColor(ctx), this.getSelectedTextColor(ctx)));
        viewHolder.badgeContainer.setVisibility(0);
        if (this.getTypeface() != null) {
            viewHolder.badge.setTypeface(this.getTypeface());
        }
        if (viewHolder.arrow.getDrawable() instanceof IconicsDrawable) {
            ((IconicsDrawable)viewHolder.arrow.getDrawable()).color(this.arrowColor != null ? this.arrowColor.color(ctx) : this.getIconColor(ctx));
        }
        viewHolder.arrow.clearAnimation();
        if (!this.isExpanded()) {
            viewHolder.arrow.setRotation((float)this.arrowRotationAngleStart);
        } else {
            viewHolder.arrow.setRotation((float)this.arrowRotationAngleEnd);
        }
        this.onPostBindView(this, viewHolder.itemView);
    }

    @Override
    public ExpandableBadgeDrawerItem withOnDrawerItemClickListener(Drawer.OnDrawerItemClickListener onDrawerItemClickListener) {
        this.mOnDrawerItemClickListener = onDrawerItemClickListener;
        return this;
    }

    @Override
    public Drawer.OnDrawerItemClickListener getOnDrawerItemClickListener() {
        return this.mOnArrowDrawerItemClickListener;
    }

    @Override
    public ExpandableBadgeDrawerItem withBadge(StringHolder badge) {
        this.mBadge = badge;
        return this;
    }

    @Override
    public ExpandableBadgeDrawerItem withBadge(String badge) {
        this.mBadge = new StringHolder(badge);
        return this;
    }

    @Override
    public ExpandableBadgeDrawerItem withBadge(@StringRes int badgeRes) {
        this.mBadge = new StringHolder(badgeRes);
        return this;
    }

    @Override
    public ExpandableBadgeDrawerItem withBadgeStyle(BadgeStyle badgeStyle) {
        this.mBadgeStyle = badgeStyle;
        return this;
    }

    @Override
    public StringHolder getBadge() {
        return this.mBadge;
    }

    @Override
    public BadgeStyle getBadgeStyle() {
        return this.mBadgeStyle;
    }

    @Override
    public ViewHolder getViewHolder(View v) {
        return new ViewHolder(v);
    }

    public static class ViewHolder
    extends BaseViewHolder {
        public ImageView arrow;
        public View badgeContainer;
        public TextView badge;

        public ViewHolder(View view) {
            super(view);
            this.badgeContainer = view.findViewById(R.id.material_drawer_badge_container);
            this.badge = (TextView)view.findViewById(R.id.material_drawer_badge);
            this.arrow = (ImageView)view.findViewById(R.id.material_drawer_arrow);
            this.arrow.setImageDrawable((Drawable)new IconicsDrawable(view.getContext(), (IIcon)MaterialDrawerFont.Icon.mdf_expand_more).sizeDp(16).paddingDp(2).color(-16777216));
        }
    }
}

