/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.model;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.LayoutRes;
import androidx.core.view.ViewCompat;
import com.mikepenz.iconics.IconicsDrawable;
import com.mikepenz.iconics.typeface.IIcon;
import com.mikepenz.materialdrawer.Drawer;
import com.mikepenz.materialdrawer.R;
import com.mikepenz.materialdrawer.holder.ColorHolder;
import com.mikepenz.materialdrawer.icons.MaterialDrawerFont;
import com.mikepenz.materialdrawer.model.AbstractDrawerItem;
import com.mikepenz.materialdrawer.model.BaseDescribeableDrawerItem;
import com.mikepenz.materialdrawer.model.BaseViewHolder;
import com.mikepenz.materialdrawer.model.interfaces.IDrawerItem;
import java.util.List;

public class ExpandableDrawerItem
extends BaseDescribeableDrawerItem<ExpandableDrawerItem, ViewHolder> {
    private Drawer.OnDrawerItemClickListener mOnDrawerItemClickListener;
    protected ColorHolder arrowColor;
    protected int arrowRotationAngleStart = 0;
    protected int arrowRotationAngleEnd = 180;
    private Drawer.OnDrawerItemClickListener mOnArrowDrawerItemClickListener = new Drawer.OnDrawerItemClickListener(){

        @Override
        public boolean onItemClick(View view, int position, IDrawerItem drawerItem) {
            if (drawerItem instanceof AbstractDrawerItem && drawerItem.isEnabled() && ((AbstractDrawerItem)drawerItem).getSubItems() != null) {
                if (((AbstractDrawerItem)drawerItem).isExpanded()) {
                    ViewCompat.animate((View)view.findViewById(R.id.material_drawer_arrow)).rotation((float)ExpandableDrawerItem.this.arrowRotationAngleEnd).start();
                } else {
                    ViewCompat.animate((View)view.findViewById(R.id.material_drawer_arrow)).rotation((float)ExpandableDrawerItem.this.arrowRotationAngleStart).start();
                }
            }
            return ExpandableDrawerItem.this.mOnDrawerItemClickListener != null && ExpandableDrawerItem.this.mOnDrawerItemClickListener.onItemClick(view, position, drawerItem);
        }
    };

    public ExpandableDrawerItem withArrowColor(@ColorInt int arrowColor) {
        this.arrowColor = ColorHolder.fromColor(arrowColor);
        return this;
    }

    public ExpandableDrawerItem withArrowColorRes(@ColorRes int arrowColorRes) {
        this.arrowColor = ColorHolder.fromColorRes(arrowColorRes);
        return this;
    }

    public ExpandableDrawerItem withArrowRotationAngleStart(int angle) {
        this.arrowRotationAngleStart = angle;
        return this;
    }

    public ExpandableDrawerItem withArrowRotationAngleEnd(int angle) {
        this.arrowRotationAngleEnd = angle;
        return this;
    }

    @Override
    public int getType() {
        return R.id.material_drawer_item_expandable;
    }

    @Override
    @LayoutRes
    public int getLayoutRes() {
        return R.layout.material_drawer_item_expandable;
    }

    @Override
    public ExpandableDrawerItem withOnDrawerItemClickListener(Drawer.OnDrawerItemClickListener onDrawerItemClickListener) {
        this.mOnDrawerItemClickListener = onDrawerItemClickListener;
        return this;
    }

    @Override
    public Drawer.OnDrawerItemClickListener getOnDrawerItemClickListener() {
        return this.mOnArrowDrawerItemClickListener;
    }

    @Override
    public void bindView(ViewHolder viewHolder, List payloads) {
        super.bindView(viewHolder, payloads);
        Context ctx = viewHolder.itemView.getContext();
        this.bindViewHelper(viewHolder);
        if (viewHolder.arrow.getDrawable() instanceof IconicsDrawable) {
            ((IconicsDrawable)viewHolder.arrow.getDrawable()).color(this.arrowColor != null ? this.arrowColor.color(ctx) : this.getIconColor(ctx));
        }
        viewHolder.arrow.clearAnimation();
        if (!this.isExpanded()) {
            viewHolder.arrow.setRotation((float)this.arrowRotationAngleStart);
        } else {
            viewHolder.arrow.setRotation((float)this.arrowRotationAngleEnd);
        }
        this.onPostBindView(this, viewHolder.itemView);
    }

    @Override
    public ViewHolder getViewHolder(View v) {
        return new ViewHolder(v);
    }

    public static class ViewHolder
    extends BaseViewHolder {
        public ImageView arrow;

        public ViewHolder(View view) {
            super(view);
            this.arrow = (ImageView)view.findViewById(R.id.material_drawer_arrow);
            this.arrow.setImageDrawable((Drawable)new IconicsDrawable(view.getContext(), (IIcon)MaterialDrawerFont.Icon.mdf_expand_more).sizeDp(16).paddingDp(2).color(-16777216));
        }
    }
}

