/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.model;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.DimenRes;
import androidx.annotation.LayoutRes;
import androidx.recyclerview.widget.RecyclerView;
import com.mikepenz.materialdrawer.R;
import com.mikepenz.materialdrawer.holder.BadgeStyle;
import com.mikepenz.materialdrawer.holder.DimenHolder;
import com.mikepenz.materialdrawer.holder.ImageHolder;
import com.mikepenz.materialdrawer.holder.StringHolder;
import com.mikepenz.materialdrawer.model.BaseDrawerItem;
import com.mikepenz.materialdrawer.model.PrimaryDrawerItem;
import com.mikepenz.materialdrawer.model.SecondaryDrawerItem;
import com.mikepenz.materialdrawer.util.DrawerUIUtils;
import java.util.List;

public class MiniDrawerItem
extends BaseDrawerItem<MiniDrawerItem, ViewHolder> {
    private StringHolder mBadge;
    private BadgeStyle mBadgeStyle = new BadgeStyle();
    private boolean mEnableSelectedBackground = false;
    protected DimenHolder mCustomHeight;

    public MiniDrawerItem() {
    }

    public MiniDrawerItem(PrimaryDrawerItem primaryDrawerItem) {
        this.mIdentifier = primaryDrawerItem.mIdentifier;
        this.mTag = primaryDrawerItem.mTag;
        this.mBadge = primaryDrawerItem.mBadge;
        this.mBadgeStyle = primaryDrawerItem.mBadgeStyle;
        this.mEnabled = primaryDrawerItem.mEnabled;
        this.mSelectable = primaryDrawerItem.mSelectable;
        this.mSelected = primaryDrawerItem.mSelected;
        this.icon = primaryDrawerItem.icon;
        this.selectedIcon = primaryDrawerItem.selectedIcon;
        this.iconTinted = primaryDrawerItem.iconTinted;
        this.selectedColor = primaryDrawerItem.selectedColor;
        this.iconColor = primaryDrawerItem.iconColor;
        this.selectedIconColor = primaryDrawerItem.selectedIconColor;
        this.disabledIconColor = primaryDrawerItem.disabledIconColor;
    }

    public MiniDrawerItem(SecondaryDrawerItem secondaryDrawerItem) {
        this.mIdentifier = secondaryDrawerItem.mIdentifier;
        this.mTag = secondaryDrawerItem.mTag;
        this.mBadge = secondaryDrawerItem.mBadge;
        this.mBadgeStyle = secondaryDrawerItem.mBadgeStyle;
        this.mEnabled = secondaryDrawerItem.mEnabled;
        this.mSelectable = secondaryDrawerItem.mSelectable;
        this.mSelected = secondaryDrawerItem.mSelected;
        this.icon = secondaryDrawerItem.icon;
        this.selectedIcon = secondaryDrawerItem.selectedIcon;
        this.iconTinted = secondaryDrawerItem.iconTinted;
        this.selectedColor = secondaryDrawerItem.selectedColor;
        this.iconColor = secondaryDrawerItem.iconColor;
        this.selectedIconColor = secondaryDrawerItem.selectedIconColor;
        this.disabledIconColor = secondaryDrawerItem.disabledIconColor;
    }

    public MiniDrawerItem withCustomHeightRes(@DimenRes int customHeightRes) {
        this.mCustomHeight = DimenHolder.fromResource(customHeightRes);
        return this;
    }

    public MiniDrawerItem withCustomHeightDp(int customHeightDp) {
        this.mCustomHeight = DimenHolder.fromDp(customHeightDp);
        return this;
    }

    public MiniDrawerItem withCustomHeightPx(int customHeightPx) {
        this.mCustomHeight = DimenHolder.fromPixel(customHeightPx);
        return this;
    }

    public MiniDrawerItem withCustomHeight(DimenHolder customHeight) {
        this.mCustomHeight = customHeight;
        return this;
    }

    public MiniDrawerItem withEnableSelectedBackground(boolean enableSelectedBackground) {
        this.mEnableSelectedBackground = enableSelectedBackground;
        return this;
    }

    @Override
    public int getType() {
        return R.id.material_drawer_item_mini;
    }

    @Override
    @LayoutRes
    public int getLayoutRes() {
        return R.layout.material_drawer_item_mini;
    }

    @Override
    public void bindView(ViewHolder viewHolder, List payloads) {
        boolean badgeVisible;
        super.bindView(viewHolder, payloads);
        Context ctx = viewHolder.itemView.getContext();
        if (this.mCustomHeight != null) {
            RecyclerView.LayoutParams lp = (RecyclerView.LayoutParams)viewHolder.itemView.getLayoutParams();
            lp.height = this.mCustomHeight.asPixel(ctx);
            viewHolder.itemView.setLayoutParams((ViewGroup.LayoutParams)lp);
        }
        viewHolder.itemView.setId(this.hashCode());
        viewHolder.itemView.setEnabled(this.isEnabled());
        viewHolder.itemView.setSelected(this.isSelected());
        viewHolder.itemView.setTag((Object)this);
        int iconColor = this.getIconColor(ctx);
        int selectedIconColor = this.getSelectedIconColor(ctx);
        if (this.mEnableSelectedBackground) {
            int selectedColor = this.getSelectedColor(ctx);
            DrawerUIUtils.themeDrawerItem(ctx, viewHolder.view, selectedColor, this.isSelectedBackgroundAnimated());
        }
        if (badgeVisible = StringHolder.applyToOrHide((com.mikepenz.materialize.holder.StringHolder)this.mBadge, (TextView)viewHolder.badge)) {
            this.mBadgeStyle.style(viewHolder.badge);
        }
        Drawable icon = ImageHolder.decideIcon(this.getIcon(), ctx, iconColor, this.isIconTinted(), 1);
        Drawable selectedIcon = ImageHolder.decideIcon(this.getSelectedIcon(), ctx, selectedIconColor, this.isIconTinted(), 1);
        ImageHolder.applyMultiIconTo((Drawable)icon, (int)iconColor, (Drawable)selectedIcon, (int)selectedIconColor, (boolean)this.isIconTinted(), (ImageView)viewHolder.icon);
        int verticalPadding = ctx.getResources().getDimensionPixelSize(R.dimen.material_drawer_padding);
        int topBottomPadding = ctx.getResources().getDimensionPixelSize(R.dimen.material_mini_drawer_item_padding);
        viewHolder.itemView.setPadding(verticalPadding, topBottomPadding, verticalPadding, topBottomPadding);
        this.onPostBindView(this, viewHolder.itemView);
    }

    @Override
    public ViewHolder getViewHolder(View v) {
        return new ViewHolder(v);
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        private View view;
        private ImageView icon;
        private TextView badge;

        public ViewHolder(View view) {
            super(view);
            this.view = view;
            this.icon = (ImageView)view.findViewById(R.id.material_drawer_icon);
            this.badge = (TextView)view.findViewById(R.id.material_drawer_badge);
        }
    }
}

