/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.model;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.util.Pair;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.StringRes;
import androidx.recyclerview.widget.RecyclerView;
import com.mikepenz.iconics.typeface.IIcon;
import com.mikepenz.materialdrawer.R;
import com.mikepenz.materialdrawer.holder.ColorHolder;
import com.mikepenz.materialdrawer.holder.StringHolder;
import com.mikepenz.materialdrawer.model.AbstractDrawerItem;
import com.mikepenz.materialdrawer.model.interfaces.IProfile;
import com.mikepenz.materialdrawer.model.interfaces.Tagable;
import com.mikepenz.materialdrawer.model.interfaces.Typefaceable;
import com.mikepenz.materialdrawer.util.DrawerImageLoader;
import com.mikepenz.materialdrawer.util.DrawerUIUtils;
import com.mikepenz.materialize.holder.ImageHolder;
import java.util.List;

public class ProfileDrawerItem
extends AbstractDrawerItem<ProfileDrawerItem, ViewHolder>
implements IProfile<ProfileDrawerItem>,
Tagable<ProfileDrawerItem>,
Typefaceable<ProfileDrawerItem> {
    protected boolean nameShown = false;
    protected com.mikepenz.materialdrawer.holder.ImageHolder icon;
    protected StringHolder name;
    protected StringHolder email;
    protected ColorHolder selectedColor;
    protected ColorHolder textColor;
    protected ColorHolder selectedTextColor;
    protected ColorHolder disabledTextColor;
    protected Typeface typeface = null;
    protected Pair<Integer, ColorStateList> colorStateList;

    @Override
    public ProfileDrawerItem withIcon(Drawable icon) {
        this.icon = new com.mikepenz.materialdrawer.holder.ImageHolder(icon);
        return this;
    }

    @Override
    public ProfileDrawerItem withIcon(@DrawableRes int iconRes) {
        this.icon = new com.mikepenz.materialdrawer.holder.ImageHolder(iconRes);
        return this;
    }

    @Override
    public ProfileDrawerItem withIcon(Bitmap iconBitmap) {
        this.icon = new com.mikepenz.materialdrawer.holder.ImageHolder(iconBitmap);
        return this;
    }

    @Override
    public ProfileDrawerItem withIcon(IIcon icon) {
        this.icon = new com.mikepenz.materialdrawer.holder.ImageHolder(icon);
        return this;
    }

    @Override
    public ProfileDrawerItem withIcon(String url) {
        this.icon = new com.mikepenz.materialdrawer.holder.ImageHolder(url);
        return this;
    }

    @Override
    public ProfileDrawerItem withIcon(Uri uri) {
        this.icon = new com.mikepenz.materialdrawer.holder.ImageHolder(uri);
        return this;
    }

    @Override
    public ProfileDrawerItem withName(CharSequence name) {
        this.name = new StringHolder(name);
        return this;
    }

    public ProfileDrawerItem withName(@StringRes int nameRes) {
        this.name = new StringHolder(nameRes);
        return this;
    }

    @Override
    public ProfileDrawerItem withEmail(String email) {
        this.email = new StringHolder(email);
        return this;
    }

    public ProfileDrawerItem withEmail(@StringRes int emailRes) {
        this.email = new StringHolder(emailRes);
        return this;
    }

    public ProfileDrawerItem withNameShown(boolean nameShown) {
        this.nameShown = nameShown;
        return this;
    }

    public ProfileDrawerItem withSelectedColor(@ColorInt int selectedColor) {
        this.selectedColor = ColorHolder.fromColor(selectedColor);
        return this;
    }

    public ProfileDrawerItem withSelectedColorRes(@ColorRes int selectedColorRes) {
        this.selectedColor = ColorHolder.fromColorRes(selectedColorRes);
        return this;
    }

    public ProfileDrawerItem withTextColor(@ColorInt int textColor) {
        this.textColor = ColorHolder.fromColor(textColor);
        return this;
    }

    public ProfileDrawerItem withTextColorRes(@ColorRes int textColorRes) {
        this.textColor = ColorHolder.fromColorRes(textColorRes);
        return this;
    }

    public ProfileDrawerItem withSelectedTextColor(@ColorInt int selectedTextColor) {
        this.selectedTextColor = ColorHolder.fromColor(selectedTextColor);
        return this;
    }

    public ProfileDrawerItem withSelectedTextColorRes(@ColorRes int selectedColorRes) {
        this.selectedTextColor = ColorHolder.fromColorRes(selectedColorRes);
        return this;
    }

    public ProfileDrawerItem withDisabledTextColor(@ColorInt int disabledTextColor) {
        this.disabledTextColor = ColorHolder.fromColor(disabledTextColor);
        return this;
    }

    public ProfileDrawerItem withDisabledTextColorRes(@ColorRes int disabledTextColorRes) {
        this.disabledTextColor = ColorHolder.fromColorRes(disabledTextColorRes);
        return this;
    }

    @Override
    public ProfileDrawerItem withTypeface(Typeface typeface) {
        this.typeface = typeface;
        return this;
    }

    public boolean isNameShown() {
        return this.nameShown;
    }

    public ColorHolder getSelectedColor() {
        return this.selectedColor;
    }

    public ColorHolder getTextColor() {
        return this.textColor;
    }

    public ColorHolder getSelectedTextColor() {
        return this.selectedTextColor;
    }

    public ColorHolder getDisabledTextColor() {
        return this.disabledTextColor;
    }

    @Override
    public Typeface getTypeface() {
        return this.typeface;
    }

    @Override
    public com.mikepenz.materialdrawer.holder.ImageHolder getIcon() {
        return this.icon;
    }

    @Override
    public StringHolder getName() {
        return this.name;
    }

    @Override
    public StringHolder getEmail() {
        return this.email;
    }

    @Override
    public int getType() {
        return R.id.material_drawer_item_profile;
    }

    @Override
    @LayoutRes
    public int getLayoutRes() {
        return R.layout.material_drawer_item_profile;
    }

    @Override
    public void bindView(ViewHolder viewHolder, List payloads) {
        super.bindView(viewHolder, payloads);
        Context ctx = viewHolder.itemView.getContext();
        viewHolder.itemView.setId(this.hashCode());
        viewHolder.itemView.setEnabled(this.isEnabled());
        viewHolder.itemView.setSelected(this.isSelected());
        int selectedColor = this.getSelectedColor(ctx);
        int color2 = this.getColor(ctx);
        int selectedTextColor = this.getSelectedTextColor(ctx);
        DrawerUIUtils.themeDrawerItem(ctx, viewHolder.view, selectedColor, this.isSelectedBackgroundAnimated());
        if (this.nameShown) {
            viewHolder.name.setVisibility(0);
            StringHolder.applyTo((com.mikepenz.materialize.holder.StringHolder)this.getName(), (TextView)viewHolder.name);
        } else {
            viewHolder.name.setVisibility(8);
        }
        if (!this.nameShown && this.getEmail() == null && this.getName() != null) {
            StringHolder.applyTo((com.mikepenz.materialize.holder.StringHolder)this.getName(), (TextView)viewHolder.email);
        } else {
            StringHolder.applyTo((com.mikepenz.materialize.holder.StringHolder)this.getEmail(), (TextView)viewHolder.email);
        }
        if (this.getTypeface() != null) {
            viewHolder.name.setTypeface(this.getTypeface());
            viewHolder.email.setTypeface(this.getTypeface());
        }
        if (this.nameShown) {
            viewHolder.name.setTextColor(this.getTextColorStateList(color2, selectedTextColor));
        }
        viewHolder.email.setTextColor(this.getTextColorStateList(color2, selectedTextColor));
        DrawerImageLoader.getInstance().cancelImage(viewHolder.profileIcon);
        com.mikepenz.materialdrawer.holder.ImageHolder.applyToOrSetInvisible((ImageHolder)this.getIcon(), (ImageView)viewHolder.profileIcon, (String)DrawerImageLoader.Tags.PROFILE_DRAWER_ITEM.name());
        DrawerUIUtils.setDrawerVerticalPadding(viewHolder.view);
        this.onPostBindView(this, viewHolder.itemView);
    }

    @Override
    public ViewHolder getViewHolder(View v) {
        return new ViewHolder(v);
    }

    protected int getSelectedColor(Context ctx) {
        if (DrawerUIUtils.getBooleanStyleable(ctx, R.styleable.MaterialDrawer_material_drawer_legacy_style, false)) {
            return ColorHolder.color((com.mikepenz.materialize.holder.ColorHolder)this.getSelectedColor(), (Context)ctx, (int)R.attr.material_drawer_selected_legacy, (int)R.color.material_drawer_selected_legacy);
        }
        return ColorHolder.color((com.mikepenz.materialize.holder.ColorHolder)this.getSelectedColor(), (Context)ctx, (int)R.attr.material_drawer_selected, (int)R.color.material_drawer_selected);
    }

    protected int getColor(Context ctx) {
        int color2 = this.isEnabled() ? ColorHolder.color((com.mikepenz.materialize.holder.ColorHolder)this.getTextColor(), (Context)ctx, (int)R.attr.material_drawer_primary_text, (int)R.color.material_drawer_primary_text) : ColorHolder.color((com.mikepenz.materialize.holder.ColorHolder)this.getDisabledTextColor(), (Context)ctx, (int)R.attr.material_drawer_hint_text, (int)R.color.material_drawer_hint_text);
        return color2;
    }

    protected int getSelectedTextColor(Context ctx) {
        return ColorHolder.color((com.mikepenz.materialize.holder.ColorHolder)this.getSelectedTextColor(), (Context)ctx, (int)R.attr.material_drawer_selected_text, (int)R.color.material_drawer_selected_text);
    }

    protected ColorStateList getTextColorStateList(@ColorInt int color2, @ColorInt int selectedTextColor) {
        if (this.colorStateList == null || color2 + selectedTextColor != (Integer)this.colorStateList.first) {
            this.colorStateList = new Pair((Object)(color2 + selectedTextColor), (Object)DrawerUIUtils.getTextColorStateList(color2, selectedTextColor));
        }
        return (ColorStateList)this.colorStateList.second;
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        private View view;
        private ImageView profileIcon;
        private TextView name;
        private TextView email;

        private ViewHolder(View view) {
            super(view);
            this.view = view;
            this.profileIcon = (ImageView)view.findViewById(R.id.material_drawer_profileIcon);
            this.name = (TextView)view.findViewById(R.id.material_drawer_name);
            this.email = (TextView)view.findViewById(R.id.material_drawer_email);
        }
    }
}

