/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.model;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.StringRes;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.mikepenz.iconics.typeface.IIcon;
import com.mikepenz.materialdrawer.R;
import com.mikepenz.materialdrawer.holder.ColorHolder;
import com.mikepenz.materialdrawer.holder.ImageHolder;
import com.mikepenz.materialdrawer.holder.StringHolder;
import com.mikepenz.materialdrawer.model.AbstractDrawerItem;
import com.mikepenz.materialdrawer.model.interfaces.IProfile;
import com.mikepenz.materialdrawer.model.interfaces.Tagable;
import com.mikepenz.materialdrawer.model.interfaces.Typefaceable;
import com.mikepenz.materialdrawer.util.DrawerUIUtils;
import com.mikepenz.materialize.util.UIUtils;
import java.util.List;

public class ProfileSettingDrawerItem
extends AbstractDrawerItem<ProfileSettingDrawerItem, ViewHolder>
implements IProfile<ProfileSettingDrawerItem>,
Tagable<ProfileSettingDrawerItem>,
Typefaceable<ProfileSettingDrawerItem> {
    private ImageHolder icon;
    private StringHolder name;
    private StringHolder description;
    private boolean iconTinted = false;
    private ColorHolder selectedColor;
    private ColorHolder textColor;
    private ColorHolder iconColor;
    private ColorHolder descriptionTextColor;
    private Typeface typeface = null;
    private boolean selectable = false;

    @Override
    public ProfileSettingDrawerItem withIcon(Drawable icon) {
        this.icon = new ImageHolder(icon);
        return this;
    }

    @Override
    public ProfileSettingDrawerItem withIcon(@DrawableRes int iconRes) {
        this.icon = new ImageHolder(iconRes);
        return this;
    }

    @Override
    public ProfileSettingDrawerItem withIcon(Bitmap icon) {
        this.icon = new ImageHolder(icon);
        return this;
    }

    @Override
    public ProfileSettingDrawerItem withIcon(IIcon iicon) {
        this.icon = new ImageHolder(iicon);
        return this;
    }

    @Override
    public ProfileSettingDrawerItem withIcon(String url) {
        this.icon = new ImageHolder(url);
        return this;
    }

    @Override
    public ProfileSettingDrawerItem withIcon(Uri uri) {
        this.icon = new ImageHolder(uri);
        return this;
    }

    @Override
    public ProfileSettingDrawerItem withName(CharSequence name) {
        this.name = new StringHolder(name);
        return this;
    }

    public ProfileSettingDrawerItem withName(@StringRes int nameRes) {
        this.name = new StringHolder(nameRes);
        return this;
    }

    public ProfileSettingDrawerItem withDescription(String description) {
        this.description = new StringHolder(description);
        return this;
    }

    public ProfileSettingDrawerItem withDescription(@StringRes int descriptionRes) {
        this.description = new StringHolder(descriptionRes);
        return this;
    }

    @Override
    public ProfileSettingDrawerItem withEmail(String email) {
        this.description = new StringHolder(email);
        return this;
    }

    public ProfileSettingDrawerItem withSelectedColor(@ColorInt int selectedColor) {
        this.selectedColor = ColorHolder.fromColor(selectedColor);
        return this;
    }

    public ProfileSettingDrawerItem withSelectedColorRes(@ColorRes int selectedColorRes) {
        this.selectedColor = ColorHolder.fromColorRes(selectedColorRes);
        return this;
    }

    public ProfileSettingDrawerItem withTextColor(@ColorInt int textColor) {
        this.textColor = ColorHolder.fromColor(textColor);
        return this;
    }

    public ProfileSettingDrawerItem withTextColorRes(@ColorRes int textColorRes) {
        this.textColor = ColorHolder.fromColorRes(textColorRes);
        return this;
    }

    public ProfileSettingDrawerItem withDescriptionTextColor(@ColorInt int descriptionColor) {
        this.descriptionTextColor = ColorHolder.fromColor(descriptionColor);
        return this;
    }

    public ProfileSettingDrawerItem withDescriptionTextColorRes(@ColorRes int descriptionColorRes) {
        this.descriptionTextColor = ColorHolder.fromColorRes(descriptionColorRes);
        return this;
    }

    public ProfileSettingDrawerItem withIconColor(@ColorInt int iconColor) {
        this.iconColor = ColorHolder.fromColor(iconColor);
        return this;
    }

    public ProfileSettingDrawerItem withIconColorRes(@ColorRes int iconColorRes) {
        this.iconColor = ColorHolder.fromColorRes(iconColorRes);
        return this;
    }

    @Override
    public ProfileSettingDrawerItem withTypeface(Typeface typeface) {
        this.typeface = typeface;
        return this;
    }

    public ProfileSettingDrawerItem withIconTinted(boolean iconTinted) {
        this.iconTinted = iconTinted;
        return this;
    }

    public ColorHolder getSelectedColor() {
        return this.selectedColor;
    }

    public ColorHolder getTextColor() {
        return this.textColor;
    }

    public ColorHolder getDescriptionTextColor() {
        return this.descriptionTextColor;
    }

    public ColorHolder getIconColor() {
        return this.iconColor;
    }

    @Override
    public ImageHolder getIcon() {
        return this.icon;
    }

    public boolean isIconTinted() {
        return this.iconTinted;
    }

    public void setIconTinted(boolean iconTinted) {
        this.iconTinted = iconTinted;
    }

    @Override
    public Typeface getTypeface() {
        return this.typeface;
    }

    @Override
    public StringHolder getName() {
        return this.name;
    }

    @Override
    public StringHolder getEmail() {
        return this.description;
    }

    public StringHolder getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = new StringHolder(description);
    }

    @Override
    public boolean isSelectable() {
        return this.selectable;
    }

    @Override
    public ProfileSettingDrawerItem withSelectable(boolean selectable) {
        this.selectable = selectable;
        return this;
    }

    @Override
    public int getType() {
        return R.id.material_drawer_item_profile_setting;
    }

    @Override
    @LayoutRes
    public int getLayoutRes() {
        return R.layout.material_drawer_item_profile_setting;
    }

    @Override
    public void bindView(ViewHolder viewHolder, List payloads) {
        super.bindView(viewHolder, payloads);
        Context ctx = viewHolder.itemView.getContext();
        viewHolder.itemView.setId(this.hashCode());
        viewHolder.itemView.setEnabled(this.isEnabled());
        viewHolder.itemView.setSelected(this.isSelected());
        int selectedColor = this.getSelectedColor(ctx);
        int color2 = ColorHolder.color((com.mikepenz.materialize.holder.ColorHolder)this.getTextColor(), (Context)ctx, (int)R.attr.material_drawer_primary_text, (int)R.color.material_drawer_primary_text);
        int iconColor = ColorHolder.color((com.mikepenz.materialize.holder.ColorHolder)this.getIconColor(), (Context)ctx, (int)R.attr.material_drawer_primary_icon, (int)R.color.material_drawer_primary_icon);
        int descriptionColor = ColorHolder.color((com.mikepenz.materialize.holder.ColorHolder)this.getDescriptionTextColor(), (Context)ctx, (int)R.attr.material_drawer_primary_text, (int)R.color.material_drawer_primary_text);
        ViewCompat.setBackground((View)viewHolder.view, (Drawable)UIUtils.getSelectableBackground((Context)ctx, (int)selectedColor, (boolean)this.isSelectedBackgroundAnimated()));
        StringHolder.applyTo((com.mikepenz.materialize.holder.StringHolder)this.getName(), (TextView)viewHolder.name);
        viewHolder.name.setTextColor(color2);
        StringHolder.applyToOrHide((com.mikepenz.materialize.holder.StringHolder)this.getDescription(), (TextView)viewHolder.description);
        viewHolder.description.setTextColor(descriptionColor);
        if (this.getTypeface() != null) {
            viewHolder.name.setTypeface(this.getTypeface());
            viewHolder.description.setTypeface(this.getTypeface());
        }
        ImageHolder.applyDecidedIconOrSetGone(this.icon, viewHolder.icon, iconColor, this.isIconTinted(), 2);
        DrawerUIUtils.setDrawerVerticalPadding(viewHolder.view);
        this.onPostBindView(this, viewHolder.itemView);
    }

    protected int getSelectedColor(Context ctx) {
        if (DrawerUIUtils.getBooleanStyleable(ctx, R.styleable.MaterialDrawer_material_drawer_legacy_style, false)) {
            return ColorHolder.color((com.mikepenz.materialize.holder.ColorHolder)this.getSelectedColor(), (Context)ctx, (int)R.attr.material_drawer_selected_legacy, (int)R.color.material_drawer_selected_legacy);
        }
        return ColorHolder.color((com.mikepenz.materialize.holder.ColorHolder)this.getSelectedColor(), (Context)ctx, (int)R.attr.material_drawer_selected, (int)R.color.material_drawer_selected);
    }

    @Override
    public ViewHolder getViewHolder(View v) {
        return new ViewHolder(v);
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        private View view;
        private ImageView icon;
        private TextView name;
        private TextView description;

        private ViewHolder(View view) {
            super(view);
            this.view = view;
            this.icon = (ImageView)view.findViewById(R.id.material_drawer_icon);
            this.name = (TextView)view.findViewById(R.id.material_drawer_name);
            this.description = (TextView)view.findViewById(R.id.material_drawer_description);
        }
    }
}

