/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.model.utils;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.util.StateSet;
import androidx.appcompat.content.res.AppCompatResources;
import com.mikepenz.materialdrawer.holder.BadgeStyle;
import com.mikepenz.materialdrawer.holder.ColorHolder;

public class BadgeDrawableBuilder {
    private BadgeStyle mStyle;

    public BadgeDrawableBuilder(BadgeStyle style2) {
        this.mStyle = style2;
    }

    public StateListDrawable build(Context ctx) {
        StateListDrawable stateListDrawable = new StateListDrawable();
        GradientDrawable normal = (GradientDrawable)AppCompatResources.getDrawable((Context)ctx, (int)this.mStyle.getGradientDrawable());
        GradientDrawable selected = (GradientDrawable)normal.getConstantState().newDrawable().mutate();
        ColorHolder.applyToOrTransparent((com.mikepenz.materialize.holder.ColorHolder)this.mStyle.getColor(), (Context)ctx, (GradientDrawable)normal);
        if (this.mStyle.getColorPressed() == null) {
            ColorHolder.applyToOrTransparent((com.mikepenz.materialize.holder.ColorHolder)this.mStyle.getColor(), (Context)ctx, (GradientDrawable)selected);
        } else {
            ColorHolder.applyToOrTransparent((com.mikepenz.materialize.holder.ColorHolder)this.mStyle.getColorPressed(), (Context)ctx, (GradientDrawable)selected);
        }
        if (this.mStyle.getCorners() != null) {
            normal.setCornerRadius((float)this.mStyle.getCorners().asPixel(ctx));
            selected.setCornerRadius((float)this.mStyle.getCorners().asPixel(ctx));
        }
        stateListDrawable.addState(new int[]{16842919}, (Drawable)selected);
        stateListDrawable.addState(StateSet.WILD_CARD, (Drawable)normal);
        return stateListDrawable;
    }
}

