/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.WindowManager;
import androidx.annotation.StyleableRes;
import androidx.core.view.ViewCompat;
import com.mikepenz.iconics.IconicsDrawable;
import com.mikepenz.iconics.typeface.IIcon;
import com.mikepenz.materialdrawer.R;
import com.mikepenz.materialdrawer.icons.MaterialDrawerFont;
import com.mikepenz.materialize.util.UIUtils;

@SuppressLint(value={"InlinedApi"})
public class DrawerUIUtils {
    public static boolean getBooleanStyleable(Context ctx, @StyleableRes int styleable2, boolean def) {
        TypedArray ta = ctx.getTheme().obtainStyledAttributes(R.styleable.MaterialDrawer);
        return ta.getBoolean(styleable2, def);
    }

    public static void themeDrawerItem(Context ctx, View view, int selected_color, boolean animate) {
        Drawable unselected;
        ColorDrawable selected;
        boolean legacyStyle = DrawerUIUtils.getBooleanStyleable(ctx, R.styleable.MaterialDrawer_material_drawer_legacy_style, false);
        if (legacyStyle) {
            selected = new ColorDrawable(selected_color);
            unselected = UIUtils.getSelectableBackground((Context)ctx);
        } else {
            int cornerRadius = ctx.getResources().getDimensionPixelSize(R.dimen.material_drawer_item_corner_radius);
            int paddingTopBottom = ctx.getResources().getDimensionPixelSize(R.dimen.material_drawer_item_background_padding_top_bottom);
            int paddingStartEnd = ctx.getResources().getDimensionPixelSize(R.dimen.material_drawer_item_background_padding_start_end);
            GradientDrawable gradientDrawable = new GradientDrawable();
            gradientDrawable.setColor(selected_color);
            gradientDrawable.setCornerRadius((float)cornerRadius);
            selected = new InsetDrawable((Drawable)gradientDrawable, paddingStartEnd, paddingTopBottom, paddingStartEnd, paddingTopBottom);
            if (Build.VERSION.SDK_INT >= 21) {
                GradientDrawable gradientMask = new GradientDrawable();
                gradientMask.setColor(-16777216);
                gradientMask.setCornerRadius((float)cornerRadius);
                InsetDrawable mask = new InsetDrawable((Drawable)gradientMask, paddingStartEnd, paddingTopBottom, paddingStartEnd, paddingTopBottom);
                unselected = new RippleDrawable(new ColorStateList((int[][])new int[][]{new int[0]}, new int[]{UIUtils.getThemeColor((Context)ctx, (int)R.attr.colorControlHighlight)}), null, (Drawable)mask);
            } else {
                GradientDrawable touchDrawable = new GradientDrawable();
                touchDrawable.setColor(UIUtils.getThemeColor((Context)ctx, (int)R.attr.colorControlHighlight));
                touchDrawable.setCornerRadius((float)cornerRadius);
                InsetDrawable touchInsetDrawable = new InsetDrawable((Drawable)touchDrawable, paddingStartEnd, paddingTopBottom, paddingStartEnd, paddingTopBottom);
                StateListDrawable unselectedStates = new StateListDrawable();
                if (animate) {
                    int duration = ctx.getResources().getInteger(0x10E0000);
                    unselectedStates.setEnterFadeDuration(duration);
                    unselectedStates.setExitFadeDuration(duration);
                }
                unselectedStates.addState(new int[]{16842919}, (Drawable)touchInsetDrawable);
                unselectedStates.addState(new int[0], (Drawable)new ColorDrawable(0));
                unselected = unselectedStates;
            }
        }
        StateListDrawable states = new StateListDrawable();
        if (animate) {
            int duration = ctx.getResources().getInteger(0x10E0000);
            states.setEnterFadeDuration(duration);
            states.setExitFadeDuration(duration);
        }
        if (Build.VERSION.SDK_INT >= 23) {
            states.addState(new int[]{0x10100A1}, (Drawable)selected);
            states.addState(new int[0], (Drawable)new ColorDrawable(0));
            ViewCompat.setBackground((View)view, (Drawable)states);
            view.setForeground(unselected);
        } else {
            states.addState(new int[]{0x10100A1}, (Drawable)selected);
            states.addState(new int[0], unselected);
            ViewCompat.setBackground((View)view, (Drawable)states);
        }
    }

    public static ColorStateList getTextColorStateList(int text_color, int selected_text_color) {
        return new ColorStateList((int[][])new int[][]{{0x10100A1}, new int[0]}, new int[]{selected_text_color, text_color});
    }

    public static StateListDrawable getIconStateList(Drawable icon, Drawable selectedIcon) {
        StateListDrawable iconStateListDrawable = new StateListDrawable();
        iconStateListDrawable.addState(new int[]{0x10100A1}, selectedIcon);
        iconStateListDrawable.addState(new int[0], icon);
        return iconStateListDrawable;
    }

    public static StateListDrawable getDrawerItemBackground(int selected_color) {
        ColorDrawable clrActive = new ColorDrawable(selected_color);
        StateListDrawable states = new StateListDrawable();
        states.addState(new int[]{0x10100A1}, (Drawable)clrActive);
        return states;
    }

    public static int getOptimalDrawerWidth(Context context) {
        int possibleMinDrawerWidth = UIUtils.getScreenWidth((Context)context) - UIUtils.getActionBarHeight((Context)context);
        int maxDrawerWidth = context.getResources().getDimensionPixelSize(R.dimen.material_drawer_width);
        return Math.min(possibleMinDrawerWidth, maxDrawerWidth);
    }

    public static Drawable getPlaceHolder(Context ctx) {
        return new IconicsDrawable(ctx, (IIcon)MaterialDrawerFont.Icon.mdf_person).colorRes(R.color.accent).backgroundColorRes(R.color.primary).sizeDp(56).paddingDp(16);
    }

    public static void setDrawerVerticalPadding(View v) {
        int verticalPadding = v.getContext().getResources().getDimensionPixelSize(R.dimen.material_drawer_vertical_padding);
        v.setPadding(verticalPadding, 0, verticalPadding, 0);
    }

    public static void setDrawerVerticalPadding(View v, int level) {
        int verticalPadding = v.getContext().getResources().getDimensionPixelSize(R.dimen.material_drawer_vertical_padding);
        if (Build.VERSION.SDK_INT >= 17) {
            v.setPaddingRelative(verticalPadding * level, 0, verticalPadding, 0);
        } else {
            v.setPadding(verticalPadding * level, 0, verticalPadding, 0);
        }
    }

    public static boolean isSystemBarOnBottom(Context ctx) {
        WindowManager wm = (WindowManager)ctx.getSystemService("window");
        DisplayMetrics metrics = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(metrics);
        Configuration cfg = ctx.getResources().getConfiguration();
        boolean canMove = metrics.widthPixels != metrics.heightPixels && cfg.smallestScreenWidthDp < 600;
        return !canMove || metrics.widthPixels < metrics.heightPixels;
    }
}

