/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.util;

import android.annotation.SuppressLint;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;

@SuppressLint(value={"InlinedApi"})
public class PressedEffectStateListDrawable
extends StateListDrawable {
    private int color;
    private int selectionColor;

    public PressedEffectStateListDrawable(Drawable drawable2, int color2, int selectionColor) {
        drawable2 = drawable2.mutate();
        this.addState(new int[]{0x10100A1}, drawable2);
        this.addState(new int[0], drawable2);
        this.color = color2;
        this.selectionColor = selectionColor;
    }

    protected boolean onStateChange(int[] states) {
        boolean isStatePressedInArray = false;
        for (int state : states) {
            if (state != 0x10100A1) continue;
            isStatePressedInArray = true;
        }
        if (isStatePressedInArray) {
            super.setColorFilter(this.selectionColor, PorterDuff.Mode.SRC_IN);
        } else {
            super.setColorFilter(this.color, PorterDuff.Mode.SRC_IN);
        }
        return super.onStateChange(states);
    }

    public boolean isStateful() {
        return true;
    }
}

