/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import androidx.drawerlayout.widget.DrawerLayout;
import androidx.recyclerview.widget.RecyclerView;
import com.mikepenz.materialdrawer.AccountHeader;
import com.mikepenz.materialdrawer.Drawer;
import com.mikepenz.materialdrawer.DrawerBuilder;
import com.mikepenz.materialdrawer.R;
import com.mikepenz.materialdrawer.model.AbstractDrawerItem;
import com.mikepenz.materialdrawer.model.ContainerDrawerItem;
import com.mikepenz.materialdrawer.model.interfaces.IDrawerItem;
import com.mikepenz.materialdrawer.model.interfaces.Selectable;
import com.mikepenz.materialdrawer.util.DrawerUIUtils;
import com.mikepenz.materialize.util.UIUtils;
import com.mikepenz.materialize.view.ScrimInsetsRelativeLayout;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rJ(\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00112\u0010\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001J&\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00112\u0010\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u00132\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0019\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u001a\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u001b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ1\u0010\u001c\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!\u00a2\u0006\u0002\u0010\"J\u001c\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010%\u001a\u0004\u0018\u00010$H\u0007J\u000e\u0010&\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ%\u0010'\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u00182\b\u0010 \u001a\u0004\u0018\u00010!\u00a2\u0006\u0002\u0010)\u00a8\u0006*"}, d2={"Lcom/mikepenz/materialdrawer/DrawerUtils;", "", "()V", "addStickyFooterDivider", "", "ctx", "Landroid/content/Context;", "footerView", "Landroid/view/ViewGroup;", "buildStickyDrawerItemFooter", "drawer", "Lcom/mikepenz/materialdrawer/DrawerBuilder;", "onClickListener", "Landroid/view/View$OnClickListener;", "fillStickyDrawerItemFooter", "container", "getDrawerItem", "Lcom/mikepenz/materialdrawer/model/interfaces/IDrawerItem;", "drawerItems", "", "tag", "identifier", "", "getPositionByIdentifier", "", "getStickyFooterPositionByIdentifier", "handleFooterView", "handleHeaderView", "onFooterDrawerItemClick", "drawerItem", "v", "Landroid/view/View;", "fireOnClick", "", "(Lcom/mikepenz/materialdrawer/DrawerBuilder;Lcom/mikepenz/materialdrawer/model/interfaces/IDrawerItem;Landroid/view/View;Ljava/lang/Boolean;)V", "processDrawerLayoutParams", "Landroidx/drawerlayout/widget/DrawerLayout$LayoutParams;", "params", "rebuildStickyFooterView", "setStickyFooterSelection", "_position", "(Lcom/mikepenz/materialdrawer/DrawerBuilder;ILjava/lang/Boolean;)V", "library_release"})
public final class DrawerUtils {
    public static final DrawerUtils INSTANCE;

    /*
     * WARNING - void declaration
     */
    public final void onFooterDrawerItemClick(@NotNull DrawerBuilder drawer, @NotNull IDrawerItem<?> drawerItem, @NotNull View v, @Nullable Boolean fireOnClick) {
        boolean checkable;
        Intrinsics.checkParameterIsNotNull((Object)drawer, (String)"drawer");
        Intrinsics.checkParameterIsNotNull(drawerItem, (String)"drawerItem");
        Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
        boolean bl = checkable = !(drawerItem instanceof Selectable) || drawerItem.isSelectable();
        if (checkable) {
            drawer.resetStickyFooterSelection$library_release();
            v.setActivated(true);
            v.setSelected(true);
            drawer.getSelectExtension$library_release().deselect();
            if (drawer.getMStickyFooterView$library_release() != null && drawer.getMStickyFooterView$library_release() instanceof LinearLayout) {
                ViewGroup viewGroup = drawer.getMStickyFooterView$library_release();
                if (viewGroup == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.widget.LinearLayout");
                }
                LinearLayout footer = (LinearLayout)viewGroup;
                int n = 0;
                int n2 = footer.getChildCount();
                while (n < n2) {
                    void i;
                    if (footer.getChildAt((int)i) == v) {
                        drawer.setMCurrentStickyFooterSelection$library_release((int)i);
                        break;
                    }
                    ++i;
                }
            }
        }
        if (fireOnClick != null) {
            boolean consumed = false;
            if (fireOnClick.booleanValue()) {
                if (drawerItem instanceof AbstractDrawerItem && ((AbstractDrawerItem)drawerItem).getOnDrawerItemClickListener() != null) {
                    Drawer.OnDrawerItemClickListener onDrawerItemClickListener2 = ((AbstractDrawerItem)drawerItem).getOnDrawerItemClickListener();
                    boolean bl2 = consumed = onDrawerItemClickListener2 != null ? onDrawerItemClickListener2.onItemClick(v, -1, drawerItem) : false;
                }
                if (drawer.getMOnDrawerItemClickListener$library_release() != null) {
                    Drawer.OnDrawerItemClickListener onDrawerItemClickListener3 = drawer.getMOnDrawerItemClickListener$library_release();
                    boolean bl3 = consumed = onDrawerItemClickListener3 != null ? onDrawerItemClickListener3.onItemClick(v, -1, drawerItem) : false;
                }
            }
            if (!consumed) {
                drawer.closeDrawerDelayed$library_release();
            }
        }
    }

    public final void setStickyFooterSelection(@NotNull DrawerBuilder drawer, int _position, @Nullable Boolean fireOnClick) {
        Intrinsics.checkParameterIsNotNull((Object)drawer, (String)"drawer");
        int position = _position;
        if (position > -1 && drawer.getMStickyFooterView$library_release() != null && drawer.getMStickyFooterView$library_release() instanceof LinearLayout) {
            ViewGroup viewGroup = drawer.getMStickyFooterView$library_release();
            if (viewGroup == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.widget.LinearLayout");
            }
            LinearLayout footer = (LinearLayout)viewGroup;
            if (drawer.getMStickyFooterDivider$library_release()) {
                ++position;
            }
            if (footer.getChildCount() > position && position >= 0) {
                Object object = footer.getChildAt(position).getTag(R.id.material_drawer_item);
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.mikepenz.materialdrawer.model.interfaces.IDrawerItem<*>");
                }
                IDrawerItem drawerItem = (IDrawerItem)object;
                View view = footer.getChildAt(position);
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"footer.getChildAt(position)");
                this.onFooterDrawerItemClick(drawer, drawerItem, view, fireOnClick);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int getPositionByIdentifier(@NotNull DrawerBuilder drawer, long identifier) {
        Intrinsics.checkParameterIsNotNull((Object)drawer, (String)"drawer");
        if (identifier != -1L) {
            int n = 0;
            int n2 = drawer.getAdapter$library_release().getItemCount();
            while (n < n2) {
                void i;
                IDrawerItem iDrawerItem = (IDrawerItem)drawer.getAdapter$library_release().getItem((int)i);
                if (iDrawerItem != null) {
                    if (iDrawerItem.getIdentifier() == identifier) {
                        return (int)i;
                    }
                }
                ++i;
            }
        }
        return -1;
    }

    @Nullable
    public final IDrawerItem<?> getDrawerItem(@NotNull List<? extends IDrawerItem<?>> drawerItems, long identifier) {
        Intrinsics.checkParameterIsNotNull(drawerItems, (String)"drawerItems");
        if (identifier != -1L) {
            for (IDrawerItem<?> drawerItem : drawerItems) {
                if (drawerItem.getIdentifier() != identifier) continue;
                return drawerItem;
            }
        }
        return null;
    }

    @Nullable
    public final IDrawerItem<?> getDrawerItem(@NotNull List<? extends IDrawerItem<?>> drawerItems, @Nullable Object tag) {
        Intrinsics.checkParameterIsNotNull(drawerItems, (String)"drawerItems");
        if (tag != null) {
            for (IDrawerItem<?> drawerItem : drawerItems) {
                if (!Intrinsics.areEqual((Object)tag, (Object)drawerItem.getTag())) continue;
                return drawerItem;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final int getStickyFooterPositionByIdentifier(@NotNull DrawerBuilder drawer, long identifier) {
        Intrinsics.checkParameterIsNotNull((Object)drawer, (String)"drawer");
        if (identifier != -1L && drawer.getMStickyFooterView$library_release() != null && drawer.getMStickyFooterView$library_release() instanceof LinearLayout) {
            ViewGroup viewGroup = drawer.getMStickyFooterView$library_release();
            if (viewGroup == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.widget.LinearLayout");
            }
            LinearLayout footer = (LinearLayout)viewGroup;
            int shadowOffset = 0;
            int n = 0;
            int n2 = footer.getChildCount();
            while (n < n2) {
                void i;
                Object o = footer.getChildAt((int)i).getTag(R.id.material_drawer_item);
                if (o == null && drawer.getMStickyFooterDivider$library_release()) {
                    ++shadowOffset;
                }
                if (o != null && o instanceof IDrawerItem && ((IDrawerItem)o).getIdentifier() == identifier) {
                    return (int)(i - shadowOffset);
                }
                ++i;
            }
        }
        return -1;
    }

    public final void handleHeaderView(@NotNull DrawerBuilder drawer) {
        block11: {
            AccountHeader it;
            boolean bl;
            boolean bl2;
            AccountHeader accountHeader;
            Intrinsics.checkParameterIsNotNull((Object)drawer, (String)"drawer");
            AccountHeader accountHeader2 = drawer.getMAccountHeader$library_release();
            if (accountHeader2 != null) {
                accountHeader = accountHeader2;
                bl2 = false;
                bl = false;
                it = accountHeader;
                boolean bl3 = false;
                if (drawer.getMAccountHeaderSticky$library_release()) {
                    drawer.setMStickyHeaderView$library_release(it.getView());
                } else {
                    drawer.setMHeaderView$library_release(it.getView());
                    drawer.setMHeaderDivider$library_release(it.getAccountHeaderBuilder().getDividerBelowHeader());
                    drawer.setMHeaderPadding$library_release(it.getAccountHeaderBuilder().getPaddingBelowHeader());
                }
            }
            View view = drawer.getMStickyHeaderView$library_release();
            if (view != null) {
                accountHeader = view;
                bl2 = false;
                bl = false;
                it = accountHeader;
                boolean bl4 = false;
                RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -2);
                layoutParams.addRule(10, 1);
                it.setId(R.id.material_drawer_sticky_header);
                drawer.getMSliderLayout$library_release().addView((View)it, 0, (ViewGroup.LayoutParams)layoutParams);
                ViewGroup.LayoutParams layoutParams2 = drawer.getMRecyclerView$library_release().getLayoutParams();
                if (layoutParams2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.widget.RelativeLayout.LayoutParams");
                }
                RelativeLayout.LayoutParams layoutParamsListView = (RelativeLayout.LayoutParams)layoutParams2;
                layoutParamsListView.addRule(3, R.id.material_drawer_sticky_header);
                drawer.getMRecyclerView$library_release().setLayoutParams((ViewGroup.LayoutParams)layoutParamsListView);
                it.setBackgroundColor(UIUtils.getThemeColorFromAttrOrRes((Context)((Context)drawer.getMActivity$library_release()), (int)R.attr.material_drawer_background, (int)R.color.material_drawer_background));
                if (drawer.getMStickyHeaderShadow$library_release()) {
                    if (Build.VERSION.SDK_INT >= 21) {
                        it.setElevation(UIUtils.convertDpToPixel((float)4.0f, (Context)((Context)drawer.getMActivity$library_release())));
                    } else {
                        View view2 = new View((Context)drawer.getMActivity$library_release());
                        view2.setBackgroundResource(R.drawable.material_drawer_shadow_bottom);
                        drawer.getMSliderLayout$library_release().addView(view2, -1, (int)UIUtils.convertDpToPixel((float)4.0f, (Context)((Context)drawer.getMActivity$library_release())));
                        ViewGroup.LayoutParams layoutParams3 = view2.getLayoutParams();
                        if (layoutParams3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type android.widget.RelativeLayout.LayoutParams");
                        }
                        RelativeLayout.LayoutParams lps = (RelativeLayout.LayoutParams)layoutParams3;
                        lps.addRule(3, R.id.material_drawer_sticky_header);
                        view2.setLayoutParams((ViewGroup.LayoutParams)lps);
                    }
                }
                drawer.getMRecyclerView$library_release().setPadding(0, 0, 0, 0);
            }
            View view3 = drawer.getMHeaderView$library_release();
            if (view3 == null) break block11;
            accountHeader = view3;
            bl2 = false;
            bl = false;
            it = accountHeader;
            boolean bl5 = false;
            if (drawer.getMHeaderPadding$library_release()) {
                drawer.getHeaderAdapter$library_release().add((Object[])new IDrawerItem[]{new ContainerDrawerItem().withView((View)it).withHeight(drawer.getMHeiderHeight$library_release()).withDivider(drawer.getMHeaderDivider$library_release()).withViewPosition(ContainerDrawerItem.Position.TOP)});
            } else {
                drawer.getHeaderAdapter$library_release().add((Object[])new IDrawerItem[]{new ContainerDrawerItem().withView((View)it).withHeight(drawer.getMHeiderHeight$library_release()).withDivider(drawer.getMHeaderDivider$library_release()).withViewPosition(ContainerDrawerItem.Position.NONE)});
            }
            drawer.getMRecyclerView$library_release().setPadding(drawer.getMRecyclerView$library_release().getPaddingLeft(), 0, drawer.getMRecyclerView$library_release().getPaddingRight(), drawer.getMRecyclerView$library_release().getPaddingBottom());
        }
    }

    public final void rebuildStickyFooterView(@NotNull DrawerBuilder drawer) {
        Intrinsics.checkParameterIsNotNull((Object)drawer, (String)"drawer");
        ViewGroup viewGroup = drawer.getMStickyFooterView$library_release();
        if (viewGroup != null) {
            ViewGroup viewGroup2 = viewGroup;
            boolean bl = false;
            boolean bl2 = false;
            ViewGroup it = viewGroup2;
            boolean bl3 = false;
            it.removeAllViews();
            if (drawer.getMStickyFooterDivider$library_release()) {
                Context context = it.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"it.context");
                INSTANCE.addStickyFooterDivider(context, it);
            }
            INSTANCE.fillStickyDrawerItemFooter(drawer, it, new View.OnClickListener(drawer){
                final /* synthetic */ DrawerBuilder $drawer$inlined;
                {
                    this.$drawer$inlined = drawerBuilder;
                }

                public final void onClick(View v) {
                    Object object = v.getTag(R.id.material_drawer_item);
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.mikepenz.materialdrawer.model.interfaces.IDrawerItem<*>");
                    }
                    IDrawerItem drawerItem = (IDrawerItem)object;
                    View view = v;
                    Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"v");
                    DrawerUtils.INSTANCE.onFooterDrawerItemClick(this.$drawer$inlined, drawerItem, view, true);
                }
            });
            it.setVisibility(0);
        } else {
            DrawerUtils drawerUtils = this;
            boolean bl = false;
            boolean bl4 = false;
            DrawerUtils $this$run = drawerUtils;
            boolean bl5 = false;
            INSTANCE.handleFooterView(drawer, new View.OnClickListener(drawer){
                final /* synthetic */ DrawerBuilder $drawer$inlined;
                {
                    this.$drawer$inlined = drawerBuilder;
                }

                public final void onClick(View v) {
                    Object object = v.getTag(R.id.material_drawer_item);
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.mikepenz.materialdrawer.model.interfaces.IDrawerItem<*>");
                    }
                    IDrawerItem drawerItem = (IDrawerItem)object;
                    View view = v;
                    Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"v");
                    DrawerUtils.INSTANCE.onFooterDrawerItemClick(this.$drawer$inlined, drawerItem, view, true);
                }
            });
        }
        this.setStickyFooterSelection(drawer, drawer.getMCurrentStickyFooterSelection$library_release(), false);
    }

    public final void handleFooterView(@NotNull DrawerBuilder drawer, @NotNull View.OnClickListener onClickListener) {
        block8: {
            ViewGroup it;
            boolean bl;
            boolean bl2;
            ViewGroup viewGroup;
            Intrinsics.checkParameterIsNotNull((Object)drawer, (String)"drawer");
            Intrinsics.checkParameterIsNotNull((Object)onClickListener, (String)"onClickListener");
            Context ctx = drawer.getMSliderLayout$library_release().getContext();
            if (drawer.getMStickyDrawerItems$library_release().size() > 0) {
                Context context = ctx;
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"ctx");
                drawer.setMStickyFooterView$library_release(INSTANCE.buildStickyDrawerItemFooter(context, drawer, onClickListener));
            }
            ViewGroup viewGroup2 = drawer.getMStickyFooterView$library_release();
            if (viewGroup2 != null) {
                viewGroup = viewGroup2;
                bl2 = false;
                bl = false;
                it = viewGroup;
                boolean bl3 = false;
                RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -2);
                layoutParams.addRule(12, 1);
                it.setId(R.id.material_drawer_sticky_footer);
                drawer.getMSliderLayout$library_release().addView((View)it, (ViewGroup.LayoutParams)layoutParams);
                if ((drawer.getMTranslucentNavigationBar$library_release() || drawer.getMFullscreen$library_release()) && Build.VERSION.SDK_INT >= 19) {
                    it.setPadding(0, 0, 0, UIUtils.getNavigationBarHeight((Context)ctx));
                }
                ViewGroup.LayoutParams layoutParams2 = drawer.getMRecyclerView$library_release().getLayoutParams();
                if (layoutParams2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.widget.RelativeLayout.LayoutParams");
                }
                RelativeLayout.LayoutParams layoutParamsListView = (RelativeLayout.LayoutParams)layoutParams2;
                layoutParamsListView.addRule(2, R.id.material_drawer_sticky_footer);
                drawer.getMRecyclerView$library_release().setLayoutParams((ViewGroup.LayoutParams)layoutParamsListView);
                if (drawer.getMStickyFooterShadow$library_release()) {
                    View view = new View(ctx);
                    DrawerBuilder drawerBuilder = drawer;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    View stickyFooterShadowView = view;
                    boolean bl6 = false;
                    stickyFooterShadowView.setBackgroundResource(R.drawable.material_drawer_shadow_top);
                    ScrimInsetsRelativeLayout scrimInsetsRelativeLayout = drawer.getMSliderLayout$library_release();
                    Context context = ctx;
                    Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"ctx");
                    scrimInsetsRelativeLayout.addView(stickyFooterShadowView, -1, context.getResources().getDimensionPixelSize(R.dimen.material_drawer_sticky_footer_elevation));
                    ViewGroup.LayoutParams layoutParams3 = stickyFooterShadowView.getLayoutParams();
                    if (layoutParams3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type android.widget.RelativeLayout.LayoutParams");
                    }
                    RelativeLayout.LayoutParams lps = (RelativeLayout.LayoutParams)layoutParams3;
                    lps.addRule(2, R.id.material_drawer_sticky_footer);
                    stickyFooterShadowView.setLayoutParams((ViewGroup.LayoutParams)lps);
                    View view2 = view;
                    drawerBuilder.setMStickyFooterShadowView$library_release(view2);
                }
                RecyclerView recyclerView = drawer.getMRecyclerView$library_release();
                int n = drawer.getMRecyclerView$library_release().getPaddingLeft();
                int n2 = drawer.getMRecyclerView$library_release().getPaddingTop();
                int n3 = drawer.getMRecyclerView$library_release().getPaddingRight();
                Context context = ctx;
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"ctx");
                recyclerView.setPadding(n, n2, n3, context.getResources().getDimensionPixelSize(R.dimen.material_drawer_padding));
            }
            View view = drawer.getMFooterView$library_release();
            if (view == null) break block8;
            viewGroup = view;
            bl2 = false;
            bl = false;
            it = viewGroup;
            boolean bl7 = false;
            if (drawer.getMFooterDivider$library_release()) {
                drawer.getFooterAdapter$library_release().add((Object[])new IDrawerItem[]{new ContainerDrawerItem().withView((View)it).withViewPosition(ContainerDrawerItem.Position.BOTTOM)});
            } else {
                drawer.getFooterAdapter$library_release().add((Object[])new IDrawerItem[]{new ContainerDrawerItem().withView((View)it).withViewPosition(ContainerDrawerItem.Position.NONE)});
            }
        }
    }

    @NotNull
    public final ViewGroup buildStickyDrawerItemFooter(@NotNull Context ctx, @NotNull DrawerBuilder drawer, @NotNull View.OnClickListener onClickListener) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Intrinsics.checkParameterIsNotNull((Object)drawer, (String)"drawer");
        Intrinsics.checkParameterIsNotNull((Object)onClickListener, (String)"onClickListener");
        LinearLayout linearLayout = new LinearLayout(ctx);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        linearLayout.setOrientation(1);
        linearLayout.setBackgroundColor(UIUtils.getThemeColorFromAttrOrRes((Context)ctx, (int)R.attr.material_drawer_background, (int)R.color.material_drawer_background));
        if (drawer.getMStickyFooterDivider$library_release()) {
            this.addStickyFooterDivider(ctx, (ViewGroup)linearLayout);
        }
        this.fillStickyDrawerItemFooter(drawer, (ViewGroup)linearLayout, onClickListener);
        return (ViewGroup)linearLayout;
    }

    private final void addStickyFooterDivider(Context ctx, ViewGroup footerView) {
        LinearLayout divider = new LinearLayout(ctx);
        LinearLayout.LayoutParams dividerParams = new LinearLayout.LayoutParams(-1, -2);
        divider.setMinimumHeight((int)UIUtils.convertDpToPixel((float)1.0f, (Context)ctx));
        divider.setOrientation(1);
        divider.setBackgroundColor(UIUtils.getThemeColorFromAttrOrRes((Context)ctx, (int)R.attr.material_drawer_divider, (int)R.color.material_drawer_divider));
        footerView.addView((View)divider, (ViewGroup.LayoutParams)dividerParams);
    }

    public final void fillStickyDrawerItemFooter(@NotNull DrawerBuilder drawer, @NotNull ViewGroup container, @NotNull View.OnClickListener onClickListener) {
        Intrinsics.checkParameterIsNotNull((Object)drawer, (String)"drawer");
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        Intrinsics.checkParameterIsNotNull((Object)onClickListener, (String)"onClickListener");
        for (IDrawerItem<?> drawerItem : drawer.getMStickyDrawerItems$library_release()) {
            Context context = container.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"container.context");
            View view = drawerItem.generateView(context, container);
            view.setTag(drawerItem);
            if (drawerItem.isEnabled()) {
                view.setOnClickListener(onClickListener);
            }
            container.addView(view);
            DrawerUIUtils.INSTANCE.setDrawerVerticalPadding(view);
        }
        container.setPadding(0, 0, 0, 0);
    }

    @SuppressLint(value={"RtlHardcoded"})
    @Nullable
    public final DrawerLayout.LayoutParams processDrawerLayoutParams(@NotNull DrawerBuilder drawer, @Nullable DrawerLayout.LayoutParams params) {
        Intrinsics.checkParameterIsNotNull((Object)drawer, (String)"drawer");
        if (params != null) {
            Context ctx = drawer.getMDrawerLayout$library_release().getContext();
            if (drawer.getMDrawerGravity$library_release() == 5 || drawer.getMDrawerGravity$library_release() == 0x800005) {
                params.rightMargin = 0;
                if (Build.VERSION.SDK_INT >= 17) {
                    params.setMarginEnd(0);
                }
                Context context = ctx;
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"ctx");
                params.leftMargin = context.getResources().getDimensionPixelSize(R.dimen.material_drawer_margin);
                if (Build.VERSION.SDK_INT >= 17) {
                    params.setMarginEnd(ctx.getResources().getDimensionPixelSize(R.dimen.material_drawer_margin));
                }
            }
            if (drawer.getMDrawerWidth$library_release() > -1) {
                params.width = drawer.getMDrawerWidth$library_release();
            } else {
                Context context = ctx;
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"ctx");
                params.width = DrawerUIUtils.INSTANCE.getOptimalDrawerWidth(context);
            }
        }
        return params;
    }

    private DrawerUtils() {
    }

    static {
        DrawerUtils drawerUtils;
        INSTANCE = drawerUtils = new DrawerUtils();
    }
}

