/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.holder;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.Dimension;
import androidx.annotation.DrawableRes;
import androidx.core.view.ViewCompat;
import com.mikepenz.materialdrawer.R;
import com.mikepenz.materialdrawer.holder.ColorHolder;
import com.mikepenz.materialdrawer.holder.DimenHolder;
import com.mikepenz.materialdrawer.model.utils.BadgeDrawableBuilder;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\b\u0016\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u001b\b\u0016\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006B/\b\u0016\u0012\b\b\u0001\u0010\u0007\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0001\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\tJ\u001c\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\n\b\u0002\u00102\u001a\u0004\u0018\u00010\"H\u0017J\u000e\u00103\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u00104\u001a\u00020\u00002\b\b\u0001\u0010\u0003\u001a\u00020\u0004J\u0010\u00105\u001a\u00020\u00002\b\b\u0001\u0010\u0005\u001a\u00020\u0004J\u0010\u00106\u001a\u00020\u00002\b\b\u0001\u0010\u0005\u001a\u00020\u0004J\u0010\u00107\u001a\u00020\u00002\b\b\u0001\u0010\u0003\u001a\u00020\u0004J\u000e\u00108\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u00108\u001a\u00020\u00002\b\b\u0001\u00109\u001a\u00020\u0004J\u0010\u0010:\u001a\u00020\u00002\b\b\u0001\u0010\u0017\u001a\u00020\u0004J\u0010\u0010;\u001a\u00020\u00002\b\b\u0001\u0010\u0007\u001a\u00020\u0004J\u000e\u0010<\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u0018J\u0010\u0010<\u001a\u00020\u00002\b\b\u0001\u0010#\u001a\u00020\u0004J\u000e\u0010=\u001a\u00020\u00002\u0006\u0010>\u001a\u00020\u0018J\u0010\u0010=\u001a\u00020\u00002\b\b\u0001\u0010>\u001a\u00020\u0004J\u0010\u0010?\u001a\u00020\u00002\b\b\u0001\u0010&\u001a\u00020\u0004J\u0010\u0010@\u001a\u00020\u00002\b\b\u0001\u0010&\u001a\u00020\u0004J\u0010\u0010A\u001a\u00020\u00002\b\b\u0001\u0010&\u001a\u00020\u0004J\u0010\u0010B\u001a\u00020\u00002\b\b\u0001\u0010)\u001a\u00020\u0004J\u0010\u0010C\u001a\u00020\u00002\b\b\u0001\u0010)\u001a\u00020\u0004J\u0010\u0010D\u001a\u00020\u00002\b\b\u0001\u0010)\u001a\u00020\u0004J\u0010\u0010E\u001a\u00020\u00002\b\b\u0001\u0010\b\u001a\u00020\u0004J\u0010\u0010F\u001a\u00020\u00002\b\b\u0001\u0010\b\u001a\u00020\u0004J\u000e\u0010G\u001a\u00020\u00002\u0006\u0010H\u001a\u00020\"R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0012\"\u0004\b\u0016\u0010\u0014R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u0007\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u001a\"\u0004\b%\u0010\u001cR\u001a\u0010&\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u001a\"\u0004\b(\u0010\u001cR\u001a\u0010)\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u001a\"\u0004\b+\u0010\u001cR\u001c\u0010\b\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0012\"\u0004\b-\u0010\u0014\u00a8\u0006I"}, d2={"Lcom/mikepenz/materialdrawer/holder/BadgeStyle;", "", "()V", "color", "", "colorPressed", "(II)V", "gradientDrawable", "textColor", "(IIII)V", "badgeBackground", "Landroid/graphics/drawable/Drawable;", "getBadgeBackground", "()Landroid/graphics/drawable/Drawable;", "setBadgeBackground", "(Landroid/graphics/drawable/Drawable;)V", "Lcom/mikepenz/materialdrawer/holder/ColorHolder;", "getColor", "()Lcom/mikepenz/materialdrawer/holder/ColorHolder;", "setColor", "(Lcom/mikepenz/materialdrawer/holder/ColorHolder;)V", "getColorPressed", "setColorPressed", "corners", "Lcom/mikepenz/materialdrawer/holder/DimenHolder;", "getCorners", "()Lcom/mikepenz/materialdrawer/holder/DimenHolder;", "setCorners", "(Lcom/mikepenz/materialdrawer/holder/DimenHolder;)V", "getGradientDrawable", "()I", "setGradientDrawable", "(I)V", "mTextColorStateList", "Landroid/content/res/ColorStateList;", "minWidth", "getMinWidth", "setMinWidth", "paddingLeftRight", "getPaddingLeftRight", "setPaddingLeftRight", "paddingTopBottom", "getPaddingTopBottom", "setPaddingTopBottom", "getTextColor", "setTextColor", "style", "", "badgeTextView", "Landroid/widget/TextView;", "colorStateList", "withBadgeBackground", "withColor", "withColorPressed", "withColorPressedRes", "withColorRes", "withCorners", "cornersPx", "withCornersDp", "withGradientDrawable", "withMinWidth", "withPadding", "padding", "withPaddingLeftRightDp", "withPaddingLeftRightPx", "withPaddingLeftRightRes", "withPaddingTopBottomDp", "withPaddingTopBottomPx", "withPaddingTopBottomRes", "withTextColor", "withTextColorRes", "withTextColorStateList", "textColorStateList", "library_release"})
public class BadgeStyle {
    private int gradientDrawable = R.drawable.material_drawer_badge;
    @Nullable
    private Drawable badgeBackground;
    @Nullable
    private ColorHolder color;
    @Nullable
    private ColorHolder colorPressed;
    @Nullable
    private ColorHolder textColor;
    private ColorStateList mTextColorStateList;
    @Nullable
    private DimenHolder corners;
    @NotNull
    private DimenHolder paddingTopBottom = DimenHolder.Companion.fromDp(2);
    @NotNull
    private DimenHolder paddingLeftRight = DimenHolder.Companion.fromDp(3);
    @NotNull
    private DimenHolder minWidth = DimenHolder.Companion.fromDp(20);

    public final int getGradientDrawable() {
        return this.gradientDrawable;
    }

    public final void setGradientDrawable(int n) {
        this.gradientDrawable = n;
    }

    @Nullable
    public final Drawable getBadgeBackground() {
        return this.badgeBackground;
    }

    public final void setBadgeBackground(@Nullable Drawable drawable2) {
        this.badgeBackground = drawable2;
    }

    @Nullable
    public final ColorHolder getColor() {
        return this.color;
    }

    public final void setColor(@Nullable ColorHolder colorHolder) {
        this.color = colorHolder;
    }

    @Nullable
    public final ColorHolder getColorPressed() {
        return this.colorPressed;
    }

    public final void setColorPressed(@Nullable ColorHolder colorHolder) {
        this.colorPressed = colorHolder;
    }

    @Nullable
    public final ColorHolder getTextColor() {
        return this.textColor;
    }

    public final void setTextColor(@Nullable ColorHolder colorHolder) {
        this.textColor = colorHolder;
    }

    @Nullable
    public final DimenHolder getCorners() {
        return this.corners;
    }

    public final void setCorners(@Nullable DimenHolder dimenHolder) {
        this.corners = dimenHolder;
    }

    @NotNull
    public final DimenHolder getPaddingTopBottom() {
        return this.paddingTopBottom;
    }

    public final void setPaddingTopBottom(@NotNull DimenHolder dimenHolder) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)dimenHolder), (String)"<set-?>");
        this.paddingTopBottom = dimenHolder;
    }

    @NotNull
    public final DimenHolder getPaddingLeftRight() {
        return this.paddingLeftRight;
    }

    public final void setPaddingLeftRight(@NotNull DimenHolder dimenHolder) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)dimenHolder), (String)"<set-?>");
        this.paddingLeftRight = dimenHolder;
    }

    @NotNull
    public final DimenHolder getMinWidth() {
        return this.minWidth;
    }

    public final void setMinWidth(@NotNull DimenHolder dimenHolder) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)dimenHolder), (String)"<set-?>");
        this.minWidth = dimenHolder;
    }

    @NotNull
    public final BadgeStyle withGradientDrawable(@DrawableRes int gradientDrawable) {
        this.gradientDrawable = gradientDrawable;
        this.badgeBackground = null;
        return this;
    }

    @NotNull
    public final BadgeStyle withBadgeBackground(@NotNull Drawable badgeBackground) {
        Intrinsics.checkParameterIsNotNull((Object)badgeBackground, (String)"badgeBackground");
        this.badgeBackground = badgeBackground;
        this.gradientDrawable = -1;
        return this;
    }

    @NotNull
    public final BadgeStyle withColor(@ColorInt int color2) {
        this.color = ColorHolder.Companion.fromColor(color2);
        return this;
    }

    @NotNull
    public final BadgeStyle withColorRes(@ColorRes int color2) {
        this.color = ColorHolder.Companion.fromColorRes(color2);
        return this;
    }

    @NotNull
    public final BadgeStyle withColorPressed(@ColorInt int colorPressed) {
        this.colorPressed = ColorHolder.Companion.fromColor(colorPressed);
        return this;
    }

    @NotNull
    public final BadgeStyle withColorPressedRes(@ColorRes int colorPressed) {
        this.colorPressed = ColorHolder.Companion.fromColorRes(colorPressed);
        return this;
    }

    @NotNull
    public final BadgeStyle withTextColor(@ColorInt int textColor) {
        this.textColor = ColorHolder.Companion.fromColor(textColor);
        return this;
    }

    @NotNull
    public final BadgeStyle withTextColorRes(@ColorRes int textColor) {
        this.textColor = ColorHolder.Companion.fromColorRes(textColor);
        return this;
    }

    @NotNull
    public final BadgeStyle withTextColorStateList(@NotNull ColorStateList textColorStateList) {
        Intrinsics.checkParameterIsNotNull((Object)textColorStateList, (String)"textColorStateList");
        this.textColor = null;
        this.mTextColorStateList = textColorStateList;
        return this;
    }

    @NotNull
    public final BadgeStyle withCorners(@Dimension(unit=1) int cornersPx) {
        this.corners = DimenHolder.Companion.fromPixel(cornersPx);
        return this;
    }

    @NotNull
    public final BadgeStyle withCornersDp(@Dimension(unit=0) int corners) {
        this.corners = DimenHolder.Companion.fromDp(corners);
        return this;
    }

    @NotNull
    public final BadgeStyle withCorners(@NotNull DimenHolder corners) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)corners), (String)"corners");
        this.corners = corners;
        return this;
    }

    @NotNull
    public final BadgeStyle withPaddingLeftRightPx(@Dimension(unit=1) int paddingLeftRight) {
        this.paddingLeftRight = DimenHolder.Companion.fromPixel(paddingLeftRight);
        return this;
    }

    @NotNull
    public final BadgeStyle withPaddingLeftRightDp(@Dimension(unit=0) int paddingLeftRight) {
        this.paddingLeftRight = DimenHolder.Companion.fromDp(paddingLeftRight);
        return this;
    }

    @NotNull
    public final BadgeStyle withPaddingLeftRightRes(@DimenRes int paddingLeftRight) {
        this.paddingLeftRight = DimenHolder.Companion.fromResource(paddingLeftRight);
        return this;
    }

    @NotNull
    public final BadgeStyle withPaddingTopBottomPx(@Dimension(unit=1) int paddingTopBottom) {
        this.paddingTopBottom = DimenHolder.Companion.fromPixel(paddingTopBottom);
        return this;
    }

    @NotNull
    public final BadgeStyle withPaddingTopBottomDp(@Dimension(unit=0) int paddingTopBottom) {
        this.paddingTopBottom = DimenHolder.Companion.fromDp(paddingTopBottom);
        return this;
    }

    @NotNull
    public final BadgeStyle withPaddingTopBottomRes(@DimenRes int paddingTopBottom) {
        this.paddingTopBottom = DimenHolder.Companion.fromResource(paddingTopBottom);
        return this;
    }

    @NotNull
    public final BadgeStyle withPadding(@Dimension(unit=1) int padding) {
        this.paddingLeftRight = DimenHolder.Companion.fromPixel(padding);
        this.paddingTopBottom = DimenHolder.Companion.fromPixel(padding);
        return this;
    }

    @NotNull
    public final BadgeStyle withPadding(@NotNull DimenHolder padding) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)padding), (String)"padding");
        this.paddingLeftRight = padding;
        this.paddingTopBottom = padding;
        return this;
    }

    @NotNull
    public final BadgeStyle withMinWidth(@Dimension(unit=1) int minWidth) {
        this.minWidth = DimenHolder.Companion.fromPixel(minWidth);
        return this;
    }

    @NotNull
    public final BadgeStyle withMinWidth(@NotNull DimenHolder minWidth) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)minWidth), (String)"minWidth");
        this.minWidth = minWidth;
        return this;
    }

    @JvmOverloads
    public void style(@NotNull TextView badgeTextView, @Nullable ColorStateList colorStateList) {
        Intrinsics.checkParameterIsNotNull((Object)badgeTextView, (String)"badgeTextView");
        Context ctx = badgeTextView.getContext();
        if (this.badgeBackground == null) {
            View view = (View)badgeTextView;
            BadgeDrawableBuilder badgeDrawableBuilder = new BadgeDrawableBuilder(this);
            Context context = ctx;
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"ctx");
            ViewCompat.setBackground((View)view, (Drawable)((Drawable)badgeDrawableBuilder.build(context)));
        } else {
            ViewCompat.setBackground((View)((View)badgeTextView), (Drawable)this.badgeBackground);
        }
        if (this.textColor != null) {
            ColorHolder colorHolder = this.textColor;
            if (colorHolder != null) {
                colorHolder.applyToOr(badgeTextView, null);
            }
        } else if (this.mTextColorStateList != null) {
            badgeTextView.setTextColor(this.mTextColorStateList);
        } else if (colorStateList != null) {
            badgeTextView.setTextColor(colorStateList);
        }
        int paddingLeftRight = this.paddingLeftRight.asPixel(ctx);
        int paddingTopBottom = this.paddingTopBottom.asPixel(ctx);
        badgeTextView.setPadding(paddingLeftRight, paddingTopBottom, paddingLeftRight, paddingTopBottom);
        badgeTextView.setMinWidth(this.minWidth.asPixel(ctx));
    }

    public static /* synthetic */ void style$default(BadgeStyle badgeStyle, TextView textView, ColorStateList colorStateList, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: style");
        }
        if ((n & 2) != 0) {
            colorStateList = null;
        }
        badgeStyle.style(textView, colorStateList);
    }

    @JvmOverloads
    public void style(@NotNull TextView badgeTextView) {
        BadgeStyle.style$default(this, badgeTextView, null, 2, null);
    }

    public BadgeStyle() {
    }

    public BadgeStyle(@ColorInt int color2, @ColorInt int colorPressed) {
        this.color = ColorHolder.Companion.fromColor(color2);
        this.colorPressed = ColorHolder.Companion.fromColor(colorPressed);
    }

    public BadgeStyle(@DrawableRes int gradientDrawable, @ColorInt int color2, @ColorInt int colorPressed, @ColorInt int textColor) {
        this.gradientDrawable = gradientDrawable;
        this.color = ColorHolder.Companion.fromColor(color2);
        this.colorPressed = ColorHolder.Companion.fromColor(colorPressed);
        this.textColor = ColorHolder.Companion.fromColor(textColor);
    }
}

