/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.holder;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.widget.ImageView;
import androidx.annotation.DrawableRes;
import androidx.appcompat.content.res.AppCompatResources;
import com.mikepenz.iconics.IconicsColor;
import com.mikepenz.iconics.IconicsDrawable;
import com.mikepenz.iconics.IconicsSize;
import com.mikepenz.iconics.typeface.IIcon;
import com.mikepenz.materialdrawer.util.DrawerImageLoader;
import java.io.FileNotFoundException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 #2\u00020\u0001:\u0001#B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0011\b\u0016\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nB\u0011\b\u0016\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rB\u0011\b\u0016\u0012\b\b\u0001\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010B\u000f\b\u0016\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u001a\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016J(\u0010\u001d\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u000fR\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0013\u00a8\u0006$"}, d2={"Lcom/mikepenz/materialdrawer/holder/ImageHolder;", "Lcom/mikepenz/materialize/holder/ImageHolder;", "url", "", "(Ljava/lang/String;)V", "uri", "Landroid/net/Uri;", "(Landroid/net/Uri;)V", "icon", "Landroid/graphics/drawable/Drawable;", "(Landroid/graphics/drawable/Drawable;)V", "bitmap", "Landroid/graphics/Bitmap;", "(Landroid/graphics/Bitmap;)V", "iconRes", "", "(I)V", "iicon", "Lcom/mikepenz/iconics/typeface/IIcon;", "(Lcom/mikepenz/iconics/typeface/IIcon;)V", "iIcon", "getIIcon", "()Lcom/mikepenz/iconics/typeface/IIcon;", "setIIcon", "applyTo", "", "imageView", "Landroid/widget/ImageView;", "tag", "decideIcon", "ctx", "Landroid/content/Context;", "iconColor", "tint", "paddingDp", "Companion", "library_release"})
public class ImageHolder
extends com.mikepenz.materialize.holder.ImageHolder {
    @Nullable
    private IIcon iIcon;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final IIcon getIIcon() {
        return this.iIcon;
    }

    public final void setIIcon(@Nullable IIcon iIcon) {
        this.iIcon = iIcon;
    }

    public boolean applyTo(@NotNull ImageView imageView, @Nullable String tag) {
        Intrinsics.checkParameterIsNotNull((Object)imageView, (String)"imageView");
        IIcon ii = this.iIcon;
        if (this.getUri() != null) {
            DrawerImageLoader drawerImageLoader = DrawerImageLoader.Companion.getInstance();
            Uri uri = this.getUri();
            Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"uri");
            boolean consumed = drawerImageLoader.setImage(imageView, uri, tag);
            if (!consumed) {
                imageView.setImageURI(this.getUri());
            }
        } else if (this.getIcon() != null) {
            imageView.setImageDrawable(this.getIcon());
        } else if (this.getBitmap() != null) {
            imageView.setImageBitmap(this.getBitmap());
        } else if (this.getIconRes() != -1) {
            imageView.setImageResource(this.getIconRes());
        } else if (ii != null) {
            Context context = imageView.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"imageView.context");
            imageView.setImageDrawable((Drawable)new IconicsDrawable(context, ii).actionBar());
        } else {
            imageView.setImageBitmap(null);
            return false;
        }
        return true;
    }

    @Nullable
    public final Drawable decideIcon(@NotNull Context ctx, int iconColor, boolean tint, int paddingDp) {
        Drawable icon;
        block8: {
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            icon = this.getIcon();
            IIcon ii = this.iIcon;
            if (ii != null) {
                icon = (Drawable)new IconicsDrawable(ctx, ii).color(IconicsColor.Companion.colorInt(iconColor)).size(IconicsSize.Companion.dp((Number)24)).padding(IconicsSize.Companion.dp((Number)paddingDp));
            } else if (this.getIconRes() != -1) {
                icon = AppCompatResources.getDrawable((Context)ctx, (int)this.getIconRes());
            } else if (this.getUri() != null) {
                try {
                    InputStream inputStream = ctx.getContentResolver().openInputStream(this.getUri());
                    icon = Drawable.createFromStream((InputStream)inputStream, (String)this.getUri().toString());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            if (icon == null || !tint || this.iIcon != null) break block8;
            Drawable drawable2 = icon = icon.mutate();
            if (drawable2 != null) {
                drawable2.setColorFilter(iconColor, PorterDuff.Mode.SRC_IN);
            }
        }
        return icon;
    }

    public ImageHolder(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        super(url);
    }

    public ImageHolder(@NotNull Uri uri) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        super(uri);
    }

    public ImageHolder(@Nullable Drawable icon) {
        super(icon);
    }

    public ImageHolder(@Nullable Bitmap bitmap) {
        super(bitmap);
    }

    public ImageHolder(@DrawableRes int iconRes) {
        super(iconRes);
    }

    public ImageHolder(@NotNull IIcon iicon) {
        Intrinsics.checkParameterIsNotNull((Object)iicon, (String)"iicon");
        super((Bitmap)null);
        this.iIcon = iicon;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ:\u0010\u000e\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bJ&\u0010\u0014\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016J2\u0010\u0017\u001a\u0004\u0018\u00010\u00102\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n\u00a8\u0006\u001a"}, d2={"Lcom/mikepenz/materialdrawer/holder/ImageHolder$Companion;", "", "()V", "applyDecidedIconOrSetGone", "", "imageHolder", "Lcom/mikepenz/materialdrawer/holder/ImageHolder;", "imageView", "Landroid/widget/ImageView;", "iconColor", "", "tint", "", "paddingDp", "applyMultiIconTo", "icon", "Landroid/graphics/drawable/Drawable;", "selectedIcon", "selectedIconColor", "tinted", "applyToOrSetInvisible", "tag", "", "decideIcon", "ctx", "Landroid/content/Context;", "library_release"})
    public static final class Companion {
        @Nullable
        public final Drawable decideIcon(@Nullable ImageHolder imageHolder, @NotNull Context ctx, int iconColor, boolean tint, int paddingDp) {
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            ImageHolder imageHolder2 = imageHolder;
            return imageHolder2 != null ? imageHolder2.decideIcon(ctx, iconColor, tint, paddingDp) : null;
        }

        public final void applyDecidedIconOrSetGone(@Nullable ImageHolder imageHolder, @Nullable ImageView imageView, int iconColor, boolean tint, int paddingDp) {
            if (imageHolder != null && imageView != null) {
                Context context = imageView.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"imageView.context");
                Drawable drawable2 = Companion.decideIcon(imageHolder, context, iconColor, tint, paddingDp);
                if (drawable2 != null) {
                    imageView.setImageDrawable(drawable2);
                    imageView.setVisibility(0);
                } else if (imageHolder.getBitmap() != null) {
                    imageView.setImageBitmap(imageHolder.getBitmap());
                    imageView.setVisibility(0);
                } else {
                    imageView.setVisibility(8);
                }
            } else if (imageView != null) {
                imageView.setVisibility(8);
            }
        }

        public final void applyMultiIconTo(@Nullable Drawable icon, int iconColor, @Nullable Drawable selectedIcon, int selectedIconColor, boolean tinted, @NotNull ImageView imageView) {
            Intrinsics.checkParameterIsNotNull((Object)imageView, (String)"imageView");
            com.mikepenz.materialize.holder.ImageHolder.applyMultiIconTo((Drawable)icon, (int)iconColor, (Drawable)selectedIcon, (int)selectedIconColor, (boolean)tinted, (ImageView)imageView);
        }

        public final void applyToOrSetInvisible(@Nullable ImageHolder imageHolder, @Nullable ImageView imageView, @Nullable String tag) {
            com.mikepenz.materialize.holder.ImageHolder.applyToOrSetInvisible((com.mikepenz.materialize.holder.ImageHolder)imageHolder, (ImageView)imageView, (String)tag);
        }

        public static /* synthetic */ void applyToOrSetInvisible$default(Companion companion, ImageHolder imageHolder, ImageView imageView, String string2, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            companion.applyToOrSetInvisible(imageHolder, imageView, string2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

