/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.model;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.StringRes;
import androidx.recyclerview.widget.RecyclerView;
import com.mikepenz.iconics.typeface.IIcon;
import com.mikepenz.materialdrawer.R;
import com.mikepenz.materialdrawer.holder.ColorHolder;
import com.mikepenz.materialdrawer.holder.ColorHolderKt;
import com.mikepenz.materialdrawer.holder.ImageHolder;
import com.mikepenz.materialdrawer.holder.StringHolder;
import com.mikepenz.materialdrawer.model.AbstractDrawerItem;
import com.mikepenz.materialdrawer.model.interfaces.Iconable;
import com.mikepenz.materialdrawer.model.interfaces.Nameable;
import com.mikepenz.materialdrawer.model.interfaces.Tagable;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0002\b\u0012\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u00020\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00042\b\u0012\u0004\u0012\u0002H\u00010\u00052\b\u0012\u0004\u0012\u0002H\u00010\u00062\b\u0012\u0004\u0012\u0002H\u00010\u0007B\u0005\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0016\u001a\u00020\u001e2\u0006\u00100\u001a\u000201J\u0010\u0010.\u001a\u00020\u001e2\u0006\u00100\u001a\u000201H\u0004J\u0015\u00102\u001a\u00028\u00002\b\b\u0001\u0010\t\u001a\u00020\u001e\u00a2\u0006\u0002\u00103J\u0015\u00104\u001a\u00028\u00002\b\b\u0001\u00105\u001a\u00020\u001e\u00a2\u0006\u0002\u00103J\u0015\u00106\u001a\u00028\u00002\b\b\u0001\u00107\u001a\u00020\u001e\u00a2\u0006\u0002\u00103J\u0015\u00108\u001a\u00028\u00002\b\b\u0001\u00109\u001a\u00020\u001e\u00a2\u0006\u0002\u00103J\u0017\u0010:\u001a\u00028\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010;H\u0016\u00a2\u0006\u0002\u0010<J\u0015\u0010:\u001a\u00028\u00002\u0006\u0010=\u001a\u00020>H\u0016\u00a2\u0006\u0002\u0010?J\u0017\u0010:\u001a\u00028\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010@J\u0015\u0010:\u001a\u00028\u00002\b\b\u0001\u0010A\u001a\u00020\u001e\u00a2\u0006\u0002\u00103J\u0015\u0010B\u001a\u00028\u00002\b\b\u0001\u0010\u0015\u001a\u00020\u001e\u00a2\u0006\u0002\u00103J\u0015\u0010C\u001a\u00028\u00002\b\b\u0001\u0010D\u001a\u00020\u001e\u00a2\u0006\u0002\u00103J\u0015\u0010E\u001a\u00028\u00002\u0006\u0010F\u001a\u00020\u0019H\u0007\u00a2\u0006\u0002\u0010GJ\u0013\u0010H\u001a\u00028\u00002\u0006\u0010I\u001a\u00020\u0019\u00a2\u0006\u0002\u0010GJ\u0013\u0010J\u001a\u00028\u00002\u0006\u0010\u001f\u001a\u00020\u001e\u00a2\u0006\u0002\u00103J\u0017\u0010K\u001a\u00028\u00002\b\u0010$\u001a\u0004\u0018\u00010%H\u0016\u00a2\u0006\u0002\u0010LJ\u0017\u0010K\u001a\u00028\u00002\b\b\u0001\u0010M\u001a\u00020\u001eH\u0016\u00a2\u0006\u0002\u00103J\u0015\u0010K\u001a\u00028\u00002\u0006\u0010$\u001a\u00020NH\u0016\u00a2\u0006\u0002\u0010OJ\u0015\u0010P\u001a\u00028\u00002\b\b\u0001\u0010Q\u001a\u00020\u001e\u00a2\u0006\u0002\u00103J\u0015\u0010R\u001a\u00028\u00002\b\b\u0001\u0010S\u001a\u00020\u001e\u00a2\u0006\u0002\u00103J\u0013\u0010T\u001a\u00028\u00002\u0006\u0010*\u001a\u00020;\u00a2\u0006\u0002\u0010<J\u0015\u0010T\u001a\u00028\u00002\b\b\u0001\u0010U\u001a\u00020\u001e\u00a2\u0006\u0002\u00103J\u0015\u0010V\u001a\u00028\u00002\b\b\u0001\u0010-\u001a\u00020\u001e\u00a2\u0006\u0002\u00103J\u0015\u0010W\u001a\u00028\u00002\b\b\u0001\u0010S\u001a\u00020\u001e\u00a2\u0006\u0002\u00103J\u0015\u0010X\u001a\u00028\u00002\b\b\u0001\u0010Y\u001a\u00020\u001e\u00a2\u0006\u0002\u00103J\u0015\u0010Z\u001a\u00028\u00002\b\b\u0001\u0010S\u001a\u00020\u001e\u00a2\u0006\u0002\u00103J\u0015\u0010[\u001a\u00028\u00002\b\b\u0001\u0010\\\u001a\u00020\u001e\u00a2\u0006\u0002\u00103J\u0015\u0010]\u001a\u00028\u00002\b\b\u0001\u0010^\u001a\u00020\u001e\u00a2\u0006\u0002\u00103J\u0015\u0010_\u001a\u00028\u00002\u0006\u0010F\u001a\u00020\u0019H\u0007\u00a2\u0006\u0002\u0010GR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\f\"\u0004\b\u0017\u0010\u000eR\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u001a\"\u0004\b\u001b\u0010\u001cR$\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001e@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001c\u0010$\u001a\u0004\u0018\u00010%X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001c\u0010*\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u0012\"\u0004\b,\u0010\u0014R\u001c\u0010-\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\f\"\u0004\b/\u0010\u000e\u00a8\u0006`"}, d2={"Lcom/mikepenz/materialdrawer/model/BaseDrawerItem;", "T", "VH", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "Lcom/mikepenz/materialdrawer/model/AbstractDrawerItem;", "Lcom/mikepenz/materialdrawer/model/interfaces/Nameable;", "Lcom/mikepenz/materialdrawer/model/interfaces/Iconable;", "Lcom/mikepenz/materialdrawer/model/interfaces/Tagable;", "()V", "disabledIconColor", "Lcom/mikepenz/materialdrawer/holder/ColorHolder;", "getDisabledIconColor", "()Lcom/mikepenz/materialdrawer/holder/ColorHolder;", "setDisabledIconColor", "(Lcom/mikepenz/materialdrawer/holder/ColorHolder;)V", "icon", "Lcom/mikepenz/materialdrawer/holder/ImageHolder;", "getIcon", "()Lcom/mikepenz/materialdrawer/holder/ImageHolder;", "setIcon", "(Lcom/mikepenz/materialdrawer/holder/ImageHolder;)V", "iconColor", "getIconColor", "setIconColor", "isIconTinted", "", "()Z", "setIconTinted", "(Z)V", "<set-?>", "", "level", "getLevel", "()I", "setLevel", "(I)V", "name", "Lcom/mikepenz/materialdrawer/holder/StringHolder;", "getName", "()Lcom/mikepenz/materialdrawer/holder/StringHolder;", "setName", "(Lcom/mikepenz/materialdrawer/holder/StringHolder;)V", "selectedIcon", "getSelectedIcon", "setSelectedIcon", "selectedIconColor", "getSelectedIconColor", "setSelectedIconColor", "ctx", "Landroid/content/Context;", "withDisabledIconColor", "(I)Ljava/lang/Object;", "withDisabledIconColorRes", "disabledIconColorRes", "withDisabledTextColor", "disabledTextColor", "withDisabledTextColorRes", "disabledTextColorRes", "withIcon", "Landroid/graphics/drawable/Drawable;", "(Landroid/graphics/drawable/Drawable;)Ljava/lang/Object;", "iicon", "Lcom/mikepenz/iconics/typeface/IIcon;", "(Lcom/mikepenz/iconics/typeface/IIcon;)Ljava/lang/Object;", "(Lcom/mikepenz/materialdrawer/holder/ImageHolder;)Ljava/lang/Object;", "iconRes", "withIconColor", "withIconColorRes", "iconColorRes", "withIconTinted", "iconTinted", "(Z)Ljava/lang/Object;", "withIconTintingEnabled", "iconTintingEnabled", "withLevel", "withName", "(Lcom/mikepenz/materialdrawer/holder/StringHolder;)Ljava/lang/Object;", "nameRes", "", "(Ljava/lang/String;)Ljava/lang/Object;", "withSelectedColor", "selectedColor", "withSelectedColorRes", "selectedColorRes", "withSelectedIcon", "selectedIconRes", "withSelectedIconColor", "withSelectedIconColorRes", "withSelectedTextColor", "selectedTextColor", "withSelectedTextColorRes", "withTextColor", "textColor", "withTextColorRes", "textColorRes", "withTintSelectedIcon", "library_release"})
public abstract class BaseDrawerItem<T, VH extends RecyclerView.ViewHolder>
extends AbstractDrawerItem<T, VH>
implements Nameable<T>,
Iconable<T>,
Tagable<T> {
    @Nullable
    private ImageHolder icon;
    @Nullable
    private ImageHolder selectedIcon;
    @Nullable
    private StringHolder name;
    private boolean isIconTinted;
    @Nullable
    private ColorHolder iconColor;
    @Nullable
    private ColorHolder selectedIconColor;
    @Nullable
    private ColorHolder disabledIconColor;
    private int level = 1;

    @Override
    @Nullable
    public ImageHolder getIcon() {
        return this.icon;
    }

    public void setIcon(@Nullable ImageHolder imageHolder) {
        this.icon = imageHolder;
    }

    @Nullable
    public final ImageHolder getSelectedIcon() {
        return this.selectedIcon;
    }

    public final void setSelectedIcon(@Nullable ImageHolder imageHolder) {
        this.selectedIcon = imageHolder;
    }

    @Override
    @Nullable
    public StringHolder getName() {
        return this.name;
    }

    public void setName(@Nullable StringHolder stringHolder) {
        this.name = stringHolder;
    }

    public final boolean isIconTinted() {
        return this.isIconTinted;
    }

    public final void setIconTinted(boolean bl) {
        this.isIconTinted = bl;
    }

    @Nullable
    public final ColorHolder getIconColor() {
        return this.iconColor;
    }

    public final void setIconColor(@Nullable ColorHolder colorHolder) {
        this.iconColor = colorHolder;
    }

    @Nullable
    public final ColorHolder getSelectedIconColor() {
        return this.selectedIconColor;
    }

    public final void setSelectedIconColor(@Nullable ColorHolder colorHolder) {
        this.selectedIconColor = colorHolder;
    }

    @Nullable
    public final ColorHolder getDisabledIconColor() {
        return this.disabledIconColor;
    }

    public final void setDisabledIconColor(@Nullable ColorHolder colorHolder) {
        this.disabledIconColor = colorHolder;
    }

    public final int getLevel() {
        return this.level;
    }

    protected final void setLevel(int n) {
        this.level = n;
    }

    @Override
    public T withIcon(@Nullable ImageHolder icon) {
        this.setIcon(icon);
        return (T)this;
    }

    @Override
    public T withIcon(@Nullable Drawable icon) {
        if (icon != null) {
            this.setIcon(new ImageHolder(icon));
        } else {
            this.setIcon(null);
        }
        return (T)this;
    }

    public final T withIcon(@DrawableRes int iconRes) {
        this.setIcon(new ImageHolder(iconRes));
        return (T)this;
    }

    public final T withSelectedIcon(@NotNull Drawable selectedIcon) {
        Intrinsics.checkParameterIsNotNull((Object)selectedIcon, (String)"selectedIcon");
        this.selectedIcon = new ImageHolder(selectedIcon);
        return (T)this;
    }

    public final T withSelectedIcon(@DrawableRes int selectedIconRes) {
        this.selectedIcon = new ImageHolder(selectedIconRes);
        return (T)this;
    }

    @Override
    public T withIcon(@NotNull IIcon iicon) {
        Intrinsics.checkParameterIsNotNull((Object)iicon, (String)"iicon");
        this.setIcon(new ImageHolder(iicon));
        if (Build.VERSION.SDK_INT >= 21) {
            this.selectedIcon = new ImageHolder(iicon);
        } else {
            this.withIconTintingEnabled(true);
        }
        return (T)this;
    }

    @Override
    public T withName(@Nullable StringHolder name) {
        this.setName(name);
        return (T)this;
    }

    @Override
    public T withName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.setName(new StringHolder(name));
        return (T)this;
    }

    @Override
    public T withName(@StringRes int nameRes) {
        this.setName(new StringHolder(nameRes));
        return (T)this;
    }

    public final T withSelectedColor(@ColorInt int selectedColor) {
        this.setSelectedColor(ColorHolder.Companion.fromColor(selectedColor));
        return (T)this;
    }

    public final T withSelectedColorRes(@ColorRes int selectedColorRes) {
        this.setSelectedColor(ColorHolder.Companion.fromColorRes(selectedColorRes));
        return (T)this;
    }

    public final T withTextColor(@ColorInt int textColor) {
        this.setTextColor(ColorHolder.Companion.fromColor(textColor));
        return (T)this;
    }

    public final T withTextColorRes(@ColorRes int textColorRes) {
        this.setTextColor(ColorHolder.Companion.fromColorRes(textColorRes));
        return (T)this;
    }

    public final T withSelectedTextColor(@ColorInt int selectedTextColor) {
        this.setSelectedTextColor(ColorHolder.Companion.fromColor(selectedTextColor));
        return (T)this;
    }

    public final T withSelectedTextColorRes(@ColorRes int selectedColorRes) {
        this.setSelectedTextColor(ColorHolder.Companion.fromColorRes(selectedColorRes));
        return (T)this;
    }

    public final T withDisabledTextColor(@ColorInt int disabledTextColor) {
        this.setDisabledTextColor(ColorHolder.Companion.fromColor(disabledTextColor));
        return (T)this;
    }

    public final T withDisabledTextColorRes(@ColorRes int disabledTextColorRes) {
        this.setDisabledTextColor(ColorHolder.Companion.fromColorRes(disabledTextColorRes));
        return (T)this;
    }

    public final T withIconColor(@ColorInt int iconColor) {
        this.iconColor = ColorHolder.Companion.fromColor(iconColor);
        return (T)this;
    }

    public final T withIconColorRes(@ColorRes int iconColorRes) {
        this.iconColor = ColorHolder.Companion.fromColorRes(iconColorRes);
        return (T)this;
    }

    public final T withSelectedIconColor(@ColorInt int selectedIconColor) {
        this.selectedIconColor = ColorHolder.Companion.fromColor(selectedIconColor);
        return (T)this;
    }

    public final T withSelectedIconColorRes(@ColorRes int selectedColorRes) {
        this.selectedIconColor = ColorHolder.Companion.fromColorRes(selectedColorRes);
        return (T)this;
    }

    public final T withDisabledIconColor(@ColorInt int disabledIconColor) {
        this.disabledIconColor = ColorHolder.Companion.fromColor(disabledIconColor);
        return (T)this;
    }

    public final T withDisabledIconColorRes(@ColorRes int disabledIconColorRes) {
        this.disabledIconColor = ColorHolder.Companion.fromColorRes(disabledIconColorRes);
        return (T)this;
    }

    public final T withIconTintingEnabled(boolean iconTintingEnabled) {
        this.isIconTinted = iconTintingEnabled;
        return (T)this;
    }

    @Deprecated(message="")
    public final T withIconTinted(boolean iconTinted) {
        this.isIconTinted = iconTinted;
        return (T)this;
    }

    @Deprecated(message="")
    public final T withTintSelectedIcon(boolean iconTinted) {
        return this.withIconTintingEnabled(iconTinted);
    }

    public final T withLevel(int level) {
        this.level = level;
        return (T)this;
    }

    public final int getIconColor(@NotNull Context ctx) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        return this.isEnabled() ? ColorHolderKt.applyColor(this.iconColor, ctx, R.attr.material_drawer_primary_icon, R.color.material_drawer_primary_icon) : ColorHolderKt.applyColor(this.disabledIconColor, ctx, R.attr.material_drawer_hint_icon, R.color.material_drawer_hint_icon);
    }

    protected final int getSelectedIconColor(@NotNull Context ctx) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        return ColorHolderKt.applyColor(this.selectedIconColor, ctx, R.attr.material_drawer_selected_text, R.color.material_drawer_selected_text);
    }
}

