/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.model;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.LayoutRes;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.mikepenz.iconics.IconicsColor;
import com.mikepenz.iconics.IconicsDrawable;
import com.mikepenz.iconics.IconicsSize;
import com.mikepenz.iconics.typeface.IIcon;
import com.mikepenz.materialdrawer.Drawer;
import com.mikepenz.materialdrawer.R;
import com.mikepenz.materialdrawer.holder.ColorHolder;
import com.mikepenz.materialdrawer.icons.MaterialDrawerFont;
import com.mikepenz.materialdrawer.model.AbstractDrawerItem;
import com.mikepenz.materialdrawer.model.BaseDescribeableDrawerItem;
import com.mikepenz.materialdrawer.model.BaseViewHolder;
import com.mikepenz.materialdrawer.model.interfaces.IDrawerItem;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\u0001:\u00010B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00022\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0016J\u0010\u0010&\u001a\u00020\u00022\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00002\b\b\u0001\u0010\u0004\u001a\u00020\u000bJ\u0010\u0010*\u001a\u00020\u00002\b\b\u0001\u0010+\u001a\u00020\u000bJ\u000e\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u000bJ\u000e\u0010.\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u000bJ\u0010\u0010/\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0016H\u0016R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u0014\u0010\u0013\u001a\u00020\u000b8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\rR\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u0016X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0018\"\u0004\b\u001d\u0010\u001aR\u0014\u0010\u001e\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\r\u00a8\u00061"}, d2={"Lcom/mikepenz/materialdrawer/model/ExpandableDrawerItem;", "Lcom/mikepenz/materialdrawer/model/BaseDescribeableDrawerItem;", "Lcom/mikepenz/materialdrawer/model/ExpandableDrawerItem$ViewHolder;", "()V", "arrowColor", "Lcom/mikepenz/materialdrawer/holder/ColorHolder;", "getArrowColor", "()Lcom/mikepenz/materialdrawer/holder/ColorHolder;", "setArrowColor", "(Lcom/mikepenz/materialdrawer/holder/ColorHolder;)V", "arrowRotationAngleEnd", "", "getArrowRotationAngleEnd", "()I", "setArrowRotationAngleEnd", "(I)V", "arrowRotationAngleStart", "getArrowRotationAngleStart", "setArrowRotationAngleStart", "layoutRes", "getLayoutRes", "mOnDrawerItemClickListener", "Lcom/mikepenz/materialdrawer/Drawer$OnDrawerItemClickListener;", "getMOnDrawerItemClickListener", "()Lcom/mikepenz/materialdrawer/Drawer$OnDrawerItemClickListener;", "setMOnDrawerItemClickListener", "(Lcom/mikepenz/materialdrawer/Drawer$OnDrawerItemClickListener;)V", "onDrawerItemClickListener", "getOnDrawerItemClickListener", "setOnDrawerItemClickListener", "type", "getType", "bindView", "", "holder", "payloads", "", "", "getViewHolder", "v", "Landroid/view/View;", "withArrowColor", "withArrowColorRes", "arrowColorRes", "withArrowRotationAngleEnd", "angle", "withArrowRotationAngleStart", "withOnDrawerItemClickListener", "ViewHolder", "library_release"})
public class ExpandableDrawerItem
extends BaseDescribeableDrawerItem<ExpandableDrawerItem, ViewHolder> {
    @Nullable
    private Drawer.OnDrawerItemClickListener mOnDrawerItemClickListener;
    @Nullable
    private ColorHolder arrowColor;
    private int arrowRotationAngleStart;
    private int arrowRotationAngleEnd = 180;
    @Nullable
    private Drawer.OnDrawerItemClickListener onDrawerItemClickListener = new Drawer.OnDrawerItemClickListener(this){
        final /* synthetic */ ExpandableDrawerItem this$0;

        public boolean onItemClick(@Nullable View view, int position, @NotNull IDrawerItem<?> drawerItem) {
            Intrinsics.checkParameterIsNotNull(drawerItem, (String)"drawerItem");
            if (drawerItem instanceof AbstractDrawerItem && drawerItem.isEnabled()) {
                View view2 = view;
                if (view2 != null) {
                    View view3 = view2;
                    boolean bl = false;
                    boolean bl2 = false;
                    View it = view3;
                    boolean bl3 = false;
                    if (drawerItem.getSubItems() != null) {
                        if (drawerItem.isExpanded()) {
                            ViewCompat.animate((View)view.findViewById(R.id.material_drawer_arrow)).rotation((float)this.this$0.getArrowRotationAngleEnd()).start();
                        } else {
                            ViewCompat.animate((View)view.findViewById(R.id.material_drawer_arrow)).rotation((float)this.this$0.getArrowRotationAngleStart()).start();
                        }
                    }
                }
            }
            Drawer.OnDrawerItemClickListener onDrawerItemClickListener2 = this.this$0.getMOnDrawerItemClickListener();
            return onDrawerItemClickListener2 != null ? onDrawerItemClickListener2.onItemClick(view, position, drawerItem) : false;
        }
        {
            this.this$0 = $outer;
        }
    };

    @Nullable
    public final Drawer.OnDrawerItemClickListener getMOnDrawerItemClickListener() {
        return this.mOnDrawerItemClickListener;
    }

    public final void setMOnDrawerItemClickListener(@Nullable Drawer.OnDrawerItemClickListener onDrawerItemClickListener2) {
        this.mOnDrawerItemClickListener = onDrawerItemClickListener2;
    }

    @Nullable
    public final ColorHolder getArrowColor() {
        return this.arrowColor;
    }

    public final void setArrowColor(@Nullable ColorHolder colorHolder) {
        this.arrowColor = colorHolder;
    }

    public final int getArrowRotationAngleStart() {
        return this.arrowRotationAngleStart;
    }

    public final void setArrowRotationAngleStart(int n) {
        this.arrowRotationAngleStart = n;
    }

    public final int getArrowRotationAngleEnd() {
        return this.arrowRotationAngleEnd;
    }

    public final void setArrowRotationAngleEnd(int n) {
        this.arrowRotationAngleEnd = n;
    }

    @Override
    public int getType() {
        return R.id.material_drawer_item_expandable;
    }

    @Override
    @LayoutRes
    public int getLayoutRes() {
        return R.layout.material_drawer_item_expandable;
    }

    @Override
    @Nullable
    public Drawer.OnDrawerItemClickListener getOnDrawerItemClickListener() {
        return this.onDrawerItemClickListener;
    }

    @Override
    public void setOnDrawerItemClickListener(@Nullable Drawer.OnDrawerItemClickListener onDrawerItemClickListener2) {
        this.onDrawerItemClickListener = onDrawerItemClickListener2;
    }

    @NotNull
    public final ExpandableDrawerItem withArrowColor(@ColorInt int arrowColor) {
        this.arrowColor = ColorHolder.Companion.fromColor(arrowColor);
        return this;
    }

    @NotNull
    public final ExpandableDrawerItem withArrowColorRes(@ColorRes int arrowColorRes) {
        this.arrowColor = ColorHolder.Companion.fromColorRes(arrowColorRes);
        return this;
    }

    @NotNull
    public final ExpandableDrawerItem withArrowRotationAngleStart(int angle) {
        this.arrowRotationAngleStart = angle;
        return this;
    }

    @NotNull
    public final ExpandableDrawerItem withArrowRotationAngleEnd(int angle) {
        this.arrowRotationAngleEnd = angle;
        return this;
    }

    @Override
    @NotNull
    public ExpandableDrawerItem withOnDrawerItemClickListener(@NotNull Drawer.OnDrawerItemClickListener onDrawerItemClickListener2) {
        Intrinsics.checkParameterIsNotNull((Object)onDrawerItemClickListener2, (String)"onDrawerItemClickListener");
        this.mOnDrawerItemClickListener = onDrawerItemClickListener2;
        return this;
    }

    @Override
    public void bindView(@NotNull ViewHolder holder, @NotNull List<Object> payloads) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)holder), (String)"holder");
        Intrinsics.checkParameterIsNotNull(payloads, (String)"payloads");
        super.bindView((RecyclerView.ViewHolder)holder, payloads);
        View view = holder.itemView;
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"holder.itemView");
        Context ctx = view.getContext();
        this.bindViewHelper(holder);
        if (holder.getArrow().getDrawable() instanceof IconicsDrawable) {
            int n;
            Drawable drawable2 = holder.getArrow().getDrawable();
            if (drawable2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.mikepenz.iconics.IconicsDrawable");
            }
            IconicsDrawable iconicsDrawable = (IconicsDrawable)drawable2;
            ColorHolder colorHolder = this.arrowColor;
            if (colorHolder != null) {
                n = colorHolder.color(ctx);
            } else {
                Context context = ctx;
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"ctx");
                n = this.getIconColor(context);
            }
            iconicsDrawable.color(IconicsColor.Companion.colorInt(n));
        }
        holder.getArrow().clearAnimation();
        if (!this.isExpanded()) {
            holder.getArrow().setRotation((float)this.arrowRotationAngleStart);
        } else {
            holder.getArrow().setRotation((float)this.arrowRotationAngleEnd);
        }
        IDrawerItem iDrawerItem = this;
        View view2 = holder.itemView;
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"holder.itemView");
        this.onPostBindView(iDrawerItem, view2);
    }

    @Override
    @NotNull
    public ViewHolder getViewHolder(@NotNull View v) {
        Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
        return new ViewHolder(v);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/mikepenz/materialdrawer/model/ExpandableDrawerItem$ViewHolder;", "Lcom/mikepenz/materialdrawer/model/BaseViewHolder;", "view", "Landroid/view/View;", "(Landroid/view/View;)V", "arrow", "Landroid/widget/ImageView;", "getArrow", "()Landroid/widget/ImageView;", "setArrow", "(Landroid/widget/ImageView;)V", "library_release"})
    public static final class ViewHolder
    extends BaseViewHolder {
        @NotNull
        private ImageView arrow;

        @NotNull
        public final ImageView getArrow() {
            return this.arrow;
        }

        public final void setArrow(@NotNull ImageView imageView) {
            Intrinsics.checkParameterIsNotNull((Object)imageView, (String)"<set-?>");
            this.arrow = imageView;
        }

        public ViewHolder(@NotNull View view) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            super(view);
            View view2 = view.findViewById(R.id.material_drawer_arrow);
            Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"view.findViewById(R.id.material_drawer_arrow)");
            this.arrow = (ImageView)view2;
            Context context = view.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"view.context");
            this.arrow.setImageDrawable((Drawable)new IconicsDrawable(context, (IIcon)MaterialDrawerFont.Icon.mdf_expand_more).size(IconicsSize.Companion.dp((Number)16)).padding(IconicsSize.Companion.dp((Number)2)).color(IconicsColor.Companion.colorInt(-16777216)));
        }
    }
}

