/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.model;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.StringRes;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.mikepenz.iconics.typeface.IIcon;
import com.mikepenz.materialdrawer.R;
import com.mikepenz.materialdrawer.holder.ColorHolder;
import com.mikepenz.materialdrawer.holder.ImageHolder;
import com.mikepenz.materialdrawer.holder.StringHolder;
import com.mikepenz.materialdrawer.model.AbstractDrawerItem;
import com.mikepenz.materialdrawer.model.interfaces.IDrawerItem;
import com.mikepenz.materialdrawer.model.interfaces.IProfile;
import com.mikepenz.materialdrawer.model.interfaces.Tagable;
import com.mikepenz.materialdrawer.util.DrawerImageLoader;
import com.mikepenz.materialdrawer.util.DrawerUIUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0010\b\u0016\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u00032\b\u0012\u0004\u0012\u00020\u00000\u0004:\u0001IB\u0005\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00022\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0016J\u0010\u0010&\u001a\u00020\u00022\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00002\b\b\u0001\u0010*\u001a\u00020\u0018J\u0010\u0010+\u001a\u00020\u00002\b\b\u0001\u0010,\u001a\u00020\u0018J\u0010\u0010-\u001a\u00020\u00002\b\b\u0001\u0010.\u001a\u00020\u0018J\u0012\u0010-\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010/H\u0016J\u0010\u00100\u001a\u00020\u00002\u0006\u00101\u001a\u000202H\u0016J\u0012\u00100\u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u000103H\u0016J\u0010\u00100\u001a\u00020\u00002\u0006\u00104\u001a\u000205H\u0016J\u0010\u00100\u001a\u00020\u00002\u0006\u0010\f\u001a\u000206H\u0016J\u0012\u00100\u001a\u00020\u00002\b\b\u0001\u00107\u001a\u00020\u0018H\u0016J\u0010\u00100\u001a\u00020\u00002\u0006\u00108\u001a\u00020/H\u0016J\u0012\u00109\u001a\u00020\u00002\b\u0010\u001b\u001a\u0004\u0018\u00010:H\u0016J\u0010\u00109\u001a\u00020\u00002\b\b\u0001\u0010;\u001a\u00020\u0018J\u000e\u0010<\u001a\u00020\u00002\u0006\u0010=\u001a\u00020\u0013J\u0010\u0010>\u001a\u00020\u00002\b\b\u0001\u0010?\u001a\u00020\u0018J\u0010\u0010@\u001a\u00020\u00002\b\b\u0001\u0010A\u001a\u00020\u0018J\u0010\u0010B\u001a\u00020\u00002\b\b\u0001\u0010C\u001a\u00020\u0018J\u0010\u0010D\u001a\u00020\u00002\b\b\u0001\u0010A\u001a\u00020\u0018J\u0010\u0010E\u001a\u00020\u00002\b\b\u0001\u0010F\u001a\u00020\u0018J\u0010\u0010G\u001a\u00020\u00002\b\b\u0001\u0010H\u001a\u00020\u0018R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\t\"\u0004\b\u001d\u0010\u000bR\u0014\u0010\u001e\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001a\u00a8\u0006J"}, d2={"Lcom/mikepenz/materialdrawer/model/ProfileDrawerItem;", "Lcom/mikepenz/materialdrawer/model/AbstractDrawerItem;", "Lcom/mikepenz/materialdrawer/model/ProfileDrawerItem$ViewHolder;", "Lcom/mikepenz/materialdrawer/model/interfaces/IProfile;", "Lcom/mikepenz/materialdrawer/model/interfaces/Tagable;", "()V", "email", "Lcom/mikepenz/materialdrawer/holder/StringHolder;", "getEmail", "()Lcom/mikepenz/materialdrawer/holder/StringHolder;", "setEmail", "(Lcom/mikepenz/materialdrawer/holder/StringHolder;)V", "icon", "Lcom/mikepenz/materialdrawer/holder/ImageHolder;", "getIcon", "()Lcom/mikepenz/materialdrawer/holder/ImageHolder;", "setIcon", "(Lcom/mikepenz/materialdrawer/holder/ImageHolder;)V", "isNameShown", "", "()Z", "setNameShown", "(Z)V", "layoutRes", "", "getLayoutRes", "()I", "name", "getName", "setName", "type", "getType", "bindView", "", "holder", "payloads", "", "", "getViewHolder", "v", "Landroid/view/View;", "withDisabledTextColor", "disabledTextColor", "withDisabledTextColorRes", "disabledTextColorRes", "withEmail", "emailRes", "", "withIcon", "bitmap", "Landroid/graphics/Bitmap;", "Landroid/graphics/drawable/Drawable;", "uri", "Landroid/net/Uri;", "Lcom/mikepenz/iconics/typeface/IIcon;", "iconRes", "url", "withName", "", "nameRes", "withNameShown", "nameShown", "withSelectedColor", "selectedColor", "withSelectedColorRes", "selectedColorRes", "withSelectedTextColor", "selectedTextColor", "withSelectedTextColorRes", "withTextColor", "textColor", "withTextColorRes", "textColorRes", "ViewHolder", "library_release"})
public class ProfileDrawerItem
extends AbstractDrawerItem<ProfileDrawerItem, ViewHolder>
implements IProfile<ProfileDrawerItem>,
Tagable<ProfileDrawerItem> {
    @Nullable
    private ImageHolder icon;
    @Nullable
    private StringHolder name;
    @Nullable
    private StringHolder email;
    private boolean isNameShown;

    @Override
    @Nullable
    public ImageHolder getIcon() {
        return this.icon;
    }

    public void setIcon(@Nullable ImageHolder imageHolder) {
        this.icon = imageHolder;
    }

    @Override
    @Nullable
    public StringHolder getName() {
        return this.name;
    }

    public void setName(@Nullable StringHolder stringHolder) {
        this.name = stringHolder;
    }

    @Override
    @Nullable
    public StringHolder getEmail() {
        return this.email;
    }

    public void setEmail(@Nullable StringHolder stringHolder) {
        this.email = stringHolder;
    }

    public final boolean isNameShown() {
        return this.isNameShown;
    }

    public final void setNameShown(boolean bl) {
        this.isNameShown = bl;
    }

    @Override
    public int getType() {
        return R.id.material_drawer_item_profile;
    }

    @Override
    @LayoutRes
    public int getLayoutRes() {
        return R.layout.material_drawer_item_profile;
    }

    @Override
    @NotNull
    public ProfileDrawerItem withIcon(@Nullable Drawable icon) {
        this.setIcon(new ImageHolder(icon));
        return this;
    }

    @Override
    @NotNull
    public ProfileDrawerItem withIcon(@DrawableRes int iconRes) {
        this.setIcon(new ImageHolder(iconRes));
        return this;
    }

    @Override
    @NotNull
    public ProfileDrawerItem withIcon(@NotNull Bitmap bitmap) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        this.setIcon(new ImageHolder(bitmap));
        return this;
    }

    @Override
    @NotNull
    public ProfileDrawerItem withIcon(@NotNull IIcon icon) {
        Intrinsics.checkParameterIsNotNull((Object)icon, (String)"icon");
        this.setIcon(new ImageHolder(icon));
        return this;
    }

    @Override
    @NotNull
    public ProfileDrawerItem withIcon(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        this.setIcon(new ImageHolder(url));
        return this;
    }

    @Override
    @NotNull
    public ProfileDrawerItem withIcon(@NotNull Uri uri) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        this.setIcon(new ImageHolder(uri));
        return this;
    }

    @Override
    @NotNull
    public ProfileDrawerItem withName(@Nullable CharSequence name) {
        this.setName(new StringHolder(name));
        return this;
    }

    @NotNull
    public final ProfileDrawerItem withName(@StringRes int nameRes) {
        this.setName(new StringHolder(nameRes));
        return this;
    }

    @Override
    @NotNull
    public ProfileDrawerItem withEmail(@Nullable String email) {
        this.setEmail(new StringHolder(email));
        return this;
    }

    @NotNull
    public final ProfileDrawerItem withEmail(@StringRes int emailRes) {
        this.setEmail(new StringHolder(emailRes));
        return this;
    }

    @NotNull
    public final ProfileDrawerItem withNameShown(boolean nameShown) {
        this.isNameShown = nameShown;
        return this;
    }

    @NotNull
    public final ProfileDrawerItem withSelectedColor(@ColorInt int selectedColor) {
        this.setSelectedColor(ColorHolder.Companion.fromColor(selectedColor));
        return this;
    }

    @NotNull
    public final ProfileDrawerItem withSelectedColorRes(@ColorRes int selectedColorRes) {
        this.setSelectedColor(ColorHolder.Companion.fromColorRes(selectedColorRes));
        return this;
    }

    @NotNull
    public final ProfileDrawerItem withTextColor(@ColorInt int textColor) {
        this.setTextColor(ColorHolder.Companion.fromColor(textColor));
        return this;
    }

    @NotNull
    public final ProfileDrawerItem withTextColorRes(@ColorRes int textColorRes) {
        this.setTextColor(ColorHolder.Companion.fromColorRes(textColorRes));
        return this;
    }

    @NotNull
    public final ProfileDrawerItem withSelectedTextColor(@ColorInt int selectedTextColor) {
        this.setSelectedTextColor(ColorHolder.Companion.fromColor(selectedTextColor));
        return this;
    }

    @NotNull
    public final ProfileDrawerItem withSelectedTextColorRes(@ColorRes int selectedColorRes) {
        this.setSelectedTextColor(ColorHolder.Companion.fromColorRes(selectedColorRes));
        return this;
    }

    @NotNull
    public final ProfileDrawerItem withDisabledTextColor(@ColorInt int disabledTextColor) {
        this.setDisabledTextColor(ColorHolder.Companion.fromColor(disabledTextColor));
        return this;
    }

    @NotNull
    public final ProfileDrawerItem withDisabledTextColorRes(@ColorRes int disabledTextColorRes) {
        this.setDisabledTextColor(ColorHolder.Companion.fromColorRes(disabledTextColorRes));
        return this;
    }

    @Override
    public void bindView(@NotNull ViewHolder holder, @NotNull List<Object> payloads) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)holder), (String)"holder");
        Intrinsics.checkParameterIsNotNull(payloads, (String)"payloads");
        super.bindView((RecyclerView.ViewHolder)holder, payloads);
        View view = holder.itemView;
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"holder.itemView");
        Context ctx = view.getContext();
        View view2 = holder.itemView;
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"holder.itemView");
        view2.setId(this.hashCode());
        View view3 = holder.itemView;
        Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"holder.itemView");
        view3.setEnabled(this.isEnabled());
        View view4 = holder.itemView;
        Intrinsics.checkExpressionValueIsNotNull((Object)view4, (String)"holder.itemView");
        view4.setSelected(this.isSelected());
        Context context = ctx;
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"ctx");
        int selectedColor = this.getSelectedColor(context);
        int color2 = this.getColor(ctx);
        int selectedTextColor = this.getSelectedTextColor(ctx);
        ShapeAppearanceModel shapeAppearanceModel = this.getShapeAppearanceModel(ctx);
        DrawerUIUtils.INSTANCE.themeDrawerItem(ctx, holder.getView$library_release(), selectedColor, this.isSelectedBackgroundAnimated(), shapeAppearanceModel);
        if (this.isNameShown) {
            holder.getName$library_release().setVisibility(0);
            StringHolder.Companion.applyTo(this.getName(), holder.getName$library_release());
        } else {
            holder.getName$library_release().setVisibility(8);
        }
        if (!this.isNameShown && this.getEmail() == null && this.getName() != null) {
            StringHolder.Companion.applyTo(this.getName(), holder.getEmail$library_release());
        } else {
            StringHolder.Companion.applyTo(this.getEmail(), holder.getEmail$library_release());
        }
        if (this.getTypeface() != null) {
            holder.getName$library_release().setTypeface(this.getTypeface());
            holder.getEmail$library_release().setTypeface(this.getTypeface());
        }
        if (this.isNameShown) {
            holder.getName$library_release().setTextColor(this.getTextColorStateList(color2, selectedTextColor));
        }
        holder.getEmail$library_release().setTextColor(this.getTextColorStateList(color2, selectedTextColor));
        DrawerImageLoader.Companion.getInstance().cancelImage(holder.getProfileIcon$library_release());
        ImageHolder.Companion.applyToOrSetInvisible(this.getIcon(), holder.getProfileIcon$library_release(), DrawerImageLoader.Tags.PROFILE_DRAWER_ITEM.name());
        DrawerUIUtils.INSTANCE.setDrawerVerticalPadding(holder.getView$library_release());
        IDrawerItem iDrawerItem = this;
        View view5 = holder.itemView;
        Intrinsics.checkExpressionValueIsNotNull((Object)view5, (String)"holder.itemView");
        this.onPostBindView(iDrawerItem, view5);
    }

    @Override
    @NotNull
    public ViewHolder getViewHolder(@NotNull View v) {
        Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
        return new ViewHolder(v);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/mikepenz/materialdrawer/model/ProfileDrawerItem$ViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "view", "Landroid/view/View;", "(Landroid/view/View;)V", "email", "Landroid/widget/TextView;", "getEmail$library_release", "()Landroid/widget/TextView;", "name", "getName$library_release", "profileIcon", "Landroid/widget/ImageView;", "getProfileIcon$library_release", "()Landroid/widget/ImageView;", "getView$library_release", "()Landroid/view/View;", "library_release"})
    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        @NotNull
        private final ImageView profileIcon;
        @NotNull
        private final TextView name;
        @NotNull
        private final TextView email;
        @NotNull
        private final View view;

        @NotNull
        public final ImageView getProfileIcon$library_release() {
            return this.profileIcon;
        }

        @NotNull
        public final TextView getName$library_release() {
            return this.name;
        }

        @NotNull
        public final TextView getEmail$library_release() {
            return this.email;
        }

        @NotNull
        public final View getView$library_release() {
            return this.view;
        }

        public ViewHolder(@NotNull View view) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            super(view);
            this.view = view;
            View view2 = this.view.findViewById(R.id.material_drawer_profileIcon);
            Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"view.findViewById(R.id.m\u2026erial_drawer_profileIcon)");
            this.profileIcon = (ImageView)view2;
            View view3 = this.view.findViewById(R.id.material_drawer_name);
            Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"view.findViewById(R.id.material_drawer_name)");
            this.name = (TextView)view3;
            View view4 = this.view.findViewById(R.id.material_drawer_email);
            Intrinsics.checkExpressionValueIsNotNull((Object)view4, (String)"view.findViewById(R.id.material_drawer_email)");
            this.email = (TextView)view4;
        }
    }
}

