/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.util;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.mikepenz.materialdrawer.R;
import com.mikepenz.materialdrawer.model.interfaces.IDrawerItem;
import com.mikepenz.materialize.util.UIUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0006J\u0018\u0010\u0010\u001a\u00020\u00002\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\bJ'\u0010\u0010\u001a\u00020\u00002\u001a\u0010\u0011\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\t0\u0012\"\u0006\u0012\u0002\b\u00030\t\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/mikepenz/materialdrawer/util/DrawerItemViewHelper;", "", "mContext", "Landroid/content/Context;", "(Landroid/content/Context;)V", "mDivider", "", "mDrawerItems", "Ljava/util/ArrayList;", "Lcom/mikepenz/materialdrawer/model/interfaces/IDrawerItem;", "mOnDrawerItemClickListener", "Lcom/mikepenz/materialdrawer/util/DrawerItemViewHelper$OnDrawerItemClickListener;", "build", "Landroid/view/View;", "withDivider", "divider", "withDrawerItems", "drawerItems", "", "([Lcom/mikepenz/materialdrawer/model/interfaces/IDrawerItem;)Lcom/mikepenz/materialdrawer/util/DrawerItemViewHelper;", "withOnDrawerItemClickListener", "onDrawerItemClickListener", "OnDrawerItemClickListener", "library_release"})
public class DrawerItemViewHelper {
    private ArrayList<IDrawerItem<?>> mDrawerItems;
    private boolean mDivider;
    private OnDrawerItemClickListener mOnDrawerItemClickListener;
    private final Context mContext;

    @NotNull
    public final DrawerItemViewHelper withDrawerItems(@NotNull ArrayList<IDrawerItem<?>> drawerItems) {
        Intrinsics.checkParameterIsNotNull(drawerItems, (String)"drawerItems");
        this.mDrawerItems = drawerItems;
        return this;
    }

    @NotNull
    public final DrawerItemViewHelper withDrawerItems(IDrawerItem<?> ... drawerItems) {
        Intrinsics.checkParameterIsNotNull(drawerItems, (String)"drawerItems");
        Collections.addAll((Collection)this.mDrawerItems, Arrays.copyOf(drawerItems, drawerItems.length));
        return this;
    }

    @NotNull
    public final DrawerItemViewHelper withDivider(boolean divider) {
        this.mDivider = divider;
        return this;
    }

    @NotNull
    public final DrawerItemViewHelper withOnDrawerItemClickListener(@NotNull OnDrawerItemClickListener onDrawerItemClickListener2) {
        Intrinsics.checkParameterIsNotNull((Object)onDrawerItemClickListener2, (String)"onDrawerItemClickListener");
        this.mOnDrawerItemClickListener = onDrawerItemClickListener2;
        return this;
    }

    @NotNull
    public final View build() {
        LinearLayout linearLayout = new LinearLayout(this.mContext);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        linearLayout.setOrientation(1);
        if (this.mDivider) {
            LinearLayout divider = new LinearLayout(this.mContext);
            divider.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
            divider.setMinimumHeight((int)UIUtils.convertDpToPixel((float)1.0f, (Context)this.mContext));
            divider.setOrientation(1);
            divider.setBackgroundColor(UIUtils.getThemeColorFromAttrOrRes((Context)this.mContext, (int)R.attr.material_drawer_divider, (int)R.color.material_drawer_divider));
            linearLayout.addView((View)divider);
        }
        for (IDrawerItem<?> drawerItem : this.mDrawerItems) {
            View view = drawerItem.generateView(this.mContext);
            view.setTag(drawerItem);
            if (drawerItem.isEnabled()) {
                view.setBackgroundResource(UIUtils.getSelectableBackgroundRes((Context)this.mContext));
                view.setOnClickListener(new View.OnClickListener(this){
                    final /* synthetic */ DrawerItemViewHelper this$0;

                    public final void onClick(View v) {
                        block1: {
                            OnDrawerItemClickListener onDrawerItemClickListener2 = DrawerItemViewHelper.access$getMOnDrawerItemClickListener$p(this.this$0);
                            if (onDrawerItemClickListener2 == null) break block1;
                            View view = v;
                            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"v");
                            Object object = v.getTag(R.id.material_drawer_item);
                            if (object == null) {
                                throw new TypeCastException("null cannot be cast to non-null type com.mikepenz.materialdrawer.model.interfaces.IDrawerItem<*>");
                            }
                            onDrawerItemClickListener2.onItemClick(view, (IDrawerItem)object);
                        }
                    }
                    {
                        this.this$0 = drawerItemViewHelper;
                    }
                });
            }
            linearLayout.addView(view);
        }
        return (View)linearLayout;
    }

    public DrawerItemViewHelper(@NotNull Context mContext) {
        Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
        this.mContext = mContext;
        this.mDrawerItems = new ArrayList();
        this.mDivider = true;
    }

    public static final /* synthetic */ OnDrawerItemClickListener access$getMOnDrawerItemClickListener$p(DrawerItemViewHelper $this) {
        return $this.mOnDrawerItemClickListener;
    }

    public static final /* synthetic */ void access$setMOnDrawerItemClickListener$p(DrawerItemViewHelper $this, OnDrawerItemClickListener onDrawerItemClickListener2) {
        $this.mOnDrawerItemClickListener = onDrawerItemClickListener2;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H&\u00a8\u0006\b"}, d2={"Lcom/mikepenz/materialdrawer/util/DrawerItemViewHelper$OnDrawerItemClickListener;", "", "onItemClick", "", "view", "Landroid/view/View;", "drawerItem", "Lcom/mikepenz/materialdrawer/model/interfaces/IDrawerItem;", "library_release"})
    public static interface OnDrawerItemClickListener {
        public void onItemClick(@NotNull View var1, @NotNull IDrawerItem<?> var2);
    }
}

