/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.util;

import com.mikepenz.materialdrawer.holder.ImageHolder;
import com.mikepenz.materialdrawer.holder.StringHolder;
import com.mikepenz.materialdrawer.model.interfaces.Badgeable;
import com.mikepenz.materialdrawer.model.interfaces.BadgeableKt;
import com.mikepenz.materialdrawer.model.interfaces.IDrawerItem;
import com.mikepenz.materialdrawer.model.interfaces.Iconable;
import com.mikepenz.materialdrawer.model.interfaces.IconableKt;
import com.mikepenz.materialdrawer.model.interfaces.Nameable;
import com.mikepenz.materialdrawer.model.interfaces.NameableKt;
import com.mikepenz.materialdrawer.util.ExtensionsKt;
import com.mikepenz.materialdrawer.widget.MaterialDrawerSliderView;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000P\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0016\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u001e\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u001a+\u0010\u0007\u001a\u00020\u0001*\u00020\u00022\u001a\u0010\b\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00060\t\"\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\n\u001a3\u0010\u000b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u001a\u0010\b\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00060\t\"\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\f\u001a+\u0010\r\u001a\u00020\u0001*\u00020\u00022\u001a\u0010\u000e\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00060\t\"\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\n\u001a\u0016\u0010\u000f\u001a\u00020\u0001*\u00020\u00022\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u001a\u001e\u0010\u0010\u001a\u00020\u0001*\u00020\u00022\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001c\u0010\u0011\u001a\u00020\u0012*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0012H\u0000\u001a\u0018\u0010\u0014\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0006*\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u0018\u0010\u0014\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0006*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0016\u0010\u0019\u001a\u00020\u0004*\u00020\u00022\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u001a\u0012\u0010\u0019\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0016\u0010\u001a\u001a\u00020\u0004*\u00020\u00022\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u001a\n\u0010\u001b\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u001c\u001a\u00020\u0001*\u00020\u0002\u001a\u0012\u0010\u001d\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a+\u0010\u001e\u001a\u00020\u0001*\u00020\u00022\u001a\u0010\b\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00060\t\"\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\n\u001a\u0016\u0010\u001e\u001a\u00020\u0001*\u00020\u00022\n\u0010\u001f\u001a\u00020 \"\u00020\u0018\u001a\u0012\u0010!\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001e\u0010\"\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u001a+\u0010#\u001a\u00020\u0001*\u00020\u00022\u001a\u0010\b\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00060\t\"\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\n\u001a\u001e\u0010$\u001a\u00020\u0001*\u00020\u00022\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001a\u0010%\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010&\u001a\u00020'\u001a\u001a\u0010(\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010)\u001a\u00020*\u001a\u0016\u0010+\u001a\u00020\u0001*\u00020\u00022\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u001a\u001e\u0010,\u001a\u00020\u0001*\u00020\u00022\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001a\u0010-\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010.\u001a\u00020'\u001a\u0016\u0010/\u001a\u00020\u0001*\u00020\u00022\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u001a\u001e\u00100\u001a\u00020\u0001*\u00020\u00022\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u00061"}, d2={"addItemAtPosition", "", "Lcom/mikepenz/materialdrawer/widget/MaterialDrawerSliderView;", "position", "", "drawerItem", "Lcom/mikepenz/materialdrawer/model/interfaces/IDrawerItem;", "addItems", "drawerItems", "", "(Lcom/mikepenz/materialdrawer/widget/MaterialDrawerSliderView;[Lcom/mikepenz/materialdrawer/model/interfaces/IDrawerItem;)V", "addItemsAtPosition", "(Lcom/mikepenz/materialdrawer/widget/MaterialDrawerSliderView;I[Lcom/mikepenz/materialdrawer/model/interfaces/IDrawerItem;)V", "addStickyDrawerItems", "stickyDrawerItems", "addStickyFooterItem", "addStickyFooterItemAtPosition", "checkDrawerItem", "", "includeOffset", "getDrawerItem", "tag", "", "identifier", "", "getPosition", "getStickyFooterPosition", "removeAllItems", "removeAllStickyFooterItems", "removeItemByPosition", "removeItems", "identifiers", "", "removeStickyFooterItemAtPosition", "setItemAtPosition", "setItems", "setStickyFooterItemAtPosition", "updateBadge", "badge", "Lcom/mikepenz/materialdrawer/holder/StringHolder;", "updateIcon", "image", "Lcom/mikepenz/materialdrawer/holder/ImageHolder;", "updateItem", "updateItemAtPosition", "updateName", "name", "updateStickyFooterItem", "updateStickyFooterItemAtPosition", "materialdrawer"})
public final class MaterialDrawerSliderViewExtensionsKt {
    public static final void addItemAtPosition(@NotNull MaterialDrawerSliderView $this$addItemAtPosition, int position, @NotNull IDrawerItem<?> drawerItem) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$addItemAtPosition), (String)"$this$addItemAtPosition");
        Intrinsics.checkNotNullParameter(drawerItem, (String)"drawerItem");
        $this$addItemAtPosition.getItemAdapter().add(position, (Object[])new IDrawerItem[]{drawerItem});
    }

    public static final void setItemAtPosition(@NotNull MaterialDrawerSliderView $this$setItemAtPosition, int position, @NotNull IDrawerItem<?> drawerItem) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$setItemAtPosition), (String)"$this$setItemAtPosition");
        Intrinsics.checkNotNullParameter(drawerItem, (String)"drawerItem");
        $this$setItemAtPosition.getItemAdapter().set(position, drawerItem);
    }

    public static final void removeItemByPosition(@NotNull MaterialDrawerSliderView $this$removeItemByPosition, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$removeItemByPosition), (String)"$this$removeItemByPosition");
        if (MaterialDrawerSliderViewExtensionsKt.checkDrawerItem($this$removeItemByPosition, position, false)) {
            $this$removeItemByPosition.getItemAdapter().remove(position);
        }
    }

    public static final void removeItems(@NotNull MaterialDrawerSliderView $this$removeItems, long ... identifiers) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$removeItems), (String)"$this$removeItems");
        Intrinsics.checkNotNullParameter((Object)identifiers, (String)"identifiers");
        long[] $this$forEach$iv = identifiers;
        boolean $i$f$forEach = false;
        long[] lArray = $this$forEach$iv;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            long element$iv;
            long it = element$iv = lArray[i];
            boolean bl = false;
            $this$removeItems.getItemAdapter().removeByIdentifier(it);
        }
    }

    public static final void removeAllItems(@NotNull MaterialDrawerSliderView $this$removeAllItems) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$removeAllItems), (String)"$this$removeAllItems");
        $this$removeAllItems.getItemAdapter().clear();
    }

    public static final void removeItems(@NotNull MaterialDrawerSliderView $this$removeItems, IDrawerItem<?> ... drawerItems) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$removeItems), (String)"$this$removeItems");
        Intrinsics.checkNotNullParameter(drawerItems, (String)"drawerItems");
        IDrawerItem<?>[] $this$forEach$iv = drawerItems;
        boolean $i$f$forEach = false;
        IDrawerItem<?>[] iDrawerItemArray = $this$forEach$iv;
        int n = iDrawerItemArray.length;
        for (int i = 0; i < n; ++i) {
            IDrawerItem<?> element$iv;
            IDrawerItem<?> it = element$iv = iDrawerItemArray[i];
            boolean bl = false;
            $this$removeItems.getItemAdapter().removeByIdentifier(it.getIdentifier());
        }
    }

    public static final void setItems(@NotNull MaterialDrawerSliderView $this$setItems, IDrawerItem<?> ... drawerItems) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$setItems), (String)"$this$setItems");
        Intrinsics.checkNotNullParameter(drawerItems, (String)"drawerItems");
        $this$setItems.getItemAdapter().set(ArraysKt.asList((Object[])drawerItems));
    }

    public static final void addItems(@NotNull MaterialDrawerSliderView $this$addItems, IDrawerItem<?> ... drawerItems) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$addItems), (String)"$this$addItems");
        Intrinsics.checkNotNullParameter(drawerItems, (String)"drawerItems");
        $this$addItems.getItemAdapter().add((Object[])Arrays.copyOf(drawerItems, drawerItems.length));
    }

    public static final void addItemsAtPosition(@NotNull MaterialDrawerSliderView $this$addItemsAtPosition, int position, IDrawerItem<?> ... drawerItems) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$addItemsAtPosition), (String)"$this$addItemsAtPosition");
        Intrinsics.checkNotNullParameter(drawerItems, (String)"drawerItems");
        $this$addItemsAtPosition.getItemAdapter().add(position, (Object[])Arrays.copyOf(drawerItems, drawerItems.length));
    }

    public static final int getPosition(@NotNull MaterialDrawerSliderView $this$getPosition, @NotNull IDrawerItem<?> drawerItem) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$getPosition), (String)"$this$getPosition");
        Intrinsics.checkNotNullParameter(drawerItem, (String)"drawerItem");
        return MaterialDrawerSliderViewExtensionsKt.getPosition($this$getPosition, drawerItem.getIdentifier());
    }

    public static final int getPosition(@NotNull MaterialDrawerSliderView $this$getPosition, long identifier) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$getPosition), (String)"$this$getPosition");
        return ExtensionsKt.getPositionByIdentifier($this$getPosition, identifier);
    }

    @Nullable
    public static final IDrawerItem<?> getDrawerItem(@NotNull MaterialDrawerSliderView $this$getDrawerItem, long identifier) {
        Pair res;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$getDrawerItem), (String)"$this$getDrawerItem");
        Pair pair = res = $this$getDrawerItem.getAdapter().getItemById(identifier);
        return pair != null ? (IDrawerItem)pair.getFirst() : null;
    }

    @Nullable
    public static final IDrawerItem<?> getDrawerItem(@NotNull MaterialDrawerSliderView $this$getDrawerItem, @NotNull Object tag) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$getDrawerItem), (String)"$this$getDrawerItem");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        return ExtensionsKt.getDrawerItem($this$getDrawerItem.getItemAdapter().getAdapterItems(), tag);
    }

    public static final void updateItem(@NotNull MaterialDrawerSliderView $this$updateItem, @NotNull IDrawerItem<?> drawerItem) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$updateItem), (String)"$this$updateItem");
        Intrinsics.checkNotNullParameter(drawerItem, (String)"drawerItem");
        MaterialDrawerSliderViewExtensionsKt.updateItemAtPosition($this$updateItem, drawerItem, MaterialDrawerSliderViewExtensionsKt.getPosition($this$updateItem, drawerItem));
    }

    public static final void updateBadge(@NotNull MaterialDrawerSliderView $this$updateBadge, long identifier, @NotNull StringHolder badge) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$updateBadge), (String)"$this$updateBadge");
        Intrinsics.checkNotNullParameter((Object)badge, (String)"badge");
        IDrawerItem<?> drawerItem = MaterialDrawerSliderViewExtensionsKt.getDrawerItem($this$updateBadge, identifier);
        if (drawerItem instanceof Badgeable) {
            BadgeableKt.withBadge((Badgeable)((Object)drawerItem), badge);
            MaterialDrawerSliderViewExtensionsKt.updateItem($this$updateBadge, drawerItem);
        }
    }

    public static final void updateName(@NotNull MaterialDrawerSliderView $this$updateName, long identifier, @NotNull StringHolder name) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$updateName), (String)"$this$updateName");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        IDrawerItem<?> drawerItem = MaterialDrawerSliderViewExtensionsKt.getDrawerItem($this$updateName, identifier);
        if (drawerItem instanceof Nameable) {
            NameableKt.withName((Nameable)((Object)drawerItem), name);
            MaterialDrawerSliderViewExtensionsKt.updateItem($this$updateName, drawerItem);
        }
    }

    public static final void updateIcon(@NotNull MaterialDrawerSliderView $this$updateIcon, long identifier, @NotNull ImageHolder image) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$updateIcon), (String)"$this$updateIcon");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        IDrawerItem<?> drawerItem = MaterialDrawerSliderViewExtensionsKt.getDrawerItem($this$updateIcon, identifier);
        if (drawerItem instanceof Iconable) {
            IconableKt.withIcon((Iconable)((Object)drawerItem), image);
            MaterialDrawerSliderViewExtensionsKt.updateItem($this$updateIcon, drawerItem);
        }
    }

    public static final void updateItemAtPosition(@NotNull MaterialDrawerSliderView $this$updateItemAtPosition, @NotNull IDrawerItem<?> drawerItem, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$updateItemAtPosition), (String)"$this$updateItemAtPosition");
        Intrinsics.checkNotNullParameter(drawerItem, (String)"drawerItem");
        if (MaterialDrawerSliderViewExtensionsKt.checkDrawerItem($this$updateItemAtPosition, position, false)) {
            $this$updateItemAtPosition.getItemAdapter().set(position, drawerItem);
        }
    }

    public static final boolean checkDrawerItem(@NotNull MaterialDrawerSliderView $this$checkDrawerItem, int position, boolean includeOffset) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$checkDrawerItem), (String)"$this$checkDrawerItem");
        return $this$checkDrawerItem.getAdapter().getItem(position) != null;
    }

    public static final int getStickyFooterPosition(@NotNull MaterialDrawerSliderView $this$getStickyFooterPosition, @NotNull IDrawerItem<?> drawerItem) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$getStickyFooterPosition), (String)"$this$getStickyFooterPosition");
        Intrinsics.checkNotNullParameter(drawerItem, (String)"drawerItem");
        return ExtensionsKt.getStickyFooterPositionByIdentifier($this$getStickyFooterPosition, drawerItem.getIdentifier());
    }

    public static final void updateStickyFooterItem(@NotNull MaterialDrawerSliderView $this$updateStickyFooterItem, @NotNull IDrawerItem<?> drawerItem) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$updateStickyFooterItem), (String)"$this$updateStickyFooterItem");
        Intrinsics.checkNotNullParameter(drawerItem, (String)"drawerItem");
        MaterialDrawerSliderViewExtensionsKt.updateStickyFooterItemAtPosition($this$updateStickyFooterItem, drawerItem, MaterialDrawerSliderViewExtensionsKt.getStickyFooterPosition($this$updateStickyFooterItem, drawerItem));
    }

    public static final void updateStickyFooterItemAtPosition(@NotNull MaterialDrawerSliderView $this$updateStickyFooterItemAtPosition, @NotNull IDrawerItem<?> drawerItem, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$updateStickyFooterItemAtPosition), (String)"$this$updateStickyFooterItemAtPosition");
        Intrinsics.checkNotNullParameter(drawerItem, (String)"drawerItem");
        if ($this$updateStickyFooterItemAtPosition.getStickyDrawerItems().size() > position) {
            $this$updateStickyFooterItemAtPosition.getStickyDrawerItems().set(position, drawerItem);
        }
        $this$updateStickyFooterItemAtPosition.handleStickyFooterView$materialdrawer();
    }

    public static final void addStickyFooterItem(@NotNull MaterialDrawerSliderView $this$addStickyFooterItem, @NotNull IDrawerItem<?> drawerItem) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$addStickyFooterItem), (String)"$this$addStickyFooterItem");
        Intrinsics.checkNotNullParameter(drawerItem, (String)"drawerItem");
        $this$addStickyFooterItem.getStickyDrawerItems().add(drawerItem);
        $this$addStickyFooterItem.handleStickyFooterView$materialdrawer();
    }

    public static final void addStickyDrawerItems(@NotNull MaterialDrawerSliderView $this$addStickyDrawerItems, IDrawerItem<?> ... stickyDrawerItems) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$addStickyDrawerItems), (String)"$this$addStickyDrawerItems");
        Intrinsics.checkNotNullParameter(stickyDrawerItems, (String)"stickyDrawerItems");
        Collections.addAll((Collection)$this$addStickyDrawerItems.getStickyDrawerItems(), Arrays.copyOf(stickyDrawerItems, stickyDrawerItems.length));
        $this$addStickyDrawerItems.handleStickyFooterView$materialdrawer();
    }

    public static final void addStickyFooterItemAtPosition(@NotNull MaterialDrawerSliderView $this$addStickyFooterItemAtPosition, @NotNull IDrawerItem<?> drawerItem, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$addStickyFooterItemAtPosition), (String)"$this$addStickyFooterItemAtPosition");
        Intrinsics.checkNotNullParameter(drawerItem, (String)"drawerItem");
        $this$addStickyFooterItemAtPosition.getStickyDrawerItems().add(position, drawerItem);
        $this$addStickyFooterItemAtPosition.handleStickyFooterView$materialdrawer();
    }

    public static final void setStickyFooterItemAtPosition(@NotNull MaterialDrawerSliderView $this$setStickyFooterItemAtPosition, @NotNull IDrawerItem<?> drawerItem, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$setStickyFooterItemAtPosition), (String)"$this$setStickyFooterItemAtPosition");
        Intrinsics.checkNotNullParameter(drawerItem, (String)"drawerItem");
        if ($this$setStickyFooterItemAtPosition.getStickyDrawerItems().size() > position) {
            $this$setStickyFooterItemAtPosition.getStickyDrawerItems().set(position, drawerItem);
        }
        $this$setStickyFooterItemAtPosition.handleStickyFooterView$materialdrawer();
    }

    public static final void removeStickyFooterItemAtPosition(@NotNull MaterialDrawerSliderView $this$removeStickyFooterItemAtPosition, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$removeStickyFooterItemAtPosition), (String)"$this$removeStickyFooterItemAtPosition");
        if ($this$removeStickyFooterItemAtPosition.getStickyDrawerItems().size() > position) {
            $this$removeStickyFooterItemAtPosition.getStickyDrawerItems().remove(position);
        }
        $this$removeStickyFooterItemAtPosition.handleStickyFooterView$materialdrawer();
    }

    public static final void removeAllStickyFooterItems(@NotNull MaterialDrawerSliderView $this$removeAllStickyFooterItems) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$removeAllStickyFooterItems), (String)"$this$removeAllStickyFooterItems");
        $this$removeAllStickyFooterItems.getStickyDrawerItems().clear();
        $this$removeAllStickyFooterItems.handleStickyFooterView$materialdrawer();
    }
}

