/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialize;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.IdRes;
import android.support.v4.content.ContextCompat;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.mikepenz.materialize.Materialize;
import com.mikepenz.materialize.R;
import com.mikepenz.materialize.util.UIUtils;
import com.mikepenz.materialize.view.IScrimInsetsLayout;
import com.mikepenz.materialize.view.ScrimInsetsFrameLayout;

public class MaterializeBuilder {
    protected Activity mActivity;
    protected ViewGroup mRootView;
    protected ViewGroup mContentRoot;
    protected IScrimInsetsLayout mScrimInsetsLayout;
    protected boolean mUseScrimInsetsLayout = true;
    protected int mStatusBarColor = 0;
    protected int mStatusBarColorRes = -1;
    protected boolean mTransparentStatusBar = false;
    protected boolean mTranslucentStatusBarProgrammatically = false;
    protected boolean mStatusBarPadding = false;
    protected boolean mTintStatusBar = true;
    protected boolean mTranslucentNavigationBarProgrammatically = false;
    protected boolean mTransparentNavigationBar = false;
    protected boolean mNavigationBarPadding = false;
    protected boolean mTintNavigationBar = false;
    protected boolean mFullscreen = false;
    protected boolean mSystemUIHidden = false;
    protected ViewGroup mContainer = null;
    protected ViewGroup.LayoutParams mContainerLayoutParams = null;

    public MaterializeBuilder() {
    }

    public MaterializeBuilder(Activity activity) {
        this.mRootView = (ViewGroup)activity.findViewById(0x1020002);
        this.mActivity = activity;
    }

    public MaterializeBuilder withActivity(Activity activity) {
        this.mRootView = (ViewGroup)activity.findViewById(0x1020002);
        this.mActivity = activity;
        return this;
    }

    public MaterializeBuilder withRootView(ViewGroup rootView) {
        this.mRootView = rootView;
        return this;
    }

    public MaterializeBuilder withRootView(@IdRes int rootViewRes) {
        if (this.mActivity == null) {
            throw new RuntimeException("please pass an activity first to use this call");
        }
        return this.withRootView((ViewGroup)this.mActivity.findViewById(rootViewRes));
    }

    public MaterializeBuilder withUseScrimInsetsLayout(boolean useScrimInsetsLayout) {
        this.mUseScrimInsetsLayout = useScrimInsetsLayout;
        return this;
    }

    public MaterializeBuilder withStatusBarColor(@ColorInt int statusBarColor) {
        this.mStatusBarColor = statusBarColor;
        return this;
    }

    public MaterializeBuilder withStatusBarColorRes(@ColorRes int statusBarColorRes) {
        this.mStatusBarColorRes = statusBarColorRes;
        return this;
    }

    public MaterializeBuilder withTransparentStatusBar(boolean transparentStatusBar) {
        this.mTransparentStatusBar = transparentStatusBar;
        return this;
    }

    public MaterializeBuilder withTranslucentStatusBarProgrammatically(boolean translucentStatusBarProgrammatically) {
        this.mTranslucentStatusBarProgrammatically = translucentStatusBarProgrammatically;
        return this;
    }

    public MaterializeBuilder withStatusBarPadding(boolean statusBarPadding) {
        this.mStatusBarPadding = statusBarPadding;
        return this;
    }

    public MaterializeBuilder withTintedStatusBar(boolean tintedStatusBar) {
        this.mTintStatusBar = tintedStatusBar;
        return this;
    }

    public MaterializeBuilder withTranslucentNavigationBarProgrammatically(boolean translucentNavigationBarProgrammatically) {
        this.mTranslucentNavigationBarProgrammatically = translucentNavigationBarProgrammatically;
        return this;
    }

    public MaterializeBuilder withTransparentNavigationBar(boolean navigationBar) {
        this.mTransparentNavigationBar = navigationBar;
        return this;
    }

    public MaterializeBuilder withNavigationBarPadding(boolean navigationBarPadding) {
        this.mNavigationBarPadding = navigationBarPadding;
        return this;
    }

    public MaterializeBuilder withTintedNavigationBar(boolean tintedNavigationBar) {
        this.mTintNavigationBar = tintedNavigationBar;
        if (tintedNavigationBar) {
            this.withTranslucentNavigationBarProgrammatically(true);
        }
        return this;
    }

    public MaterializeBuilder withFullscreen(boolean fullscreen) {
        this.mFullscreen = fullscreen;
        if (fullscreen) {
            this.withTranslucentNavigationBarProgrammatically(true);
            this.withTintedStatusBar(false);
            this.withTintedNavigationBar(false);
        }
        return this;
    }

    public MaterializeBuilder withSystemUIHidden(boolean systemUIHidden) {
        this.mSystemUIHidden = systemUIHidden;
        if (systemUIHidden) {
            this.withFullscreen(systemUIHidden);
        }
        return this;
    }

    public MaterializeBuilder withContainer(ViewGroup container) {
        this.mContainer = container;
        return this;
    }

    public MaterializeBuilder withContainerLayoutParams(ViewGroup.LayoutParams layoutParams) {
        this.mContainerLayoutParams = layoutParams;
        return this;
    }

    public MaterializeBuilder withContainer(ViewGroup container, ViewGroup.LayoutParams layoutParams) {
        this.mContainer = container;
        this.mContainerLayoutParams = layoutParams;
        return this;
    }

    public Materialize build() {
        View originalContentView;
        if (this.mActivity == null) {
            throw new RuntimeException("please pass an activity");
        }
        if (this.mUseScrimInsetsLayout) {
            boolean alreadyInflated;
            this.mScrimInsetsLayout = (ScrimInsetsFrameLayout)this.mActivity.getLayoutInflater().inflate(R.layout.materialize, this.mRootView, false);
            if (this.mRootView == null || this.mRootView.getChildCount() == 0) {
                throw new RuntimeException("You have to set your layout for this activity with setContentView() first. Or you build the drawer on your own with .buildView()");
            }
            originalContentView = this.mRootView.getChildAt(0);
            boolean bl = alreadyInflated = originalContentView.getId() == R.id.materialize_root;
            if (this.mStatusBarColor == 0 && this.mStatusBarColorRes != -1) {
                this.mStatusBarColor = ContextCompat.getColor((Context)this.mActivity, (int)this.mStatusBarColorRes);
            } else if (this.mStatusBarColor == 0) {
                this.mStatusBarColor = UIUtils.getThemeColorFromAttrOrRes((Context)this.mActivity, R.attr.colorPrimaryDark, R.color.materialize_primary_dark);
            }
            this.mScrimInsetsLayout.setInsetForeground(this.mStatusBarColor);
            this.mScrimInsetsLayout.setTintStatusBar(this.mTintStatusBar);
            this.mScrimInsetsLayout.setTintNavigationBar(this.mTintNavigationBar);
            this.mScrimInsetsLayout.setSystemUIVisible(!this.mFullscreen && !this.mSystemUIHidden);
            if (!alreadyInflated) {
                this.mRootView.removeView(originalContentView);
            } else {
                this.mRootView.removeAllViews();
            }
            FrameLayout.LayoutParams layoutParamsContentView = new FrameLayout.LayoutParams(-1, -1);
            this.mScrimInsetsLayout.getView().addView(originalContentView, (ViewGroup.LayoutParams)layoutParamsContentView);
            this.mContentRoot = this.mScrimInsetsLayout.getView();
            if (this.mContainer != null) {
                this.mContentRoot = this.mContainer;
                this.mContentRoot.addView((View)this.mScrimInsetsLayout.getView(), new ViewGroup.LayoutParams(-1, -1));
            }
            this.mContentRoot.setId(R.id.materialize_root);
            if (this.mContainerLayoutParams == null) {
                this.mContainerLayoutParams = new ViewGroup.LayoutParams(-1, -1);
            }
            this.mRootView.addView((View)this.mContentRoot, this.mContainerLayoutParams);
        } else {
            if (this.mContainer == null) {
                throw new RuntimeException("please pass a container");
            }
            originalContentView = this.mRootView.getChildAt(0);
            this.mRootView.removeView(originalContentView);
            FrameLayout.LayoutParams layoutParamsContentView = new FrameLayout.LayoutParams(-1, -1);
            this.mContainer.addView(originalContentView, (ViewGroup.LayoutParams)layoutParamsContentView);
            if (this.mContainerLayoutParams == null) {
                this.mContainerLayoutParams = new ViewGroup.LayoutParams(-1, -1);
            }
            this.mRootView.addView((View)this.mContainer, this.mContainerLayoutParams);
        }
        if (this.mSystemUIHidden && Build.VERSION.SDK_INT >= 16) {
            View decorView = this.mActivity.getWindow().getDecorView();
            decorView.setSystemUiVisibility(5894);
        }
        if (this.mTranslucentStatusBarProgrammatically && Build.VERSION.SDK_INT >= 21) {
            UIUtils.setTranslucentStatusFlag(this.mActivity, false);
        }
        if (this.mTranslucentNavigationBarProgrammatically && Build.VERSION.SDK_INT >= 21) {
            UIUtils.setTranslucentNavigationFlag(this.mActivity, true);
        }
        if ((this.mTransparentStatusBar || this.mTransparentNavigationBar) && Build.VERSION.SDK_INT >= 21) {
            this.mActivity.getWindow().addFlags(Integer.MIN_VALUE);
        }
        if (this.mTransparentStatusBar && Build.VERSION.SDK_INT >= 21) {
            UIUtils.setTranslucentStatusFlag(this.mActivity, false);
            this.mActivity.getWindow().setStatusBarColor(0);
        }
        if (this.mTransparentNavigationBar && Build.VERSION.SDK_INT >= 21) {
            UIUtils.setTranslucentNavigationFlag(this.mActivity, true);
            this.mActivity.getWindow().setNavigationBarColor(0);
        }
        int paddingTop = 0;
        if (this.mStatusBarPadding && Build.VERSION.SDK_INT >= 21) {
            paddingTop = UIUtils.getStatusBarHeight((Context)this.mActivity);
        }
        int paddingBottom = 0;
        if (this.mNavigationBarPadding && Build.VERSION.SDK_INT >= 21) {
            paddingBottom = UIUtils.getNavigationBarHeight((Context)this.mActivity);
        }
        if (this.mStatusBarPadding || this.mNavigationBarPadding && Build.VERSION.SDK_INT >= 21) {
            this.mScrimInsetsLayout.getView().setPadding(0, paddingTop, 0, paddingBottom);
        }
        this.mActivity = null;
        return new Materialize(this);
    }
}

