/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.common.utils;

import com.mikuac.shiro.annotation.MessageHandlerFilter;
import com.mikuac.shiro.common.utils.CacheUtils;
import com.mikuac.shiro.common.utils.CheckResult;
import com.mikuac.shiro.common.utils.RegexUtils;
import com.mikuac.shiro.common.utils.ShiroUtils;
import com.mikuac.shiro.dto.event.message.GroupMessageEvent;
import com.mikuac.shiro.dto.event.message.MessageEvent;
import com.mikuac.shiro.enums.AtEnum;
import com.mikuac.shiro.enums.CommonEnum;
import com.mikuac.shiro.enums.MsgTypeEnum;
import com.mikuac.shiro.enums.ReplyEnum;
import com.mikuac.shiro.exception.ShiroException;
import com.mikuac.shiro.model.ArrayMsg;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommonUtils {
    public static final String CMD_DEFAULT_VALUE = "";
    private static final CacheUtils cache = new CacheUtils();

    private CommonUtils() {
    }

    public static boolean atCheck(List<ArrayMsg> arrayMsg, long selfId, AtEnum at) {
        Optional<ArrayMsg> opt = Optional.ofNullable(CommonUtils.atParse(arrayMsg, selfId));
        return switch (at) {
            case AtEnum.NEED -> opt.map(item -> {
                long target = Long.parseLong(item.getData().get("qq"));
                return target == 0L || target != selfId;
            }).orElse(true);
            case AtEnum.NOT_NEED -> opt.map(item -> {
                long target = Long.parseLong(item.getData().get("qq"));
                return target == selfId;
            }).orElse(false);
            default -> false;
        };
    }

    public static CheckResult allFilterCheck(MessageEvent event, long selfId, MessageHandlerFilter filter) {
        CheckResult result = CommonUtils.filterCheck(event, selfId, filter);
        if (filter.invert()) {
            result.changeResult();
            result.setMatcher(null);
        }
        return result;
    }

    private static CheckResult filterCheck(MessageEvent event, long selfId, MessageHandlerFilter filter) {
        boolean flag;
        boolean flag2;
        Optional<Object> matcherOptional = Optional.empty();
        String rawMessage = filter.at().equals((Object)AtEnum.NEED) ? CommonUtils.msgExtract(event.getMessage(), event.getArrayMsg(), filter.at(), event.getSelfId()) : event.getMessage();
        if (!filter.cmd().isBlank() && (matcherOptional = RegexUtils.matcher(filter.cmd(), rawMessage)).isEmpty()) {
            return new CheckResult();
        }
        if (CommonEnum.GROUP.value().equals(event.getMessageType()) && filter.at() != AtEnum.OFF && CommonUtils.atCheck(event.getArrayMsg(), selfId, filter.at())) {
            return new CheckResult();
        }
        if (!filter.reply().equals((Object)ReplyEnum.OFF)) {
            Optional<ArrayMsg> reply = event.getArrayMsg().stream().filter(e -> e.getType() == MsgTypeEnum.reply).findFirst();
            switch (filter.reply()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case OFF: {
                    throw new ShiroException("exception that cannot be thrown");
                }
                case NONE: {
                    boolean bl = reply.isEmpty();
                    break;
                }
                case REPLY_ALL: {
                    boolean bl = reply.isPresent();
                    break;
                }
                case REPLY_ME: {
                    boolean bl = reply.map(e -> e.getData().get("qq").equals(String.valueOf(selfId))).orElse(false);
                    break;
                }
                case REPLY_OTHER: {
                    boolean bl = flag2 = reply.map(e -> !e.getData().get("qq").equals(String.valueOf(selfId))).orElse(false).booleanValue();
                }
            }
            if (!flag2) {
                return new CheckResult();
            }
        }
        if (filter.types().length != 0 && !(flag = event.getArrayMsg().stream().anyMatch(e -> Arrays.binarySearch((Object[])filter.types(), (Object)e.getType()) >= 0))) {
            return new CheckResult();
        }
        if (filter.groups().length != 0 && CommonEnum.GROUP.value().equals(event.getMessageType())) {
            GroupMessageEvent groupMessageEvent = (GroupMessageEvent)event;
            boolean bl = flag2 = Arrays.binarySearch(cache.getSortedGroups(filter.groups()), groupMessageEvent.getGroupId()) >= 0;
            if (!flag2) {
                return new CheckResult();
            }
        }
        if (filter.senders().length != 0) {
            long[] senders = filter.senders();
            Arrays.sort(senders);
            boolean bl = flag2 = Arrays.binarySearch(cache.getSortedSenders(filter.senders()), event.getUserId()) >= 0;
            if (!flag2) {
                return new CheckResult();
            }
        }
        if (filter.startWith().length != 0) {
            boolean flag3 = false;
            for (String start : filter.startWith()) {
                flag3 = rawMessage.startsWith(start);
                if (!flag3) continue;
                if (!matcherOptional.isEmpty()) break;
                matcherOptional = RegexUtils.matcher("(" + start + ")(.*)", rawMessage);
                break;
            }
            if (!flag3) {
                return new CheckResult();
            }
        }
        if (filter.endWith().length != 0) {
            boolean flag4 = false;
            for (String end : filter.endWith()) {
                flag4 = rawMessage.endsWith(end);
                if (!flag4) continue;
                if (!matcherOptional.isEmpty()) break;
                matcherOptional = RegexUtils.matcher("(.*)(" + end + ")", rawMessage);
                break;
            }
            if (!flag4) {
                return new CheckResult();
            }
        }
        return new CheckResult().setResult(true).setMatcher(matcherOptional.orElse(null));
    }

    public static String msgExtract(String msg, List<ArrayMsg> arrayMsg, AtEnum atEnum, long selfId) {
        if (atEnum != AtEnum.NEED) {
            return msg;
        }
        ArrayMsg item = CommonUtils.atParse(arrayMsg, selfId);
        if (item != null) {
            String code = ShiroUtils.arrayMsgToCode(arrayMsg.get(arrayMsg.indexOf(item)));
            return msg.replace(code, CMD_DEFAULT_VALUE).trim();
        }
        return msg;
    }

    public static ArrayMsg atParse(List<ArrayMsg> arrayMsg, long selfId) {
        if (arrayMsg.isEmpty()) {
            return null;
        }
        int index = 0;
        ArrayMsg item = arrayMsg.get(index);
        String rawTarget = item.getData().getOrDefault("qq", "0");
        long target = Long.parseLong(CommonEnum.AT_ALL.value().equals(rawTarget) ? "0" : rawTarget);
        index = arrayMsg.size() - 1;
        if ((target == 0L || target != selfId) && index >= 0) {
            item = arrayMsg.get(index);
            index = arrayMsg.size() - 2;
            if (MsgTypeEnum.text == item.getType() && index >= 0) {
                item = arrayMsg.get(index);
            }
            rawTarget = item.getData().getOrDefault("qq", "0");
            target = Long.parseLong(CommonEnum.AT_ALL.value().equals(rawTarget) ? "0" : rawTarget);
            if (target == 0L || target != selfId) {
                return null;
            }
        }
        return item;
    }

    public static Map<Class<?>, Object> matcher(String cmd, String msg) {
        HashMap params = new HashMap();
        if (!CMD_DEFAULT_VALUE.equals(cmd)) {
            Optional<Matcher> match = RegexUtils.matcher(cmd, msg);
            if (match.isEmpty()) {
                return null;
            }
            params.put(Matcher.class, match.get());
        }
        return params;
    }

    public static String debugMsgDeleteBase64Content(String msg) {
        String regex = "base64://[a-zA-Z\\d+/=]+";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(msg);
        return matcher.replaceAll("(base64)");
    }
}

