/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.common.utils;

import com.mikuac.shiro.core.Bot;
import com.mikuac.shiro.core.BotFactory;
import com.mikuac.shiro.core.CoreEvent;
import com.mikuac.shiro.enums.AdapterEnum;
import com.mikuac.shiro.enums.SessionStatusEnum;
import com.mikuac.shiro.exception.ShiroException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.WebSocketSession;

public class ConnectionUtils {
    private static final Logger log = LoggerFactory.getLogger(ConnectionUtils.class);

    private ConnectionUtils() {
    }

    public static SessionStatusEnum getSessionStatus(WebSocketSession session) {
        Map sessionContext = session.getAttributes();
        SessionStatusEnum statusObj = sessionContext.getOrDefault("session_status", SessionStatusEnum.DIE);
        if (statusObj instanceof SessionStatusEnum) {
            SessionStatusEnum status = statusObj;
            return status;
        }
        throw new ShiroException("session status type wrong");
    }

    public static void handleReConnect(Bot bot, long xSelfId, WebSocketSession session) {
        SessionStatusEnum status;
        log.info("Account {} reconnected", (Object)xSelfId);
        Map oldSessionContext = bot.getSession().getAttributes();
        Object v = oldSessionContext.get("session_status");
        if (v instanceof SessionStatusEnum && SessionStatusEnum.ONLINE.equals((Object)(status = (SessionStatusEnum)((Object)v)))) {
            session.close();
            return;
        }
        oldSessionContext.computeIfPresent("future", (e, obj) -> {
            ScheduledFuture future;
            if (obj instanceof ScheduledFuture && (future = (ScheduledFuture)obj).getDelay(TimeUnit.MILLISECONDS) > 0L) {
                future.cancel(false);
            }
            return null;
        });
        oldSessionContext.clear();
        bot.setSession(session);
    }

    public static Bot handleFirstConnect(long xSelfId, WebSocketSession session, BotFactory botFactory, CoreEvent coreEvent) {
        log.info("Account {} connected", (Object)xSelfId);
        Bot bot = botFactory.createBot(xSelfId, session);
        coreEvent.online(bot);
        return bot;
    }

    public static long parseSelfId(WebSocketSession session) {
        String selfIdStr = Optional.ofNullable(session.getHandshakeHeaders().getFirst("x-self-id")).orElse((String)session.getAttributes().get("x-self-id"));
        try {
            return Long.parseLong(selfIdStr);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public static boolean checkToken(WebSocketSession session, String token) {
        if (token.isEmpty()) {
            return true;
        }
        String clientToken = session.getHandshakeHeaders().getFirst("authorization");
        log.debug("Access Token: {}", (Object)clientToken);
        if (clientToken == null || clientToken.isEmpty()) {
            return false;
        }
        return token.equals(clientToken);
    }

    public static AdapterEnum getAdapter(WebSocketSession session) {
        Map sessionContext = session.getAttributes();
        Object adapterObj = sessionContext.get("adapter");
        if (adapterObj instanceof AdapterEnum) {
            AdapterEnum adapter = (AdapterEnum)((Object)adapterObj);
            return adapter;
        }
        throw new ShiroException("adapter type wrong");
    }
}

