/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.common.utils;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetUtils {
    private static final Logger log = LoggerFactory.getLogger(NetUtils.class);

    private NetUtils() {
    }

    public static String asyncGet(String url, int timeout) {
        HttpClient client = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(timeout)).build();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).build();
        CompletionStage result = client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body);
        try {
            return (String)((CompletableFuture)result).get();
        }
        catch (ExecutionException e) {
            log.error("NetUtils async get exception: {}", (Object)e.getMessage(), (Object)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return null;
    }
}

