/*
 * Decompiled with CFR 0.152.
 */
package com.mikuac.shiro.core;

import com.mikuac.shiro.annotation.common.Order;
import com.mikuac.shiro.annotation.common.Shiro;
import com.mikuac.shiro.common.utils.AopTargetUtils;
import com.mikuac.shiro.common.utils.ScanUtils;
import com.mikuac.shiro.core.Bot;
import com.mikuac.shiro.exception.ShiroException;
import com.mikuac.shiro.handler.ActionHandler;
import com.mikuac.shiro.model.HandlerMethod;
import com.mikuac.shiro.properties.ShiroProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.socket.WebSocketSession;

@Component
public class BotFactory {
    private static final Logger log = LoggerFactory.getLogger(BotFactory.class);
    private static Set<Class<?>> annotations = new LinkedHashSet();
    private ActionHandler actionHandler;
    private ShiroProperties shiroProperties;
    private ApplicationContext applicationContext;

    @Autowired
    public void setActionHandler(ActionHandler actionHandler) {
        this.actionHandler = actionHandler;
    }

    @Autowired
    public void setShiroProperties(ShiroProperties shiroProperties) {
        this.shiroProperties = shiroProperties;
    }

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    private static Set<Class<?>> getAnnotations() {
        if (!annotations.isEmpty()) {
            return annotations;
        }
        annotations = new ScanUtils().scanAnnotation("com.mikuac.shiro.annotation");
        return annotations;
    }

    public Bot createBot(long selfId, WebSocketSession session) {
        log.debug("Start creating bot instance: {}", (Object)selfId);
        HashMap beans = new HashMap(this.applicationContext.getBeansWithAnnotation(Shiro.class));
        LinkedMultiValueMap annotationHandler = new LinkedMultiValueMap();
        beans.values().forEach(arg_0 -> BotFactory.lambda$createBot$2((MultiValueMap)annotationHandler, arg_0));
        this.sort((MultiValueMap<Class<? extends Annotation>, HandlerMethod>)annotationHandler);
        return new Bot(selfId, session, this.actionHandler, this.shiroProperties.getPluginList(), (MultiValueMap<Class<? extends Annotation>, HandlerMethod>)annotationHandler, this.shiroProperties.getInterceptor());
    }

    private void sort(MultiValueMap<Class<? extends Annotation>, HandlerMethod> annotationHandler) {
        if (annotationHandler.isEmpty()) {
            return;
        }
        annotationHandler.keySet().forEach(annotation -> {
            List<HandlerMethod> handlers = (List<HandlerMethod>)annotationHandler.get(annotation);
            handlers = handlers.stream().sorted(Comparator.comparing(handlerMethod -> {
                Order order = handlerMethod.getMethod().getAnnotation(Order.class);
                return Optional.ofNullable(order == null ? null : Integer.valueOf(order.value())).orElse(Integer.MAX_VALUE);
            })).toList();
            annotationHandler.put(annotation, handlers);
        });
    }

    private static /* synthetic */ void lambda$createBot$2(MultiValueMap annotationHandler, Object obj) {
        Object target;
        try {
            target = AopTargetUtils.getTarget(obj);
        }
        catch (Exception e) {
            throw new ShiroException(e);
        }
        Class<?> beanClass = target.getClass();
        Arrays.stream(beanClass.getMethods()).forEach(method -> {
            HandlerMethod handlerMethod = new HandlerMethod();
            handlerMethod.setMethod((Method)method);
            handlerMethod.setType(beanClass);
            handlerMethod.setObject(obj);
            Arrays.stream(method.getDeclaredAnnotations()).forEach(annotation -> {
                Class<? extends Annotation> annotationType;
                Set<Class<?>> as = BotFactory.getAnnotations();
                if (as.contains(annotationType = annotation.annotationType())) {
                    annotationHandler.add(annotation.annotationType(), (Object)handlerMethod);
                }
            });
        });
    }
}

